/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.petra.encryptor.Encryptor;
import com.liferay.petra.encryptor.EncryptorException;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.portlet.PortletQNameUtil;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletURLListenerFactory;
import com.liferay.portlet.PublicRenderParametersPool;
import com.liferay.portlet.RenderParametersPool;
import com.liferay.portlet.internal.LiferayMutablePortletParameters;
import com.liferay.portlet.internal.LiferayRenderParameters;
import com.liferay.portlet.internal.MutableActionParametersImpl;
import com.liferay.portlet.internal.MutableRenderParametersImpl;
import com.liferay.portlet.internal.MutableResourceParametersImpl;
import com.liferay.portlet.internal.RenderParametersImpl;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.security.Key;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.portlet.MimeResponse;
import javax.portlet.MutableActionParameters;
import javax.portlet.MutableRenderParameters;
import javax.portlet.MutableResourceParameters;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.portlet.annotations.PortletSerializable;
import javax.portlet.annotations.RenderStateScoped;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PortletURLImpl
implements LiferayPortletURL,
PortletURL,
ResourceURL,
Serializable {
    private static final String _ACTION_PARAMETER_NAMESPACE = "p_action_p_";
    private static final String _RESOURCE_PARAMETER_NAMESPACE = "p_resource_p_";
    private static final Log _log = LogFactoryUtil.getLog(PortletURLImpl.class);
    private static final Map<String, String> _cacheabilities = HashMapBuilder.put((Object)"FULL", (Object)"cacheLevelFull").put((Object)"PAGE", (Object)"cacheLevelPage").put((Object)"PORTLET", (Object)"cacheLevelPortlet").build();
    private boolean _anchor = true;
    private String _cacheability = "cacheLevelPage";
    private MimeResponse.Copy _copy;
    private boolean _copyCurrentRenderParameters;
    private long _doAsGroupId;
    private long _doAsUserId;
    private String _doAsUserLanguageId;
    private String _encodedNamespace;
    private boolean _encrypt;
    private boolean _escapeXml = PropsValues.PORTLET_URL_ESCAPE_XML;
    private final HttpServletRequest _httpServletRequest;
    private Layout _layout;
    private String _layoutFriendlyURL;
    private String _lifecycle;
    private MutableActionParametersImpl _mutableActionParametersImpl;
    private MutableRenderParametersImpl _mutableRenderParametersImpl;
    private MutableResourceParametersImpl _mutableResourceParametersImpl;
    private String _namespace;
    private Set<String> _parametersIncludedInPath;
    private long _plid;
    private Portlet _portlet;
    private String _portletModeString;
    private final PortletRequest _portletRequest;
    private final int _portletSpecMajorVersion;
    private Map<String, String[]> _portletURLParameterMap;
    private long _refererGroupId;
    private long _refererPlid;
    private Set<String> _removedParameterNames;
    private final Set<String> _removePublicRenderParameters;
    private String _resourceID;
    private boolean _secure;
    private String _toString;
    private boolean _windowStateRestoreCurrentView;
    private String _windowStateString;

    public PortletURLImpl(HttpServletRequest httpServletRequest, Portlet portlet, Layout layout, String lifecycle, MimeResponse.Copy copy) {
        this(httpServletRequest, portlet, null, layout, lifecycle, copy);
    }

    public PortletURLImpl(PortletRequest portletRequest, Portlet portlet, Layout layout, String lifecycle, MimeResponse.Copy copy) {
        this(PortalUtil.getHttpServletRequest((PortletRequest)portletRequest), portlet, portletRequest, layout, lifecycle, copy);
    }

    public void addParameterIncludedInPath(String name) {
        if (this._parametersIncludedInPath.isEmpty()) {
            this._parametersIncludedInPath = new LinkedHashSet<String>();
        }
        this._parametersIncludedInPath.add(name);
    }

    public void addProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
    }

    public Appendable append(Appendable appendable) throws IOException {
        return this.append(appendable, true);
    }

    public Appendable append(Appendable appendable, boolean escapeXml) throws IOException {
        String toString = this.toString();
        if (escapeXml && !this._escapeXml) {
            toString = HtmlUtil.escape((String)toString);
        }
        return appendable.append(toString);
    }

    public MutableActionParameters getActionParameters() {
        if (this._portletSpecMajorVersion < 3) {
            throw new UnsupportedOperationException("Requires 3.0 opt-in");
        }
        return this._mutableActionParametersImpl;
    }

    public String getCacheability() {
        return this._cacheability;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._httpServletRequest;
    }

    public Layout getLayout() {
        block6: {
            if (this._layout == null) {
                try {
                    Layout layout = (Layout)this._httpServletRequest.getAttribute("LAYOUT");
                    if (layout != null && layout.getPlid() == this._plid) {
                        this._layout = layout;
                    } else if (this._plid > 0L) {
                        this._layout = LayoutLocalServiceUtil.getLayout((long)this._plid);
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)("Layout cannot be found for " + this._plid), (Throwable)exception);
                }
            }
        }
        return this._layout;
    }

    public String getLayoutFriendlyURL() {
        return this._layoutFriendlyURL;
    }

    public String getLifecycle() {
        return this._lifecycle;
    }

    public String getNamespace() {
        if (this._namespace == null) {
            this._namespace = PortalUtil.getPortletNamespace((String)this._portlet.getPortletId());
        }
        return this._namespace;
    }

    @Deprecated
    public String getParameter(String name) {
        Object[] values = this._portletURLParameterMap.get(name);
        if (ArrayUtil.isNotEmpty((Object[])values)) {
            return values[0];
        }
        return null;
    }

    @Deprecated
    public Map<String, String[]> getParameterMap() {
        return this._portletURLParameterMap;
    }

    public Set<String> getParametersIncludedInPath() {
        return this._parametersIncludedInPath;
    }

    public long getPlid() {
        return this._plid;
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public String getPortletFriendlyURLPath() {
        String portletFriendlyURLPath = null;
        if (this._portlet.isUndeployedPortlet()) {
            return portletFriendlyURLPath;
        }
        FriendlyURLMapper friendlyURLMapper = this._portlet.getFriendlyURLMapperInstance();
        if (friendlyURLMapper != null) {
            portletFriendlyURLPath = friendlyURLMapper.buildPath((LiferayPortletURL)this);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Portlet friendly URL path " + portletFriendlyURLPath));
            }
        }
        return portletFriendlyURLPath;
    }

    public String getPortletId() {
        return this._portlet.getPortletId();
    }

    public PortletMode getPortletMode() {
        if (this._portletModeString == null) {
            return null;
        }
        return PortletModeFactory.getPortletMode((String)this._portletModeString);
    }

    public PortletRequest getPortletRequest() {
        return this._portletRequest;
    }

    public Set<String> getRemovedParameterNames() {
        return this._removedParameterNames;
    }

    public MutableRenderParameters getRenderParameters() {
        if (this._portletSpecMajorVersion < 3) {
            throw new UnsupportedOperationException("Requires 3.0 opt-in");
        }
        return this._mutableRenderParametersImpl;
    }

    public String getResourceID() {
        return this._resourceID;
    }

    public MutableResourceParameters getResourceParameters() {
        if (this._portletSpecMajorVersion < 3) {
            throw new UnsupportedOperationException("Requires 3.0 opt-in");
        }
        return this._mutableResourceParametersImpl;
    }

    public WindowState getWindowState() {
        if (this._windowStateString == null) {
            return null;
        }
        return WindowStateFactory.getWindowState((String)this._windowStateString);
    }

    public boolean isAnchor() {
        return this._anchor;
    }

    public boolean isCopyCurrentRenderParameters() {
        return this._copyCurrentRenderParameters;
    }

    public boolean isEncrypt() {
        return this._encrypt;
    }

    public boolean isEscapeXml() {
        return this._escapeXml;
    }

    public boolean isParameterIncludedInPath(String name) {
        if (this._parametersIncludedInPath.contains(name)) {
            return true;
        }
        return name.startsWith("p_r_p_") && this._parametersIncludedInPath.contains(name = name.substring("p_r_p_".length()));
    }

    public boolean isSecure() {
        return this._secure;
    }

    @Deprecated
    public void removePublicRenderParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this._portlet.isUndeployedPortlet()) {
            return;
        }
        PublicRenderParameter publicRenderParameter = this._portlet.getPublicRenderParameter(name);
        if (publicRenderParameter == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Public parameter " + name + "does not exist"));
            }
            return;
        }
        this._removePublicRenderParameters.add(PortletQNameUtil.getRemovePublicRenderParameterName((QName)publicRenderParameter.getQName()));
    }

    public void setAnchor(boolean anchor) {
        this._anchor = anchor;
        this.clearCache();
    }

    public void setBeanParameter(PortletSerializable portletSerializable) {
        if (this._portletSpecMajorVersion < 3) {
            throw new UnsupportedOperationException("Requires 3.0 opt-in");
        }
        if (portletSerializable == null) {
            throw new IllegalArgumentException();
        }
        Class<?> portletSerializableClass = portletSerializable.getClass();
        RenderStateScoped renderStateScoped = portletSerializableClass.getAnnotation(RenderStateScoped.class);
        if (renderStateScoped == null) {
            throw new IllegalArgumentException("Class not annotated with @RenderStateScoped");
        }
        String paramName = renderStateScoped.paramName();
        if (Validator.isNull((String)paramName)) {
            paramName = portletSerializableClass.getSimpleName();
            if (paramName.endsWith("$$EnhancerBySpringCGLIB")) {
                paramName = paramName.substring(0, paramName.length() - "$$EnhancerBySpringCGLIB".length());
            } else if (paramName.endsWith("$Proxy$_$$_WeldClientProxy")) {
                paramName = paramName.substring(0, paramName.length() - "$Proxy$_$$_WeldClientProxy".length());
            }
        }
        MutableRenderParameters mutableRenderParameters = this.getRenderParameters();
        mutableRenderParameters.setValues(paramName, portletSerializable.serialize());
    }

    public void setCacheability(String cacheability) {
        ResourceRequest resourceRequest;
        String parentCacheability;
        if (cacheability == null) {
            throw new IllegalArgumentException("Cacheability is null");
        }
        String mappedCacheability = _cacheabilities.getOrDefault(cacheability, cacheability);
        if (!(mappedCacheability.equals("cacheLevelFull") || mappedCacheability.equals("cacheLevelPage") || mappedCacheability.equals("cacheLevelPortlet"))) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Cacheability ", cacheability, " is not FULL, ", "cacheLevelFull", ", PAGE, ", "cacheLevelPage", ", or PORTLET, ", "cacheLevelPortlet"}));
        }
        if (this._portletRequest instanceof ResourceRequest && ((parentCacheability = (resourceRequest = (ResourceRequest)this._portletRequest).getCacheability()).equals("cacheLevelFull") ? !mappedCacheability.equals("cacheLevelFull") : parentCacheability.equals("cacheLevelPortlet") && !mappedCacheability.equals("cacheLevelFull") && !mappedCacheability.equals("cacheLevelPortlet"))) {
            throw new IllegalStateException("Unable to set a weaker cacheability " + cacheability);
        }
        this._cacheability = mappedCacheability;
        this.clearCache();
    }

    public void setCopyCurrentRenderParameters(boolean copyCurrentRenderParameters) {
        if (this._portletSpecMajorVersion < 3) {
            this._copyCurrentRenderParameters = copyCurrentRenderParameters;
            return;
        }
        boolean changed = false;
        if (this._copyCurrentRenderParameters != copyCurrentRenderParameters) {
            changed = true;
        }
        this._copyCurrentRenderParameters = copyCurrentRenderParameters;
        if (changed) {
            this._initMutableRenderParameters();
        }
    }

    public void setDoAsGroupId(long doAsGroupId) {
        this._doAsGroupId = doAsGroupId;
        this.clearCache();
    }

    public void setDoAsUserId(long doAsUserId) {
        this._doAsUserId = doAsUserId;
        this.clearCache();
    }

    public void setDoAsUserLanguageId(String doAsUserLanguageId) {
        this._doAsUserLanguageId = doAsUserLanguageId;
        this.clearCache();
    }

    public void setEncrypt(boolean encrypt) {
        this._encrypt = encrypt;
        this.clearCache();
    }

    public void setEscapeXml(boolean escapeXml) {
        this._escapeXml = escapeXml;
        this.clearCache();
    }

    public void setLifecycle(String lifecycle) {
        this._lifecycle = lifecycle;
        this.clearCache();
    }

    @Deprecated
    public void setParameter(String name, String value) {
        this.setParameter(name, value, PropsValues.PORTLET_URL_APPEND_PARAMETERS);
    }

    @Deprecated
    public void setParameter(String name, String ... values) {
        this.setParameter(name, values, PropsValues.PORTLET_URL_APPEND_PARAMETERS);
    }

    @Deprecated
    public void setParameter(String name, String value, boolean append) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this._portletSpecMajorVersion < 3) {
            if (value == null) {
                if (this._portletURLParameterMap.containsKey(name)) {
                    this._portletURLParameterMap.remove(name);
                }
                return;
            }
            this.setParameter(name, new String[]{value}, append);
            return;
        }
        LiferayMutablePortletParameters liferayMutablePortletParameters = this._getMutablePortletParameters(name);
        if (name.startsWith("priv_r_p_")) {
            name = name.substring("priv_r_p_".length());
        }
        if (value == null) {
            liferayMutablePortletParameters.removeParameter(name);
        }
        liferayMutablePortletParameters.setValue(name, value, append);
    }

    @Deprecated
    public void setParameter(String name, String[] values, boolean append) {
        if (name == null || values == null && this._portletSpecMajorVersion < 3) {
            throw new IllegalArgumentException();
        }
        LiferayMutablePortletParameters liferayMutablePortletParameters = null;
        if (this._portletSpecMajorVersion >= 3) {
            liferayMutablePortletParameters = this._getMutablePortletParameters(name);
            if (name.startsWith("priv_r_p_")) {
                name = name.substring("priv_r_p_".length());
            }
            if (values == null) {
                liferayMutablePortletParameters.removeParameter(name);
                return;
            }
        }
        for (String value : values) {
            if (value != null) continue;
            throw new IllegalArgumentException();
        }
        if (this._portletSpecMajorVersion >= 3) {
            liferayMutablePortletParameters.setValues(name, values, append);
            return;
        }
        if (!append) {
            this._portletURLParameterMap.put(name, values);
        } else {
            Object[] oldValues = this._portletURLParameterMap.get(name);
            if (oldValues == null) {
                this._portletURLParameterMap.put(name, values);
            } else {
                String[] newValues = (String[])ArrayUtil.append((Object[])oldValues, (Object[])values);
                this._portletURLParameterMap.put(name, newValues);
            }
        }
        this.clearCache();
    }

    @Deprecated
    public void setParameters(Map<String, String[]> params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap<String, String[]> newParams = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            try {
                String key = entry.getKey();
                if (key == null) {
                    throw new IllegalArgumentException();
                }
                String[] value = entry.getValue();
                if (value == null) {
                    throw new IllegalArgumentException();
                }
                newParams.put(key, value);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(classCastException);
            }
        }
        if (this._portletSpecMajorVersion >= 3) {
            this._mutableRenderParametersImpl.clear();
            if (this._mutableActionParametersImpl != null) {
                this._mutableActionParametersImpl.clear();
            }
            if (this._mutableResourceParametersImpl != null) {
                this._mutableResourceParametersImpl.clear();
            }
            for (Map.Entry<String, Object> entry : newParams.entrySet()) {
                this.setParameter(entry.getKey(), (String[])entry.getValue());
            }
        } else {
            this._portletURLParameterMap = newParams;
        }
        this.clearCache();
    }

    public void setPlid(long plid) {
        this._plid = plid;
        this.clearCache();
    }

    public void setPortletId(String portletId) {
        this._portlet = PortletLocalServiceUtil.getPortletById((long)PortalUtil.getCompanyId((HttpServletRequest)this._httpServletRequest), (String)portletId);
        this.clearCache();
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (this._portletRequest != null && !this._portlet.isUndeployedPortlet() && !this._portlet.hasPortletMode(this._portletRequest.getResponseContentType(), portletMode)) {
            throw new PortletModeException(portletMode.toString(), portletMode);
        }
        this._portletModeString = portletMode.toString();
        this.clearCache();
    }

    public void setPortletMode(String portletMode) throws PortletModeException {
        this.setPortletMode(PortletModeFactory.getPortletMode((String)portletMode));
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
    }

    public void setRefererGroupId(long refererGroupId) {
        this._refererGroupId = refererGroupId;
        this.clearCache();
    }

    public void setRefererPlid(long refererPlid) {
        this._refererPlid = refererPlid;
        this.clearCache();
    }

    public void setRemovedParameterNames(Set<String> removedParameterNames) {
        this._removedParameterNames = removedParameterNames;
        this.clearCache();
    }

    public void setResourceID(String resourceID) {
        this._resourceID = resourceID;
        this.clearCache();
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        this._secure = secure;
        this.clearCache();
    }

    public void setWindowState(String windowState) throws WindowStateException {
        this.setWindowState(WindowStateFactory.getWindowState((String)windowState));
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (this._portletRequest != null && !this._portletRequest.isWindowStateAllowed(windowState)) {
            throw new WindowStateException(windowState.toString(), windowState);
        }
        if (LiferayWindowState.isWindowStatePreserved((WindowState)this.getWindowState(), (WindowState)windowState)) {
            this._windowStateString = windowState.toString();
        }
        this.clearCache();
    }

    public void setWindowStateRestoreCurrentView(boolean windowStateRestoreCurrentView) {
        this._windowStateRestoreCurrentView = windowStateRestoreCurrentView;
    }

    public String toString() {
        if (this._portletSpecMajorVersion < 3) {
            if (this._toString != null) {
                return this._toString;
            }
        } else {
            MutableActionParametersImpl mutableActionParameters = this._mutableActionParametersImpl;
            MutableResourceParametersImpl mutableResourceParameters = this._mutableResourceParametersImpl;
            if (!(this._mutableRenderParametersImpl.isMutated() || mutableActionParameters == null || mutableActionParameters.isMutated() || mutableResourceParameters == null || mutableResourceParameters.isMutated() || this._toString == null)) {
                return this._toString;
            }
        }
        this._callPortletURLGenerationListener();
        this._toString = this.generateToString();
        return this._toString;
    }

    public void visitReservedParameters(BiConsumer<String, String> biConsumer) {
        biConsumer.accept("p_p_id", this._portlet.getPortletId());
        if (this._lifecycle.equals("ACTION_PHASE")) {
            biConsumer.accept("p_p_lifecycle", "1");
        } else if (this._lifecycle.equals("RENDER_PHASE")) {
            biConsumer.accept("p_p_lifecycle", "0");
        } else if (this._lifecycle.equals("RESOURCE_PHASE")) {
            biConsumer.accept("p_p_lifecycle", "2");
        }
        if (this._windowStateString != null && !this._cacheability.equals("cacheLevelFull")) {
            biConsumer.accept("p_p_state", this._windowStateString);
        }
        if (this._windowStateRestoreCurrentView) {
            biConsumer.accept("p_p_state_rcv", "1");
        }
        if (this._portletModeString != null && !this._cacheability.equals("cacheLevelFull")) {
            biConsumer.accept("p_p_mode", this._portletModeString);
        }
        if (this._resourceID != null) {
            biConsumer.accept("p_p_resource_id", this._resourceID);
        }
        if (this._lifecycle.equals("RESOURCE_PHASE")) {
            biConsumer.accept("p_p_cacheability", this._cacheability);
        }
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, this._escapeXml);
    }

    public void write(Writer writer, boolean escapeXml) throws IOException {
        String toString = this.toString();
        if (escapeXml && !this._escapeXml) {
            toString = HtmlUtil.escape((String)toString);
        }
        writer.write(toString);
    }

    protected void clearCache() {
        this._toString = null;
    }

    /*
     * WARNING - void declaration
     */
    protected String generateToString() {
        void var13_22;
        Object layoutAssetEntry;
        long refererPlid;
        long refererGroupId;
        long doAsGroupId;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to generate string because theme display is null");
            }
            return "";
        }
        try {
            Layout layout;
            if (this._layoutFriendlyURL == null && (layout = this.getLayout()) != null) {
                this._layoutFriendlyURL = GetterUtil.getString((String)PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay));
                if (this._secure) {
                    this._layoutFriendlyURL = HttpUtil.protocolize((String)this._layoutFriendlyURL, (int)PropsValues.WEB_SERVER_HTTPS_PORT, (boolean)true);
                }
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        StringBundler sb = new StringBundler(64);
        Key key = this._getKey();
        if (Validator.isNull((String)this._layoutFriendlyURL)) {
            sb.append(PortalUtil.getPortalURL((HttpServletRequest)this._httpServletRequest, (boolean)this._secure));
            sb.append(themeDisplay.getPathMain());
            sb.append("/portal/layout?p_l_id=");
            sb.append(this.processValue(key, this._plid));
            sb.append("&");
        } else {
            if (!this._layoutFriendlyURL.startsWith("http://") && !this._layoutFriendlyURL.startsWith("https://")) {
                sb.append(PortalUtil.getPortalURL((HttpServletRequest)this._httpServletRequest, (boolean)this._secure));
            }
            sb.append(this._layoutFriendlyURL);
            String friendlyURLPath = this.getPortletFriendlyURLPath();
            if (Validator.isNotNull((String)friendlyURLPath)) {
                sb.append("/-");
                sb.append(friendlyURLPath);
            }
            sb.append("?");
        }
        AuthTokenUtil.addCSRFToken((HttpServletRequest)this._httpServletRequest, (LiferayPortletURL)this);
        AuthTokenUtil.addPortletInvocationToken((HttpServletRequest)this._httpServletRequest, (LiferayPortletURL)this);
        this.visitReservedParameters((name, value) -> {
            if (!this.isParameterIncludedInPath((String)name)) {
                sb.append(name);
                sb.append("=");
                sb.append(this.processValue(key, (String)value));
                sb.append("&");
            }
        });
        if (this._doAsUserId > 0L) {
            sb.append("doAsUserId=");
            sb.append(this.processValue(key, this._doAsUserId));
            sb.append("&");
        } else {
            String doAsUserId = themeDisplay.getDoAsUserId();
            if (Validator.isNotNull((String)doAsUserId)) {
                sb.append("doAsUserId=");
                sb.append(this.processValue(key, doAsUserId));
                sb.append("&");
            }
        }
        String doAsUserLanguageId = this._doAsUserLanguageId;
        if (Validator.isNull((String)doAsUserLanguageId)) {
            doAsUserLanguageId = themeDisplay.getDoAsUserLanguageId();
        }
        if (Validator.isNotNull((String)doAsUserLanguageId)) {
            sb.append("doAsUserLanguageId=");
            sb.append(this.processValue(key, doAsUserLanguageId));
            sb.append("&");
        }
        if ((doAsGroupId = this._doAsGroupId) <= 0L) {
            doAsGroupId = themeDisplay.getDoAsGroupId();
        }
        if (doAsGroupId > 0L) {
            sb.append("doAsGroupId=");
            sb.append(this.processValue(key, doAsGroupId));
            sb.append("&");
        }
        if ((refererGroupId = this._refererGroupId) <= 0L) {
            refererGroupId = themeDisplay.getRefererGroupId();
        }
        if (refererGroupId > 0L) {
            sb.append("refererGroupId=");
            sb.append(this.processValue(key, refererGroupId));
            sb.append("&");
        }
        if ((refererPlid = this._refererPlid) <= 0L) {
            refererPlid = themeDisplay.getRefererPlid();
        }
        if (refererPlid > 0L) {
            sb.append("refererPlid=");
            sb.append(this.processValue(key, refererPlid));
            sb.append("&");
        }
        if (!this._removePublicRenderParameters.isEmpty()) {
            String lastString = sb.stringAt(sb.index() - 1);
            if (lastString.charAt(lastString.length() - 1) != '&') {
                sb.append("&");
            }
            for (String string : this._removePublicRenderParameters) {
                sb.append(URLCodec.encodeURL((String)string));
                sb.append("=");
                sb.append("&");
            }
        }
        if ((layoutAssetEntry = this._httpServletRequest.getAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY")) instanceof AssetEntry) {
            AssetEntry assetEntry = (AssetEntry)layoutAssetEntry;
            if (this._layout != null && this._layout.isTypeAssetDisplay() && assetEntry != null) {
                sb.append("assetEntryId=");
                sb.append(assetEntry.getEntryId());
                sb.append("&");
            }
        }
        Map<String, String[]> portletURLParams = this._portletURLParameterMap;
        if (this._portletSpecMajorVersion < 3) {
            if (!(!this._copyCurrentRenderParameters || this._lifecycle.equals("RESOURCE_PHASE") && this._cacheability.equals("cacheLevelFull"))) {
                portletURLParams = this._mergeWithRenderParametersV2(portletURLParams);
            }
        } else {
            portletURLParams = this._combineAllParametersV3();
        }
        for (Map.Entry<String, String[]> entry : portletURLParams.entrySet()) {
            String publicRenderParameterName;
            String[] values = entry.getValue();
            if (values == null) continue;
            String name2 = entry.getKey();
            if (!this._lifecycle.equals("RESOURCE_PHASE") && Validator.isNotNull((String)(publicRenderParameterName = this.getPublicRenderParameterName(name2)))) {
                name2 = publicRenderParameterName;
            }
            if (name2.startsWith(_ACTION_PARAMETER_NAMESPACE)) {
                name2 = name2.substring(_ACTION_PARAMETER_NAMESPACE.length());
            } else if (name2.startsWith(_RESOURCE_PARAMETER_NAMESPACE)) {
                name2 = name2.substring(_RESOURCE_PARAMETER_NAMESPACE.length());
            }
            if (this.isParameterIncludedInPath(name2)) continue;
            for (String value2 : values) {
                this._appendNamespaceAndEncode(sb, name2);
                sb.append("=");
                if (value2 == null) {
                    sb.append(this.processValue(key, "_!null!_"));
                } else {
                    sb.append(this.processValue(key, value2));
                }
                sb.append("&");
            }
        }
        if (this._encrypt) {
            sb.append("shuo");
            sb.append("=1");
        } else {
            sb.setIndex(sb.index() - 1);
        }
        String string = sb.toString();
        if (!CookieKeys.hasSessionId((HttpServletRequest)this._httpServletRequest)) {
            HttpSession httpSession = this._httpServletRequest.getSession();
            String string2 = PortalUtil.getURLWithSessionId((String)string, (String)httpSession.getId());
        }
        if (!this._escapeXml) {
            void var13_15;
            String string3 = HttpUtil.shortenURL((String)var13_15);
        }
        if (PropsValues.PORTLET_URL_ANCHOR_ENABLE && this._anchor && this._windowStateString != null && !this._windowStateString.equals(WindowState.MAXIMIZED.toString()) && !this._windowStateString.equals(LiferayWindowState.EXCLUSIVE.toString()) && !this._windowStateString.equals(LiferayWindowState.POP_UP.toString())) {
            void var13_17;
            sb.setIndex(0);
            sb.append((String)var13_17);
            sb.append("#p_");
            sb.append(URLCodec.encodeURL((String)this._portlet.getPortletId()));
            String string4 = sb.toString();
        }
        if (this._escapeXml) {
            void var13_19;
            String string6 = HtmlUtil.escape((String)var13_19);
            string6 = HttpUtil.shortenURL((String)string6);
        }
        return var13_22;
    }

    protected String getPublicRenderParameterName(String name) {
        PublicRenderParameter publicRenderParameter;
        String publicRenderParameterName = null;
        if (!this._portlet.isUndeployedPortlet() && (publicRenderParameter = this._portlet.getPublicRenderParameter(name)) != null) {
            publicRenderParameterName = PortletQNameUtil.getPublicRenderParameterName((QName)publicRenderParameter.getQName());
        }
        return publicRenderParameterName;
    }

    protected String processValue(Key key, long value) {
        return this.processValue(key, String.valueOf(value));
    }

    protected String processValue(Key key, String value) {
        if (key == null) {
            return URLCodec.encodeURL((String)value);
        }
        try {
            return URLCodec.encodeURL((String)Encryptor.encrypt((Key)key, (String)value));
        }
        catch (EncryptorException encryptorException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)encryptorException, (Throwable)encryptorException);
            }
            return value;
        }
    }

    private PortletURLImpl(HttpServletRequest httpServletRequest, Portlet portlet, PortletRequest portletRequest, Layout layout, String lifecycle, MimeResponse.Copy copy) {
        if (portlet == null) {
            throw new NullPointerException("Portlet is null");
        }
        this._httpServletRequest = httpServletRequest;
        this._portlet = portlet;
        this._portletRequest = portletRequest;
        this._layout = layout;
        this._lifecycle = lifecycle;
        this._copy = copy;
        this._parametersIncludedInPath = Collections.emptySet();
        PortletApp portletApp = portlet.getPortletApp();
        this._portletSpecMajorVersion = portletApp.getSpecMajorVersion();
        this._portletURLParameterMap = this._portletSpecMajorVersion < 3 ? new LinkedHashMap<String, String[]>() : new PortletURLParameterMap();
        this._removePublicRenderParameters = new LinkedHashSet<String>();
        this._secure = PortalUtil.isSecure((HttpServletRequest)httpServletRequest);
        if (lifecycle.equals("RESOURCE_PHASE")) {
            this._copyCurrentRenderParameters = true;
        }
        if (this._portletSpecMajorVersion >= 3) {
            if (lifecycle.equals("ACTION_PHASE")) {
                this._mutableActionParametersImpl = new MutableActionParametersImpl(new LinkedHashMap<String, String[]>());
            } else if (lifecycle.equals("RESOURCE_PHASE")) {
                this._mutableResourceParametersImpl = new MutableResourceParametersImpl(new LinkedHashMap<String, String[]>());
            }
            this._initMutableRenderParameters();
        }
        if (!portlet.isUndeployedPortlet()) {
            Set autopropagatedParameters = portlet.getAutopropagatedParameters();
            for (String autopropagatedParameter : autopropagatedParameters) {
                String value;
                if (PortalUtil.isReservedParameter((String)autopropagatedParameter) || (value = httpServletRequest.getParameter(autopropagatedParameter)) == null) continue;
                this.setParameter(autopropagatedParameter, value);
            }
            this._escapeXml = MapUtil.getBoolean((Map)portletApp.getContainerRuntimeOptions(), (String)"javax.portlet.escapeXml", (boolean)PropsValues.PORTLET_URL_ESCAPE_XML);
        }
        if (layout != null) {
            this._plid = layout.getPlid();
        }
    }

    private void _appendNamespaceAndEncode(StringBundler sb, String name) {
        String namespace = this.getNamespace();
        if (!(name.startsWith("p_r_p_") || name.startsWith(namespace) || PortalUtil.isReservedParameter((String)name))) {
            if (this._encodedNamespace == null) {
                this._encodedNamespace = URLCodec.encodeURL((String)namespace);
            }
            sb.append(this._encodedNamespace);
        }
        sb.append(URLCodec.encodeURL((String)name));
    }

    private void _callPortletURLGenerationListener() {
        PortletApp portletApp = this._portlet.getPortletApp();
        for (PortletURLListener portletURLListener : portletApp.getPortletURLListeners()) {
            try {
                PortletURLGenerationListener portletURLGenerationListener = PortletURLListenerFactory.create(portletURLListener);
                if (this._lifecycle.equals("ACTION_PHASE")) {
                    portletURLGenerationListener.filterActionURL((PortletURL)this);
                    continue;
                }
                if (this._lifecycle.equals("RENDER_PHASE")) {
                    portletURLGenerationListener.filterRenderURL((PortletURL)this);
                    continue;
                }
                if (!this._lifecycle.equals("RESOURCE_PHASE")) continue;
                portletURLGenerationListener.filterResourceURL((ResourceURL)this);
            }
            catch (PortletException portletException) {
                _log.error((Object)portletException, (Throwable)portletException);
            }
        }
    }

    private Map<String, String[]> _combineAllParametersV3() {
        String namespace = this.getNamespace();
        LinkedHashMap<String, String[]> portletURLParams = new LinkedHashMap<String, String[]>();
        Set actionParameterNames = Collections.emptySet();
        if (this._mutableActionParametersImpl != null) {
            actionParameterNames = new HashSet();
            Map<String, String[]> mutableActionParameterMap = this._mutableActionParametersImpl.getParameterMap();
            for (Map.Entry<String, String[]> entry : mutableActionParameterMap.entrySet()) {
                String actionParameterName = entry.getKey();
                if (actionParameterName.startsWith(namespace)) {
                    actionParameterName = actionParameterName.substring(namespace.length());
                }
                actionParameterNames.add(actionParameterName);
                portletURLParams.put(_ACTION_PARAMETER_NAMESPACE.concat(actionParameterName), entry.getValue());
            }
        }
        Set resourceParameterNames = Collections.emptySet();
        if (this._mutableResourceParametersImpl != null) {
            resourceParameterNames = new HashSet();
            Map<String, String[]> mutableResourceParameterMap = this._mutableResourceParametersImpl.getParameterMap();
            for (Map.Entry<String, String[]> entry : mutableResourceParameterMap.entrySet()) {
                String resourceParameterName = entry.getKey();
                if (resourceParameterName.startsWith(namespace)) {
                    resourceParameterName = resourceParameterName.substring(namespace.length());
                }
                resourceParameterNames.add(resourceParameterName);
                portletURLParams.put(_RESOURCE_PARAMETER_NAMESPACE.concat(resourceParameterName), entry.getValue());
            }
        }
        if (!this._lifecycle.equals("RESOURCE_PHASE") || this._lifecycle.equals("RESOURCE_PHASE") && this._copyCurrentRenderParameters && !this._cacheability.equals("cacheLevelFull")) {
            Map<String, String[]> mutableRenderParameterMap = this._mutableRenderParametersImpl.getParameterMap();
            for (Map.Entry<String, String[]> entry : mutableRenderParameterMap.entrySet()) {
                String renderParameterName = entry.getKey();
                if (renderParameterName.startsWith(namespace)) {
                    renderParameterName = renderParameterName.substring(namespace.length());
                }
                if (resourceParameterNames.contains(renderParameterName) || this._lifecycle.equals("RESOURCE_PHASE") && this._mutableRenderParametersImpl.isPublic(renderParameterName) || !this._lifecycle.equals("RESOURCE_PHASE") && this._removedParameterNames != null && this._removedParameterNames.contains(renderParameterName)) continue;
                Object[] renderParameterValues = entry.getValue();
                if (this._mutableRenderParametersImpl.isPublic(renderParameterName)) {
                    portletURLParams.put(renderParameterName, (String[])renderParameterValues);
                    continue;
                }
                if (this._lifecycle.equals("ACTION_PHASE") && actionParameterNames.contains(renderParameterName)) {
                    Object[] actionParameterValues = this._mutableActionParametersImpl.getValues(renderParameterName);
                    if (actionParameterValues != null && this._copyCurrentRenderParameters) {
                        renderParameterValues = (String[])ArrayUtil.append((Object[])actionParameterValues, (Object[])renderParameterValues);
                    }
                    renderParameterName = _ACTION_PARAMETER_NAMESPACE.concat(renderParameterName);
                } else if (this._lifecycle.equals("RENDER_PHASE")) {
                    LiferayRenderParameters renderParameters;
                    Object[] requestRenderParameterValues;
                    PortletRequest portletRequest = this.getPortletRequest();
                    if (portletRequest != null && (requestRenderParameterValues = (renderParameters = (LiferayRenderParameters)portletRequest.getRenderParameters()).getValues(renderParameterName)) != null && this._copyCurrentRenderParameters && !Arrays.equals(requestRenderParameterValues, renderParameterValues)) {
                        renderParameterValues = (String[])ArrayUtil.append((Object[])renderParameterValues, (Object[])requestRenderParameterValues);
                    }
                } else {
                    renderParameterName = "priv_r_p_".concat(renderParameterName);
                }
                portletURLParams.put(renderParameterName, (String[])renderParameterValues);
            }
        }
        return portletURLParams;
    }

    private Key _getKey() {
        try {
            if (this._encrypt) {
                Company company = PortalUtil.getCompany((HttpServletRequest)this._httpServletRequest);
                return company.getKeyObj();
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get company key", (Throwable)exception);
        }
        return null;
    }

    private LiferayMutablePortletParameters _getMutablePortletParameters(String parameterName) {
        if (this._lifecycle.equals("ACTION_PHASE") && !this._mutableRenderParametersImpl.isPublic(parameterName) && !parameterName.startsWith("priv_r_p_")) {
            return this._mutableActionParametersImpl;
        }
        if (this._lifecycle.equals("RESOURCE_PHASE")) {
            return this._mutableResourceParametersImpl;
        }
        return this._mutableRenderParametersImpl;
    }

    private void _initMutableRenderParameters() {
        HashSet<String> publicRenderParameterNames;
        LinkedHashMap<String, Object> mutableRenderParameterMap = null;
        if (this._portletRequest == null) {
            long plid = 0L;
            if (this._layout != null) {
                plid = this._layout.getPlid();
            }
            publicRenderParameterNames = new HashSet();
            if (MimeResponse.Copy.ALL.equals((Object)this._copy) || MimeResponse.Copy.PUBLIC.equals((Object)this._copy) || this._copyCurrentRenderParameters) {
                Map<String, String[]> privateRenderParameterMap = RenderParametersPool.get(this._httpServletRequest, plid, this._portlet.getPortletId());
                mutableRenderParameterMap = privateRenderParameterMap == null ? new LinkedHashMap() : new LinkedHashMap<String, String[]>(privateRenderParameterMap);
                Map<String, String[]> publicRenderParametersMap = PublicRenderParametersPool.get(this._httpServletRequest, plid);
                Set publicRenderParameters = this._portlet.getPublicRenderParameters();
                for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
                    Object[] values = publicRenderParametersMap.get(PortletQNameUtil.getPublicRenderParameterName((QName)publicRenderParameter.getQName()));
                    if (ArrayUtil.isEmpty((Object[])values) || Validator.isNull((String)values[0])) continue;
                    String name = publicRenderParameter.getIdentifier();
                    mutableRenderParameterMap.put(name, (String[])values);
                    publicRenderParameterNames.add(name);
                }
            }
            if (mutableRenderParameterMap == null) {
                mutableRenderParameterMap = new LinkedHashMap();
            }
        } else {
            mutableRenderParameterMap = new LinkedHashMap<String, String[]>();
            RenderParametersImpl liferayRenderParametersImpl = (RenderParametersImpl)this._portletRequest.getRenderParameters();
            publicRenderParameterNames = liferayRenderParametersImpl.getPublicRenderParameterNames();
            if (MimeResponse.Copy.ALL.equals((Object)this._copy) || MimeResponse.Copy.PUBLIC.equals((Object)this._copy)) {
                Map<String, String[]> liferayRenderParameterMap = liferayRenderParametersImpl.getParameterMap();
                for (Map.Entry<String, String[]> entry : liferayRenderParameterMap.entrySet()) {
                    String renderParameterName = entry.getKey();
                    if (!MimeResponse.Copy.ALL.equals((Object)this._copy) && !liferayRenderParametersImpl.isPublic(renderParameterName)) continue;
                    mutableRenderParameterMap.put(renderParameterName, entry.getValue());
                }
            }
        }
        this._mutableRenderParametersImpl = new MutableRenderParametersImpl(mutableRenderParameterMap, publicRenderParameterNames);
    }

    private boolean _isBlankValue(String[] value) {
        return value != null && value.length == 1 && value[0].equals("");
    }

    private Map<String, String[]> _mergeWithRenderParametersV2(Map<String, String[]> portletURLParams) {
        Map<String, String[]> renderParameters = RenderParametersPool.get(this._httpServletRequest, this._plid, this._portlet.getPortletId());
        if (renderParameters == null) {
            return portletURLParams;
        }
        String namespace = this.getNamespace();
        LinkedHashMap<String, String[]> mergedRenderParams = new LinkedHashMap<String, String[]>(portletURLParams);
        for (Map.Entry<String, String[]> entry : renderParameters.entrySet()) {
            String name = entry.getKey();
            if (name.startsWith(namespace)) {
                name = name.substring(namespace.length());
            }
            if (!this._lifecycle.equals("RESOURCE_PHASE") && this._removedParameterNames != null && this._removedParameterNames.contains(name)) continue;
            Object[] oldValues = entry.getValue();
            Object[] newValues = this._portletURLParameterMap.get(name);
            if (newValues == null) {
                mergedRenderParams.put(name, (String[])oldValues);
                continue;
            }
            if (this._isBlankValue((String[])newValues)) {
                mergedRenderParams.remove(name);
                continue;
            }
            newValues = (String[])ArrayUtil.append((Object[])newValues, (Object[])oldValues);
            mergedRenderParams.put(name, (String[])newValues);
        }
        return mergedRenderParams;
    }

    private class PortletURLParameterMap
    extends AbstractMap<String, String[]> {
        private Set<Map.Entry<String, String[]>> _entrySet;

        private PortletURLParameterMap() {
        }

        @Override
        public Set<Map.Entry<String, String[]>> entrySet() {
            if (this._entrySet == null || PortletURLImpl.this._mutableRenderParametersImpl != null && PortletURLImpl.this._mutableRenderParametersImpl.isMutated() || PortletURLImpl.this._mutableActionParametersImpl != null && PortletURLImpl.this._mutableActionParametersImpl.isMutated() || PortletURLImpl.this._mutableResourceParametersImpl != null && PortletURLImpl.this._mutableResourceParametersImpl.isMutated()) {
                this._entrySet = new LinkedHashSet<Map.Entry<String, String[]>>();
                if (PortletURLImpl.this._mutableResourceParametersImpl != null) {
                    Map<String, String[]> mutableResourceParameterMap = PortletURLImpl.this._mutableResourceParametersImpl.getParameterMap();
                    for (Map.Entry<String, String[]> entry : mutableResourceParameterMap.entrySet()) {
                        this._entrySet.add(new AbstractMap.SimpleEntry<String, String[]>(entry.getKey(), entry.getValue()));
                    }
                }
                if (PortletURLImpl.this._mutableActionParametersImpl != null) {
                    Map<String, String[]> mutableActionParameterMap = PortletURLImpl.this._mutableActionParametersImpl.getParameterMap();
                    for (Map.Entry<String, String[]> entry : mutableActionParameterMap.entrySet()) {
                        this._entrySet.add(new AbstractMap.SimpleEntry<String, String[]>(entry.getKey(), entry.getValue()));
                    }
                }
                if (PortletURLImpl.this._mutableRenderParametersImpl != null && !PortletURLImpl.this._lifecycle.equals("RESOURCE_PHASE")) {
                    Map<String, String[]> mutableRenderParameterMap = PortletURLImpl.this._mutableRenderParametersImpl.getParameterMap();
                    for (Map.Entry<String, String[]> entry : mutableRenderParameterMap.entrySet()) {
                        this._entrySet.add(new AbstractMap.SimpleEntry<String, String[]>(entry.getKey(), entry.getValue()));
                    }
                }
            }
            return this._entrySet;
        }

        @Override
        public String[] put(String key, String[] value) {
            Set<Map.Entry<String, String[]>> entrySet = this.entrySet();
            for (Map.Entry<String, String[]> entry : entrySet) {
                String entryKey = entry.getKey();
                if (!entryKey.equals(key)) continue;
                String[] oldValues = entry.getValue();
                entry.setValue(value);
                return oldValues;
            }
            entrySet.add(new AbstractMap.SimpleEntry<String, String[]>(key, value));
            return null;
        }
    }
}

