/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLServerLimitStringUtil {
    private static final Pattern _qualifiedColumnPattern = Pattern.compile("\\w+\\.([\\w\\*]+)");
    private static final Pattern _selectPattern = Pattern.compile("(SELECT(?: DISTINCT)?) ", 2);

    public static String getLimitString(String sql, int offset, int limit) {
        String sqlLowerCase = StringUtil.toLowerCase((String)sql);
        int fromPos = sqlLowerCase.indexOf(" from ");
        String selectFrom = sql.substring(0, fromPos);
        int orderByPos = sqlLowerCase.lastIndexOf(" order by ");
        String selectFromWhere = null;
        String orderBy = "";
        if (orderByPos > 0) {
            selectFromWhere = sql.substring(fromPos, orderByPos);
            orderBy = sql.substring(orderByPos + 9);
        } else {
            selectFromWhere = sql.substring(fromPos);
        }
        String[] splitOrderBy = SQLServerLimitStringUtil._splitOrderBy(selectFrom, orderBy);
        String innerOrderBy = splitOrderBy[0];
        String outerOrderBy = splitOrderBy[1];
        return StringBundler.concat((Object[])new Object[]{"select * from (select *, row_number() over (", outerOrderBy, ") as _page_row_num from (", SQLServerLimitStringUtil._getInnerSelectFrom(selectFrom, innerOrderBy, limit), selectFromWhere, innerOrderBy, " ) _temp_table_1 ) _temp_table_2 where _page_row_num between ", offset + 1, " and ", limit, " order by _page_row_num"});
    }

    private static String _getInnerSelectFrom(String selectFrom, String innerOrderBy, int limit) {
        String innerSelectFrom = selectFrom;
        if (Validator.isNotNull((String)innerOrderBy)) {
            Matcher matcher = _selectPattern.matcher(innerSelectFrom);
            innerSelectFrom = matcher.replaceAll(StringBundler.concat((Object[])new Object[]{"$1 top ", limit, " "}));
        }
        return innerSelectFrom;
    }

    private static String[] _splitOrderBy(String selectFrom, String orderBy) {
        String[] orderByColumns;
        StringBundler innerOrderBySB = new StringBundler();
        StringBundler outerOrderBySB = new StringBundler();
        for (String orderByColumn : orderByColumns = StringUtil.split((String)orderBy, (char)',')) {
            String patternString;
            Pattern pattern;
            Matcher matcher;
            int parenPos;
            String orderByColumnName = orderByColumn = orderByColumn.trim();
            String orderByType = "ASC";
            int spacePos = orderByColumn.lastIndexOf(32);
            if (spacePos != -1 && (parenPos = orderByColumn.indexOf(40, spacePos)) == -1) {
                orderByColumnName = orderByColumn.substring(0, spacePos);
                orderByType = orderByColumn.substring(spacePos + 1);
            }
            if ((matcher = (pattern = Pattern.compile(patternString = StringBundler.concat((String[])new String[]{"\\Q", orderByColumnName, "\\E as (\\w+)"}), 2)).matcher(selectFrom)).find()) {
                orderByColumnName = matcher.group(1);
            }
            if (selectFrom.contains(orderByColumnName)) {
                if (outerOrderBySB.length() == 0) {
                    outerOrderBySB.append(" order by ");
                } else {
                    outerOrderBySB.append(",");
                }
                matcher = _qualifiedColumnPattern.matcher(orderByColumnName);
                orderByColumnName = matcher.replaceAll("$1");
                outerOrderBySB.append(orderByColumnName);
                outerOrderBySB.append(" ");
                outerOrderBySB.append(orderByType);
                continue;
            }
            if (innerOrderBySB.length() == 0) {
                innerOrderBySB.append(" order by ");
            } else {
                innerOrderBySB.append(",");
            }
            if (orderByColumnName.endsWith("ASC")) {
                orderByColumnName = orderByColumnName.substring(0, orderByColumnName.lastIndexOf("ASC"));
                orderByType = "ASC";
            } else if (orderByColumnName.endsWith("DESC")) {
                orderByColumnName = orderByColumnName.substring(0, orderByColumnName.lastIndexOf("DESC"));
                orderByType = "DESC";
            }
            innerOrderBySB.append(orderByColumnName);
            innerOrderBySB.append(" ");
            innerOrderBySB.append(orderByType);
        }
        if (outerOrderBySB.length() == 0) {
            outerOrderBySB.append(" order by CURRENT_TIMESTAMP");
        }
        return new String[]{innerOrderBySB.toString(), outerOrderBySB.toString()};
    }
}

