/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.index;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.portal.db.DBResourceUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.module.util.BundleUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.ReleaseLocalServiceUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class IndexUpdaterUtil {
    private static final Log _log = LogFactoryUtil.getLog(IndexUpdaterUtil.class);
    private static final DCLSingleton<ExecutorService> _executorServiceDCLSingleton = new DCLSingleton();
    private static final List<Future<?>> _futures = Collections.synchronizedList(new ArrayList());
    private static final Set<String> _processedServletContextNames = ConcurrentHashMap.newKeySet();

    public static void updateAllIndexes() {
        LoggingTimer loggingTimer;
        block3: {
            loggingTimer = new LoggingTimer("Updating database indexes");
            if (!_processedServletContextNames.contains("portal")) {
                try {
                    IndexUpdaterUtil._addUpdateIndexesFutures("portal", DBResourceUtil.getPortalTablesSQL(), DBResourceUtil.getPortalIndexesSQL());
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Throwable)exception);
                }
            }
        }
        BundleTracker bundleTracker = new BundleTracker(SystemBundleUtil.getBundleContext(), 32, (BundleTrackerCustomizer)new BundleTrackerCustomizer<Void>(){

            public Void addingBundle(Bundle bundle, BundleEvent bundleEvent) {
                if (BundleUtil.isLiferayServiceBundle((Bundle)bundle)) {
                    try {
                        if (!_processedServletContextNames.contains(bundle.getSymbolicName()) && !IndexUpdaterUtil._isSkipUpdateIndexes(bundle.getSymbolicName())) {
                            IndexUpdaterUtil._addUpdateIndexesFutures(bundle.getSymbolicName(), DBResourceUtil.getModuleTablesSQL(bundle), DBResourceUtil.getModuleIndexesSQL(bundle));
                        }
                    }
                    catch (Exception exception) {
                        _log.error((Throwable)exception);
                    }
                }
                return null;
            }

            public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Void tracked) {
            }

            public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Void tracked) {
            }
        });
        DependencyManagerSyncUtil.registerSyncFutureTask(new FutureTask<Object>(() -> {
            bundleTracker.open();
            DependencyManagerSyncUtil.registerSyncCallable(() -> {
                bundleTracker.close();
                _processedServletContextNames.clear();
                IndexUpdaterUtil._awaitFuturesTermination();
                loggingTimer.close();
                return null;
            });
            return null;
        }), (String)(IndexUpdaterUtil.class.getName() + "-BundleTrackerOpener"));
    }

    public static void updateIndexes(Bundle bundle) {
        try (LoggingTimer loggingTimer = new LoggingTimer("Updating database indexes for " + bundle.getSymbolicName());){
            IndexUpdaterUtil._addUpdateIndexesFutures(bundle.getSymbolicName(), DBResourceUtil.getModuleTablesSQL(bundle), DBResourceUtil.getModuleIndexesSQL(bundle));
            IndexUpdaterUtil._awaitFuturesTermination();
        }
    }

    public static void updatePortalIndexes() {
        LoggingTimer loggingTimer = new LoggingTimer("Updating database indexes for portal");
        try {
            IndexUpdaterUtil._addUpdateIndexesFutures("portal", DBResourceUtil.getPortalTablesSQL(), DBResourceUtil.getPortalIndexesSQL());
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
        }
        finally {
            IndexUpdaterUtil._awaitFuturesTermination();
            loggingTimer.close();
        }
    }

    private static void _addUpdateIndexesFutures(String servletContextName, String tablesSQL, String indexesSQL) {
        _processedServletContextNames.add(servletContextName);
        if (indexesSQL == null || tablesSQL == null) {
            return;
        }
        ExecutorService executorService = IndexUpdaterUtil._getExecutorService();
        Map<String, String> indexesSQLMap = IndexUpdaterUtil._getIndexesSQLMap(indexesSQL);
        for (Map.Entry<String, String> entry : indexesSQLMap.entrySet()) {
            _futures.add(executorService.submit(() -> {
                try {
                    IndexUpdaterUtil._updateIndexes((String)entry.getKey(), (String)entry.getValue());
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }));
        }
    }

    private static void _awaitFuturesTermination() {
        for (Future<?> future : _futures) {
            try {
                future.get();
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
        _futures.clear();
    }

    private static ExecutorService _getExecutorService() {
        return (ExecutorService)_executorServiceDCLSingleton.getSingleton(Executors::newWorkStealingPool);
    }

    private static Map<String, String> _getIndexesSQLMap(String indexesSQL) {
        String[] indexesSQLArray = StringUtil.split((String)indexesSQL, (String)"\n\n");
        LinkedHashMap<String, String> indexesSQLMap = new LinkedHashMap<String, String>();
        for (String element : indexesSQLArray) {
            String tableName = element.substring(element.indexOf("on ") + 3, element.indexOf(" ("));
            indexesSQLMap.put(tableName, element);
        }
        return indexesSQLMap;
    }

    private static boolean _isSkipUpdateIndexes(String bundleSymbolicName) {
        Release release = ReleaseLocalServiceUtil.fetchRelease((String)bundleSymbolicName);
        if (release != null && release.getState() == 0) {
            return false;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Skipped updating database indexes for " + bundleSymbolicName + " since it is not upgraded"));
        }
        return true;
    }

    private static void _updateIndexes(String tableName, String indexesSQL) throws Exception {
        DB db = DBManagerUtil.getDB();
        db.process(companyId -> {
            try (Connection connection = DataAccess.getConnection();){
                db.updateIndexes(connection, tableName, indexesSQL, true);
            }
            catch (Exception exception) {
                String message = new String("Unable to update database indexes for " + tableName);
                if (Validator.isNotNull((Long)companyId)) {
                    message = message + " and company " + companyId;
                }
                _log.error((Object)(message + " due to " + exception.getMessage()));
            }
        });
    }
}

