/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetStagingHandler;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutSetBranchBaseImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import java.io.IOException;

public class LayoutSetBranchImpl
extends LayoutSetBranchBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetBranchImpl.class);
    private LayoutSet _layoutSet;
    private UnicodeProperties _settingsUnicodeProperties;

    public ColorScheme getColorScheme() {
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getTheme().getThemeId(), (String)this.getColorSchemeId());
    }

    public Group getGroup() throws PortalException {
        return GroupLocalServiceUtil.getGroup((long)this.getGroupId());
    }

    public LayoutSet getLayoutSet() {
        if (this._layoutSet != null) {
            return this._layoutSet;
        }
        try {
            this._layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)this.getPrivateLayout());
            LayoutSetStagingHandler layoutSetStagingHandler = LayoutStagingUtil.getLayoutSetStagingHandler((LayoutSet)this._layoutSet);
            if (layoutSetStagingHandler == null) {
                return this._layoutSet;
            }
            this._layoutSet = layoutSetStagingHandler.getLayoutSet();
            return this._layoutSet;
        }
        catch (PortalException | SystemException exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return this._layoutSet;
        }
    }

    public long getLiveLogoId() {
        long logoId = this.getLayoutSet().getLogoId();
        if (logoId == 0L) {
            logoId = this.getLayoutSet().getLiveLogoId();
        }
        return logoId;
    }

    public boolean getLogo() {
        return this.getLogoId() > 0L;
    }

    @Override
    public String getSettings() {
        if (this._settingsUnicodeProperties == null) {
            return super.getSettings();
        }
        return this._settingsUnicodeProperties.toString();
    }

    public UnicodeProperties getSettingsProperties() {
        if (this._settingsUnicodeProperties == null) {
            this._settingsUnicodeProperties = new UnicodeProperties(true);
            try {
                this._settingsUnicodeProperties.load(super.getSettings());
            }
            catch (IOException ioException) {
                _log.error((Throwable)ioException);
            }
        }
        return this._settingsUnicodeProperties;
    }

    public String getSettingsProperty(String key) {
        UnicodeProperties settingsUnicodeProperties = this.getSettingsProperties();
        return settingsUnicodeProperties.getProperty(key);
    }

    public Theme getTheme() {
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getThemeId());
    }

    public String getThemeSetting(String key, String device) {
        boolean controlPanel;
        Theme theme;
        block5: {
            UnicodeProperties settingsUnicodeProperties = this.getSettingsProperties();
            String value = settingsUnicodeProperties.getProperty(ThemeSettingImpl.namespaceProperty(device, key));
            if (value != null) {
                return value;
            }
            theme = null;
            controlPanel = false;
            try {
                Group group = this.getGroup();
                controlPanel = group.isControlPanel();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)exception);
            }
        }
        if (controlPanel) {
            String themeId = PrefsPropsUtil.getString((long)this.getCompanyId(), (String)"control.panel.layout.regular.theme.id");
            theme = ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)themeId);
        } else {
            theme = this.getTheme();
        }
        return theme.getSetting(key);
    }

    public boolean isLayoutSetPrototypeLinkActive() {
        return this.isLayoutSetPrototypeLinkEnabled() && Validator.isNotNull((String)this.getLayoutSetPrototypeUuid());
    }

    public boolean isLogo() {
        return this.getLogo();
    }

    @Override
    public void setSettings(String settings) {
        this._settingsUnicodeProperties = null;
        super.setSettings(settings);
    }

    public void setSettingsProperties(UnicodeProperties settingsUnicodeProperties) {
        this._settingsUnicodeProperties = settingsUnicodeProperties;
        super.setSettings(this._settingsUnicodeProperties.toString());
    }
}

