/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.Collections;
import java.util.Set;

public class InterruptedPortletRequestWhitelistUtil {
    private static final Log _log = LogFactoryUtil.getLog(InterruptedPortletRequestWhitelistUtil.class);
    private static Set<String> _portletInvocationWhitelist;
    private static Set<String> _portletInvocationWhitelistActions;

    public static boolean isPortletInvocationWhitelisted(long companyId, String portletId, String strutsAction) {
        if (_portletInvocationWhitelist.contains(portletId)) {
            return true;
        }
        return Validator.isNotNull((String)strutsAction) && _portletInvocationWhitelistActions.contains(strutsAction) && InterruptedPortletRequestWhitelistUtil._isValidStrutsAction(companyId, portletId, strutsAction);
    }

    public static Set<String> resetPortletInvocationWhitelist() {
        _portletInvocationWhitelist = SetUtil.fromArray((Object[])PropsValues.PORTLET_INTERRUPTED_REQUEST_WHITELIST);
        _portletInvocationWhitelist = _portletInvocationWhitelist.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(_portletInvocationWhitelist);
        return _portletInvocationWhitelist;
    }

    public static Set<String> resetPortletInvocationWhitelistActions() {
        _portletInvocationWhitelistActions = SetUtil.fromArray((Object[])PropsValues.PORTLET_INTERRUPTED_REQUEST_WHITELIST_ACTIONS);
        _portletInvocationWhitelistActions = _portletInvocationWhitelistActions.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(_portletInvocationWhitelistActions);
        return _portletInvocationWhitelistActions;
    }

    private static boolean _isValidStrutsAction(long companyId, String portletId, String strutsAction) {
        block4: {
            try {
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
                if (portlet == null) {
                    return false;
                }
                String strutsPath = strutsAction.substring(1, strutsAction.lastIndexOf(47));
                if (strutsPath.equals(portlet.getStrutsPath()) || strutsPath.equals(portlet.getParentStrutsPath())) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)exception);
            }
        }
        return false;
    }

    static {
        InterruptedPortletRequestWhitelistUtil.resetPortletInvocationWhitelist();
        InterruptedPortletRequestWhitelistUtil.resetPortletInvocationWhitelistActions();
    }
}

