/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.kernel.security.pwd.Toolkit;
import com.liferay.portal.security.pwd.PwdToolkitUtilThreadLocal;

public class PwdToolkitUtil {
    private static final Snapshot<Toolkit> _toolkitSnapshot = new Snapshot(PwdToolkitUtil.class, Toolkit.class, null, true);

    public static String generate(PasswordPolicy passwordPolicy) {
        Toolkit toolkit = (Toolkit)_toolkitSnapshot.get();
        return toolkit.generate(passwordPolicy);
    }

    public static void validate(long companyId, long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException {
        if (!password1.equals(password2)) {
            throw new UserPasswordException.MustMatch(userId);
        }
        if (!LDAPSettingsUtil.isPasswordPolicyEnabled((long)companyId) && PwdToolkitUtilThreadLocal.isValidate()) {
            Toolkit toolkit = (Toolkit)_toolkitSnapshot.get();
            toolkit.validate(userId, password1, password2, passwordPolicy);
        }
    }

    private PwdToolkitUtil() {
    }
}

