/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.NoSuchLayoutRevisionException;
import com.liferay.portal.kernel.exception.NoSuchPortletPreferencesException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletPreferenceValueLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.RecentLayoutRevisionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.service.persistence.LayoutSetBranchPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.comparator.LayoutRevisionCreateDateComparator;
import com.liferay.portal.kernel.util.comparator.LayoutRevisionModifiedDateComparator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.service.base.LayoutRevisionLocalServiceBaseImpl;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class LayoutRevisionLocalServiceImpl
extends LayoutRevisionLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutRevisionLocalServiceImpl.class);
    private static final ThreadLocal<Long> _layoutRevisionId = new CentralizedThreadLocal(LayoutRevisionLocalServiceImpl.class + "._layoutRevisionId", () -> 0L);
    @BeanReference(type=LayoutLocalService.class)
    private LayoutLocalService _layoutLocalService;
    @BeanReference(type=LayoutSetBranchPersistence.class)
    private LayoutSetBranchPersistence _layoutSetBranchPersistence;
    @BeanReference(type=PortletPreferencesLocalService.class)
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @BeanReference(type=PortletPreferenceValueLocalService.class)
    private PortletPreferenceValueLocalService _portletPreferenceValueLocalService;
    @BeanReference(type=RecentLayoutRevisionLocalService.class)
    private RecentLayoutRevisionLocalService _recentLayoutRevisionLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;
    @BeanReference(type=WorkflowInstanceLinkLocalService.class)
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public LayoutRevision addLayoutRevision(long userId, long layoutSetBranchId, long layoutBranchId, long parentLayoutRevisionId, boolean head, long plid, long portletPreferencesPlid, boolean privateLayout, String name, String title, String description, String keywords, String robots, String typeSettings, boolean iconImage, long iconImageId, String themeId, String colorSchemeId, String css, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        LayoutSetBranch layoutSetBranch = this._layoutSetBranchPersistence.findByPrimaryKey(layoutSetBranchId);
        parentLayoutRevisionId = this.getParentLayoutRevisionId(layoutSetBranchId, parentLayoutRevisionId, plid);
        long layoutRevisionId = this.getUniqueLayoutRevisionId();
        LayoutRevision layoutRevision = this.layoutRevisionPersistence.create(layoutRevisionId);
        layoutRevision.setGroupId(layoutSetBranch.getGroupId());
        layoutRevision.setCompanyId(user.getCompanyId());
        layoutRevision.setUserId(user.getUserId());
        layoutRevision.setUserName(user.getFullName());
        layoutRevision.setLayoutSetBranchId(layoutSetBranchId);
        layoutRevision.setLayoutBranchId(layoutBranchId);
        layoutRevision.setParentLayoutRevisionId(parentLayoutRevisionId);
        layoutRevision.setHead(head);
        layoutRevision.setPlid(plid);
        layoutRevision.setPrivateLayout(privateLayout);
        layoutRevision.setName(name);
        layoutRevision.setTitle(title);
        layoutRevision.setDescription(description);
        layoutRevision.setKeywords(keywords);
        layoutRevision.setRobots(robots);
        layoutRevision.setTypeSettings(typeSettings);
        layoutRevision.setIconImageId(iconImageId);
        layoutRevision.setThemeId(themeId);
        layoutRevision.setColorSchemeId(colorSchemeId);
        layoutRevision.setCss(css);
        layoutRevision.setStatus(2);
        layoutRevision.setStatusDate(serviceContext.getModifiedDate(new Date()));
        layoutRevision = (LayoutRevision)this.layoutRevisionPersistence.update((BaseModel)layoutRevision);
        _layoutRevisionId.set(layoutRevision.getLayoutRevisionId());
        if (portletPreferencesPlid == 0L) {
            portletPreferencesPlid = plid;
        }
        this.copyPortletPreferences(layoutRevision, portletPreferencesPlid);
        boolean major = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"major");
        if (major || !this.isWorkflowEnabled(plid)) {
            this.updateMajor(layoutRevision);
        }
        if (this.isWorkflowEnabled(plid)) {
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)layoutRevision.getGroupId(), (long)user.getUserId(), (String)LayoutRevision.class.getName(), (long)layoutRevision.getLayoutRevisionId(), (Object)layoutRevision, (ServiceContext)serviceContext);
        } else {
            this.updateStatus(userId, layoutRevisionId, 0, serviceContext);
        }
        StagingUtil.setRecentLayoutRevisionId((User)user, (long)layoutSetBranchId, (long)plid, (long)layoutRevision.getLayoutRevisionId());
        return layoutRevision;
    }

    public void deleteLayoutLayoutRevisions(long plid) throws PortalException {
        for (LayoutRevision layoutRevision : this.getLayoutRevisions(plid)) {
            this.layoutRevisionLocalService.deleteLayoutRevision(layoutRevision);
        }
    }

    @Override
    @SystemEvent(type=1)
    public LayoutRevision deleteLayoutRevision(LayoutRevision layoutRevision) throws PortalException {
        if (layoutRevision.hasChildren()) {
            for (LayoutRevision curLayoutRevision : layoutRevision.getChildren()) {
                curLayoutRevision.setParentLayoutRevisionId(layoutRevision.getParentLayoutRevisionId());
                this.layoutRevisionPersistence.update((BaseModel)curLayoutRevision);
            }
        }
        List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferencesByPlid(layoutRevision.getLayoutRevisionId());
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            try {
                this._portletPreferencesLocalService.deletePortletPreferences(portletPreferences.getPortletPreferencesId());
            }
            catch (NoSuchPortletPreferencesException noSuchPortletPreferencesException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)noSuchPortletPreferencesException);
            }
        }
        this._recentLayoutRevisionLocalService.deleteRecentLayoutRevisions(layoutRevision.getLayoutRevisionId());
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(layoutRevision.getCompanyId(), layoutRevision.getGroupId(), LayoutRevision.class.getName(), layoutRevision.getLayoutRevisionId());
        return (LayoutRevision)this.layoutRevisionPersistence.remove((BaseModel)layoutRevision);
    }

    @Override
    public LayoutRevision deleteLayoutRevision(long layoutRevisionId) throws PortalException {
        LayoutRevision layoutRevision = this.layoutRevisionPersistence.findByPrimaryKey(layoutRevisionId);
        return this.deleteLayoutRevision(layoutRevision);
    }

    public void deleteLayoutRevisions(long layoutSetBranchId, long plid) throws PortalException {
        for (LayoutRevision layoutRevision : this.getLayoutRevisions(layoutSetBranchId, plid)) {
            this.layoutRevisionLocalService.deleteLayoutRevision(layoutRevision);
        }
    }

    public void deleteLayoutRevisions(long layoutSetBranchId, long layoutBranchId, long plid) throws PortalException {
        List layoutRevisions = this.layoutRevisionPersistence.findByL_L_P(layoutSetBranchId, layoutBranchId, plid);
        for (LayoutRevision layoutRevision : layoutRevisions) {
            this.layoutRevisionLocalService.deleteLayoutRevision(layoutRevision);
        }
    }

    public void deleteLayoutSetBranchLayoutRevisions(long layoutSetBranchId) throws PortalException {
        List layoutRevisions = this.layoutRevisionPersistence.findByLayoutSetBranchId(layoutSetBranchId);
        for (LayoutRevision layoutRevision : layoutRevisions) {
            this.layoutRevisionLocalService.deleteLayoutRevision(layoutRevision);
        }
    }

    public LayoutRevision fetchLastLayoutRevision(long plid, boolean head) {
        try {
            return this.layoutRevisionPersistence.findByH_P_Last(head, plid, (OrderByComparator)new LayoutRevisionCreateDateComparator(true));
        }
        catch (NoSuchLayoutRevisionException noSuchLayoutRevisionException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchLayoutRevisionException);
            }
            return null;
        }
    }

    public LayoutRevision fetchLatestLayoutRevision(long layoutSetBranchId, long plid) {
        return this.layoutRevisionPersistence.fetchByL_P_First(layoutSetBranchId, plid, (OrderByComparator)new LayoutRevisionCreateDateComparator(false));
    }

    public LayoutRevision fetchLatestLayoutRevision(long layoutSetBranchId, long layoutBranchId, long plid) {
        return this.layoutRevisionPersistence.fetchByL_L_P_First(layoutSetBranchId, layoutBranchId, plid, (OrderByComparator)new LayoutRevisionCreateDateComparator(false));
    }

    public LayoutRevision fetchLayoutRevision(long layoutSetBranchId, long layoutBranchId, boolean head, long plid) {
        return this.layoutRevisionPersistence.fetchByL_L_H_P(layoutSetBranchId, layoutBranchId, head, plid);
    }

    public List<LayoutRevision> getChildLayoutRevisions(long layoutSetBranchId, long parentLayoutRevisionId, long plid) {
        return this.layoutRevisionPersistence.findByL_P_P(layoutSetBranchId, parentLayoutRevisionId, plid);
    }

    public List<LayoutRevision> getChildLayoutRevisions(long layoutSetBranchId, long parentLayoutRevision, long plid, int start, int end, OrderByComparator<LayoutRevision> orderByComparator) {
        return this.layoutRevisionPersistence.findByL_P_P(layoutSetBranchId, parentLayoutRevision, plid, start, end, orderByComparator);
    }

    public int getChildLayoutRevisionsCount(long layoutSetBranchId, long parentLayoutRevision, long plid) {
        return this.layoutRevisionPersistence.countByL_P_P(layoutSetBranchId, parentLayoutRevision, plid);
    }

    public LayoutRevision getLayoutRevision(long layoutSetBranchId, long layoutBranchId, long plid) throws PortalException {
        List layoutRevisions = this.layoutRevisionPersistence.findByL_L_P(layoutSetBranchId, layoutBranchId, plid, 0, 1, (OrderByComparator)new LayoutRevisionCreateDateComparator(false));
        if (!layoutRevisions.isEmpty()) {
            return (LayoutRevision)layoutRevisions.get(0);
        }
        throw new NoSuchLayoutRevisionException(StringBundler.concat((Object[])new Object[]{"{layoutSetBranchId=", layoutSetBranchId, ", layoutBranchId=", layoutBranchId, ", plid=", plid, "}"}));
    }

    public List<LayoutRevision> getLayoutRevisions(long plid) {
        return this.layoutRevisionPersistence.findByPlid(plid);
    }

    public List<LayoutRevision> getLayoutRevisions(long layoutSetBranchId, boolean head) {
        return this.layoutRevisionPersistence.findByL_H(layoutSetBranchId, head);
    }

    public List<LayoutRevision> getLayoutRevisions(long layoutSetBranchId, boolean head, int status) {
        return this.layoutRevisionPersistence.findByL_H_S(layoutSetBranchId, head, status);
    }

    public List<LayoutRevision> getLayoutRevisions(long layoutSetBranchId, int status) {
        return this.layoutRevisionPersistence.findByL_S(layoutSetBranchId, status);
    }

    public List<LayoutRevision> getLayoutRevisions(long layoutSetBranchId, long plid) {
        return this.layoutRevisionPersistence.findByL_P(layoutSetBranchId, plid);
    }

    public List<LayoutRevision> getLayoutRevisions(long layoutSetBranchId, long plid, boolean head) {
        return this.layoutRevisionPersistence.findByL_H_P_Collection(layoutSetBranchId, head, plid);
    }

    public List<LayoutRevision> getLayoutRevisions(long layoutSetBranchId, long plid, int status) {
        return this.layoutRevisionPersistence.findByL_P_S(layoutSetBranchId, plid, status);
    }

    public List<LayoutRevision> getLayoutRevisions(long layoutSetBranchId, long plid, int start, int end, OrderByComparator<LayoutRevision> orderByComparator) {
        return this.layoutRevisionPersistence.findByL_P(layoutSetBranchId, plid, start, end, orderByComparator);
    }

    public List<LayoutRevision> getLayoutRevisions(long layoutSetBranchId, long layoutBranchId, long plid, int start, int end, OrderByComparator<LayoutRevision> orderByComparator) {
        return this.layoutRevisionPersistence.findByL_L_P(layoutSetBranchId, layoutBranchId, plid, start, end, orderByComparator);
    }

    public List<LayoutRevision> getLayoutRevisionsByStatus(int status) {
        return this.layoutRevisionPersistence.findByStatus(status);
    }

    public int getLayoutRevisionsCount(long plid) {
        return this.layoutRevisionPersistence.countByPlid(plid);
    }

    public int getLayoutRevisionsCount(long layoutSetBranchId, long layoutBranchId, long plid) {
        return this.layoutRevisionPersistence.countByL_L_P(layoutSetBranchId, layoutBranchId, plid);
    }

    public LayoutRevision updateLayoutRevision(long userId, long layoutRevisionId, long layoutBranchId, String name, String title, String description, String keywords, String robots, String typeSettings, boolean iconImage, long iconImageId, String themeId, String colorSchemeId, String css, ServiceContext serviceContext) throws PortalException {
        LayoutRevision oldLayoutRevision = this.layoutRevisionPersistence.findByPrimaryKey(layoutRevisionId);
        LayoutRevision layoutRevision = null;
        if (_layoutRevisionId.get() > 0L) {
            if (_layoutRevisionId.get() == layoutRevisionId) {
                layoutRevision = oldLayoutRevision;
            } else {
                LayoutRevision threadLayoutRevision = (LayoutRevision)this.layoutRevisionPersistence.findByPrimaryKey((Serializable)_layoutRevisionId.get());
                if (threadLayoutRevision.getParentLayoutRevisionId() == oldLayoutRevision.getLayoutRevisionId()) {
                    layoutRevision = threadLayoutRevision;
                }
            }
        }
        int workflowAction = serviceContext.getWorkflowAction();
        boolean revisionInProgress = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"revisionInProgress");
        if (!MergeLayoutPrototypesThreadLocal.isInProgress() && workflowAction != 1 && layoutRevision == null && !revisionInProgress) {
            Object[] removePortletIdsArray;
            User user = this._userPersistence.findByPrimaryKey(userId);
            layoutRevision = this.layoutRevisionPersistence.create(this.getUniqueLayoutRevisionId());
            layoutRevision.setGroupId(oldLayoutRevision.getGroupId());
            layoutRevision.setCompanyId(oldLayoutRevision.getCompanyId());
            layoutRevision.setUserId(user.getUserId());
            layoutRevision.setUserName(user.getFullName());
            layoutRevision.setLayoutSetBranchId(oldLayoutRevision.getLayoutSetBranchId());
            layoutRevision.setLayoutBranchId(layoutBranchId);
            layoutRevision.setParentLayoutRevisionId(oldLayoutRevision.getLayoutRevisionId());
            layoutRevision.setHead(false);
            layoutRevision.setPlid(oldLayoutRevision.getPlid());
            layoutRevision.setPrivateLayout(oldLayoutRevision.isPrivateLayout());
            layoutRevision.setName(name);
            layoutRevision.setTitle(title);
            layoutRevision.setDescription(description);
            layoutRevision.setKeywords(keywords);
            layoutRevision.setRobots(robots);
            layoutRevision.setTypeSettings(typeSettings);
            layoutRevision.setIconImageId(iconImageId);
            layoutRevision.setThemeId(themeId);
            layoutRevision.setColorSchemeId(colorSchemeId);
            layoutRevision.setCss(css);
            layoutRevision.setStatus(2);
            layoutRevision.setStatusDate(serviceContext.getModifiedDate(new Date()));
            layoutRevision = (LayoutRevision)this.layoutRevisionPersistence.update((BaseModel)layoutRevision);
            _layoutRevisionId.set(layoutRevision.getLayoutRevisionId());
            this.copyPortletPreferences(layoutRevision, layoutRevision.getParentLayoutRevisionId());
            if (Objects.equals(serviceContext.getCommand(), "delete") && !ArrayUtil.isEmpty((Object[])(removePortletIdsArray = (String[])serviceContext.getAttribute("removePortletIds")))) {
                Set removePortletIds = SetUtil.fromArray((Object[])removePortletIdsArray);
                for (PortletPreferences portletPreferences : this._portletPreferencesLocalService.getPortletPreferencesByPlid(layoutRevision.getLayoutRevisionId())) {
                    if (!removePortletIds.contains(portletPreferences.getPortletId())) continue;
                    this._portletPreferencesLocalService.deletePortletPreferences(portletPreferences.getPortletPreferencesId());
                }
            }
            StagingUtil.setRecentLayoutBranchId((User)user, (long)layoutRevision.getLayoutSetBranchId(), (long)layoutRevision.getPlid(), (long)layoutRevision.getLayoutBranchId());
            StagingUtil.setRecentLayoutRevisionId((User)user, (long)layoutRevision.getLayoutSetBranchId(), (long)layoutRevision.getPlid(), (long)layoutRevision.getLayoutRevisionId());
        } else {
            if (layoutRevision == null) {
                layoutRevision = oldLayoutRevision;
            }
            layoutRevision.setName(name);
            layoutRevision.setTitle(title);
            layoutRevision.setDescription(description);
            layoutRevision.setKeywords(keywords);
            layoutRevision.setRobots(robots);
            layoutRevision.setTypeSettings(typeSettings);
            layoutRevision.setIconImageId(iconImageId);
            layoutRevision.setThemeId(themeId);
            layoutRevision.setColorSchemeId(colorSchemeId);
            layoutRevision.setCss(css);
            layoutRevision = (LayoutRevision)this.layoutRevisionPersistence.update((BaseModel)layoutRevision);
            _layoutRevisionId.set(layoutRevision.getLayoutRevisionId());
        }
        boolean major = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"major");
        if (major || !this.isWorkflowEnabled(layoutRevision.getPlid())) {
            this.updateMajor(layoutRevision);
        }
        if (this.isWorkflowEnabled(layoutRevision.getPlid())) {
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)layoutRevision.getCompanyId(), (long)layoutRevision.getGroupId(), (long)userId, (String)LayoutRevision.class.getName(), (long)layoutRevision.getLayoutRevisionId(), (Object)layoutRevision, (ServiceContext)serviceContext);
        } else {
            layoutRevision = this.updateStatus(userId, layoutRevision.getLayoutRevisionId(), 0, serviceContext);
        }
        Layout layout = this._layoutLocalService.getLayout(layoutRevision.getPlid());
        if (layout.isTypeContent()) {
            layoutRevision = this.updateStatus(userId, layoutRevision.getLayoutRevisionId(), 0, serviceContext);
        }
        return layoutRevision;
    }

    public LayoutRevision updateStatus(long userId, long layoutRevisionId, int status, ServiceContext serviceContext) throws PortalException {
        LayoutRevision layoutRevision;
        block4: {
            boolean head;
            block5: {
                User user = this._userPersistence.findByPrimaryKey(userId);
                layoutRevision = this.layoutRevisionPersistence.findByPrimaryKey(layoutRevisionId);
                head = layoutRevision.isHead();
                layoutRevision.setStatus(status);
                layoutRevision.setStatusByUserId(user.getUserId());
                layoutRevision.setStatusByUserName(user.getFullName());
                layoutRevision.setStatusDate(new Date());
                if (status == 0) {
                    layoutRevision.setHead(true);
                } else {
                    layoutRevision.setHead(false);
                    layoutRevision.setMajor(false);
                }
                layoutRevision = (LayoutRevision)this.layoutRevisionPersistence.update((BaseModel)layoutRevision);
                if (status != 0) break block5;
                List layoutRevisions = this.layoutRevisionPersistence.findByL_P(layoutRevision.getLayoutSetBranchId(), layoutRevision.getPlid());
                for (LayoutRevision curLayoutRevision : layoutRevisions) {
                    if (curLayoutRevision.getLayoutRevisionId() == layoutRevision.getLayoutRevisionId()) continue;
                    curLayoutRevision.setHead(false);
                    this.layoutRevisionPersistence.update((BaseModel)curLayoutRevision);
                }
                break block4;
            }
            if (!head) break block4;
            List layoutRevisions = this.layoutRevisionPersistence.findByL_P_S(layoutRevision.getLayoutSetBranchId(), layoutRevision.getPlid(), 0, -1, -1, (OrderByComparator)new LayoutRevisionModifiedDateComparator(false));
            for (LayoutRevision curLayoutRevision : layoutRevisions) {
                if (curLayoutRevision.getLayoutRevisionId() == layoutRevision.getLayoutRevisionId()) continue;
                curLayoutRevision.setHead(true);
                this.layoutRevisionPersistence.update((BaseModel)curLayoutRevision);
                break;
            }
        }
        return layoutRevision;
    }

    protected void copyPortletPreferences(LayoutRevision layoutRevision, long parentLayoutRevisionId) {
        List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferencesByPlid(parentLayoutRevisionId);
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            javax.portlet.PortletPreferences jxPortletPreferences = this._portletPreferenceValueLocalService.getPreferences(portletPreferences);
            this._portletPreferencesLocalService.addPortletPreferences(layoutRevision.getCompanyId(), portletPreferences.getOwnerId(), portletPreferences.getOwnerType(), layoutRevision.getLayoutRevisionId(), portletPreferences.getPortletId(), null, PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences));
        }
    }

    protected long getParentLayoutRevisionId(long layoutSetBranchId, long parentLayoutRevisionId, long plid) {
        List layoutRevisions;
        LayoutRevision parentLayoutRevision = null;
        if (parentLayoutRevisionId > 0L && (parentLayoutRevision = this.layoutRevisionPersistence.fetchByPrimaryKey(parentLayoutRevisionId)) == null && !(layoutRevisions = this.layoutRevisionPersistence.findByL_P(layoutSetBranchId, plid, 0, 1)).isEmpty()) {
            parentLayoutRevision = (LayoutRevision)layoutRevisions.get(0);
        }
        if (parentLayoutRevision != null) {
            return parentLayoutRevision.getLayoutRevisionId();
        }
        return 0L;
    }

    protected long getUniqueLayoutRevisionId() {
        long layoutRevisionId = this.counterLocalService.increment();
        while (this._layoutLocalService.fetchLayout(layoutRevisionId) != null) {
            layoutRevisionId = this.counterLocalService.increment();
        }
        return layoutRevisionId;
    }

    protected boolean isWorkflowEnabled(long plid) throws PortalException {
        Layout layout = this._layoutLocalService.getLayout(plid);
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
        return layoutTypeController.isWorkflowEnabled();
    }

    protected LayoutRevision updateMajor(LayoutRevision layoutRevision) throws PortalException {
        LayoutRevision parentLayoutRevision;
        List childrenLayoutRevisions;
        LayoutRevision parentLayoutRevision2;
        ArrayList<LayoutRevision> parentLayoutRevisions = new ArrayList<LayoutRevision>();
        long parentLayoutRevisionId = layoutRevision.getParentLayoutRevisionId();
        while (parentLayoutRevisionId != 0L && !(parentLayoutRevision2 = this.layoutRevisionPersistence.findByPrimaryKey(parentLayoutRevisionId)).isMajor()) {
            parentLayoutRevisions.add(parentLayoutRevision2);
            parentLayoutRevisionId = parentLayoutRevision2.getParentLayoutRevisionId();
        }
        layoutRevision.setParentLayoutRevisionId(parentLayoutRevisionId);
        layoutRevision.setMajor(true);
        layoutRevision = (LayoutRevision)this.layoutRevisionPersistence.update((BaseModel)layoutRevision);
        Iterator iterator = parentLayoutRevisions.iterator();
        while (iterator.hasNext() && (childrenLayoutRevisions = (parentLayoutRevision = (LayoutRevision)iterator.next()).getChildren()).isEmpty()) {
            this.layoutRevisionLocalService.deleteLayoutRevision(parentLayoutRevision);
        }
        return layoutRevision;
    }
}

