/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.bean;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.internal.cluster.ClusterableAdvice;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class BeanReferenceAnnotationBeanPostProcessor
implements BeanPostProcessor {
    private static final String _JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String _ORG_SPRINGFRAMEWORK = "org.springframework";
    private static final Log _log = LogFactoryUtil.getLog(BeanReferenceAnnotationBeanPostProcessor.class);
    private final BeanFactory _beanFactory;
    private final Map<String, Object> _beans = new HashMap<String, Object>();

    public BeanReferenceAnnotationBeanPostProcessor(BeanFactory beanFactory) {
        this._beanFactory = beanFactory;
    }

    public void destroy() {
        this._beans.clear();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!(bean instanceof IdentifiableOSGiService) && beanName.endsWith("Service") && _log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{beanName, " should implement ", IdentifiableOSGiService.class.getName(), " for ", ClusterableAdvice.class.getName()}));
        }
        this._autoInject(bean, beanName, bean.getClass());
        return bean;
    }

    private void _autoInject(Object targetBean, String targetBeanName, Class<?> beanClass) {
        Field[] fields;
        if (beanClass == null || beanClass.isInterface()) {
            return;
        }
        String className = beanClass.getName();
        if (className.equals(_JAVA_LANG_OBJECT) || className.startsWith(_ORG_SPRINGFRAMEWORK)) {
            return;
        }
        for (Field field : fields = beanClass.getDeclaredFields()) {
            Object referencedBean;
            BeanReference beanReference = field.getAnnotation(BeanReference.class);
            String referencedBeanName = null;
            Class referencedBeanType = null;
            if (beanReference == null) continue;
            referencedBeanName = beanReference.name();
            referencedBeanType = beanReference.type();
            if (!Object.class.equals((Object)referencedBeanType)) {
                referencedBeanName = referencedBeanType.getName();
            }
            if ((referencedBean = this._beans.get(referencedBeanName)) == null) {
                try {
                    referencedBean = this._beanFactory.getBean(referencedBeanName);
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    try {
                        referencedBean = PortalBeanLocatorUtil.locate((String)referencedBeanName);
                    }
                    catch (BeanLocatorException beanLocatorException) {
                        StringWriter stringWriter = new StringWriter();
                        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
                            printWriter.print("BeanFactory could not find bean: ");
                            noSuchBeanDefinitionException.printStackTrace(printWriter);
                            printWriter.print(" and PortalBeanLocator failed with: ");
                            printWriter.append(beanLocatorException.getMessage());
                        }
                        throw new BeanLocatorException(stringWriter.toString(), (Throwable)beanLocatorException);
                    }
                }
                this._beans.put(referencedBeanName, referencedBean);
            }
            ReflectionUtils.makeAccessible((Field)field);
            try {
                field.set(targetBean, referencedBean);
            }
            catch (Throwable throwable) {
                throw new BeanCreationException(targetBeanName, "Could not inject BeanReference fields", throwable);
            }
        }
        this._autoInject(targetBean, targetBeanName, beanClass.getSuperclass());
    }
}

