/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.orm.hibernate5.SpringSessionSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class PortalCurrentSessionContext
implements CurrentSessionContext {
    private final SessionFactoryImplementor _sessionFactoryImplementor;

    public PortalCurrentSessionContext(SessionFactoryImplementor sessionFactoryImplementor) {
        this._sessionFactoryImplementor = sessionFactoryImplementor;
    }

    public Session currentSession() throws HibernateException {
        Object value = TransactionSynchronizationManager.getResource((Object)this._sessionFactoryImplementor);
        if (value instanceof Session) {
            return (Session)value;
        }
        if (value instanceof SessionHolder) {
            SessionHolder sessionHolder = (SessionHolder)value;
            Session session = sessionHolder.getSession();
            if (!sessionHolder.isSynchronizedWithTransaction() && TransactionSynchronizationManager.isSynchronizationActive()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, (SessionFactory)this._sessionFactoryImplementor, false));
                sessionHolder.setSynchronizedWithTransaction(true);
                FlushMode flushMode = session.getHibernateFlushMode();
                if (flushMode.equals((Object)FlushMode.MANUAL) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                    session.setHibernateFlushMode(FlushMode.AUTO);
                    sessionHolder.setPreviousFlushMode(flushMode);
                }
            }
            return session;
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            Session session = this._sessionFactoryImplementor.openSession();
            if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                session.setHibernateFlushMode(FlushMode.MANUAL);
            }
            SessionHolder sessionHolder = new SessionHolder(session);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, (SessionFactory)this._sessionFactoryImplementor, true));
            TransactionSynchronizationManager.bindResource((Object)this._sessionFactoryImplementor, (Object)sessionHolder);
            sessionHolder.setSynchronizedWithTransaction(true);
            return session;
        }
        throw new HibernateException("Unable to get current session for current thread");
    }
}

