/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.spring.transaction.BaseTransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import com.liferay.portal.spring.transaction.TransactionStatusAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;

@OSGiBeanProperties(service={CounterTransactionExecutor.class})
public class CounterTransactionExecutor
extends BaseTransactionExecutor {
    private final PlatformTransactionManager _platformTransactionManager;

    public CounterTransactionExecutor(PlatformTransactionManager platformTransactionManager) {
        this._platformTransactionManager = platformTransactionManager;
    }

    @Override
    public void commit(TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) {
        this._platformTransactionManager.commit(transactionStatusAdapter.getTransactionStatus());
    }

    @Override
    public PlatformTransactionManager getPlatformTransactionManager() {
        return this._platformTransactionManager;
    }

    @Override
    public void rollback(Throwable throwable1, TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) throws Throwable {
        if (transactionAttributeAdapter.rollbackOn(throwable1)) {
            try {
                this._platformTransactionManager.rollback(transactionStatusAdapter.getTransactionStatus());
            }
            catch (Throwable throwable2) {
                throwable2.addSuppressed(throwable1);
                throw throwable2;
            }
        }
        try {
            this._platformTransactionManager.commit(transactionStatusAdapter.getTransactionStatus());
        }
        catch (Throwable throwable2) {
            throwable2.addSuppressed(throwable1);
            throw throwable2;
        }
        throw throwable1;
    }

    @Override
    public TransactionStatusAdapter start(TransactionAttributeAdapter transactionAttributeAdapter) {
        return new TransactionStatusAdapter(this._platformTransactionManager.getTransaction((TransactionDefinition)transactionAttributeAdapter));
    }
}

