/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeEmailNotificationPreferences
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeEmailNotificationPreferences.class);

    protected void doUpgrade() throws Exception {
        this._updatePreferences("admin.email.password.reset.body", "adminEmailPasswordResetBody");
        this._updatePreferences("admin.email.password.reset.subject", "adminEmailPasswordResetSubject");
        this._updatePreferences("admin.email.password.sent.body", "adminEmailPasswordSentBody");
        this._updatePreferences("admin.email.password.sent.subject", "adminEmailPasswordSentSubject");
        this._updatePreferences("admin.email.user.added.body", "adminEmailUserAddedBody");
        this._updatePreferences("admin.email.user.added.no.password.body", "adminEmailUserAddedNoPasswordBody");
        this._updatePreferences("admin.email.user.added.subject", "adminEmailUserAddedSubject");
        this._updatePreferences("admin.email.verification.body", "adminEmailVerificationBody");
        this._updatePreferences("admin.email.verification.subject", "adminEmailVerificationSubject");
    }

    private void _updatePreferences(String oldValue, String newValue) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            try {
                this.runSQL(StringBundler.concat((String[])new String[]{"update PortalPreferences set preferences = ", "replace(preferences, '", oldValue, "', '", newValue, "') where preferences like '%", oldValue, "%'"}));
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select portalPreferencesId, preferences from ", "PortalPreferences where preferences like '%", oldValue, "%'"}));
                     PreparedStatement preparedStatement2 = this.connection.prepareStatement("update PortalPreferences set preferences = ? where portalPreferencesId = ?");
                     ResultSet resultSet = preparedStatement1.executeQuery();){
                    while (resultSet.next()) {
                        preparedStatement2.setString(1, StringUtil.replace((String)resultSet.getString("preferences"), (String)oldValue, (String)newValue));
                        preparedStatement2.setLong(2, resultSet.getLong("portalPreferencesId"));
                        preparedStatement2.executeUpdate();
                    }
                }
            }
        }
    }
}

