/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalSessionContext;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Time;
import java.util.Collection;
import javax.servlet.http.HttpSession;

public class MaintenanceUtil {
    private static final Log _log = LogFactoryUtil.getLog(MaintenanceUtil.class);
    private static volatile String _className;
    private static volatile boolean _maintaining;
    private static volatile String _sessionId;
    private static volatile String _status;

    public static void appendStatus(String status) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)status);
        }
        _status = _status.concat(StringBundler.concat((String[])new String[]{Time.getRFC822(), " ", HtmlUtil.escape((String)status), "<br />"}));
    }

    public static void cancel() {
        HttpSession httpSession = PortalSessionContext.get((String)_sessionId);
        if (httpSession != null) {
            httpSession.invalidate();
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Session " + _sessionId + " is null"));
        }
        _maintaining = false;
    }

    public static String getClassName() {
        return _className;
    }

    public static String getSessionId() {
        return _sessionId;
    }

    public static String getStatus() {
        return _status;
    }

    public static boolean isMaintaining() {
        return _maintaining;
    }

    public static void maintain(String sessionId, String className) {
        _sessionId = sessionId;
        _className = className;
        _maintaining = true;
        _status = "";
        MaintenanceUtil.appendStatus("Executing " + _className);
        Collection httpSessions = PortalSessionContext.values();
        for (HttpSession httpSession : httpSessions) {
            if (sessionId.equals(httpSession.getId())) continue;
            try {
                httpSession.invalidate();
            }
            catch (IllegalStateException illegalStateException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)illegalStateException);
            }
        }
    }

    private MaintenanceUtil() {
    }

    static {
        _status = "";
    }
}

