/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.layout.utility.page.kernel.provider.util.LayoutUtilityPageEntryLayoutProviderUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.session.AuthenticatedSessionManagerUtil;
import com.liferay.portal.security.sso.SSOUtil;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.PropsValues;
import java.util.Objects;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoginAction
implements Action {
    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HttpSession httpSession;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            httpServletResponse.sendRedirect(themeDisplay.getPathMain() + PropsValues.AUTH_LOGIN_DISABLED_PATH);
            return null;
        }
        String login = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"login");
        String password = httpServletRequest.getParameter("password");
        if (Validator.isNotNull((String)login) && Validator.isNotNull((String)password)) {
            AuthTokenUtil.checkCSRFToken((HttpServletRequest)httpServletRequest, (String)LoginAction.class.getName());
            boolean rememberMe = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"rememberMe");
            String authType = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"authType");
            AuthenticatedSessionManagerUtil.login(httpServletRequest, httpServletResponse, login, password, rememberMe, authType);
        }
        if ((httpSession = httpServletRequest.getSession()).getAttribute("j_username") != null && httpSession.getAttribute("j_password") != null) {
            String portalURL;
            if (PropsValues.PORTAL_JAAS_ENABLE) {
                return actionMapping.getActionForward("/portal/touch_protected.jsp");
            }
            String redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect");
            if (Validator.isNull((String)(redirect = PortalUtil.escapeRedirect((String)redirect)))) {
                redirect = themeDisplay.getPathMain();
            }
            if (redirect.charAt(0) == '/' && Validator.isNotNull((String)(portalURL = PortalUtil.getPortalURL((HttpServletRequest)httpServletRequest, (boolean)httpServletRequest.isSecure())))) {
                redirect = portalURL.concat(redirect);
            }
            httpServletResponse.sendRedirect(redirect);
            return null;
        }
        Layout layout = LayoutUtilityPageEntryLayoutProviderUtil.getDefaultLayoutUtilityPageEntryLayout((long)themeDisplay.getScopeGroupId(), (String)"LOGIN");
        if (layout != null && !Objects.equals(this.getWindowState(httpServletRequest), LiferayWindowState.EXCLUSIVE)) {
            httpServletResponse.sendRedirect(PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay));
            return null;
        }
        String redirect = PortalUtil.getSiteLoginURL((ThemeDisplay)themeDisplay);
        if (Validator.isNull((String)redirect)) {
            redirect = PropsValues.AUTH_LOGIN_URL;
        }
        if (Validator.isNull((String)redirect)) {
            redirect = PortletURLBuilder.create((PortletURL)PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)"com_liferay_login_web_portlet_LoginPortlet", (String)"RENDER_PHASE")).setMVCRenderCommandName("/login/login").setParameter("saveLastPath", (Object)false).setPortletMode(PortletMode.VIEW).setWindowState(this.getWindowState(httpServletRequest)).buildString();
        }
        String loginRedirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect");
        if (Validator.isNotNull((String)(loginRedirect = PortalUtil.escapeRedirect((String)loginRedirect)))) {
            if (SSOUtil.isRedirectRequired(themeDisplay.getCompanyId())) {
                redirect = loginRedirect;
            } else {
                String loginPortletNamespace = PortalUtil.getPortletNamespace((String)PropsValues.AUTH_LOGIN_PORTLET_NAME);
                String loginRedirectParameter = loginPortletNamespace + "redirect";
                redirect = HttpComponentsUtil.setParameter((String)redirect, (String)"p_p_id", (String)PropsValues.AUTH_LOGIN_PORTLET_NAME);
                redirect = HttpComponentsUtil.setParameter((String)redirect, (String)"p_p_lifecycle", (String)"0");
                redirect = HttpComponentsUtil.setParameter((String)redirect, (String)loginRedirectParameter, (String)loginRedirect);
            }
        }
        httpServletResponse.sendRedirect(redirect);
        return null;
    }

    protected WindowState getWindowState(HttpServletRequest httpServletRequest) {
        WindowState windowState = WindowState.MAXIMIZED;
        String windowStateString = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"windowState");
        if (Validator.isNotNull((String)windowStateString)) {
            windowState = WindowStateFactory.getWindowState((String)windowStateString);
        }
        return windowState;
    }
}

