/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.portal.dao.sql.transformer.BaseSQLTransformerLogic;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.function.Function;
import java.util.regex.Matcher;

public class HypersonicSQLTransformerLogic
extends BaseSQLTransformerLogic {
    public HypersonicSQLTransformerLogic(DB db) {
        super(db);
        Object[] functions = new Function[]{this.getBooleanFunction(), this.getCastClobTextFunction(), this.getCastLongFunction(), this.getCastTextFunction(), this.getDropTableIfExistsTextFunction(), this.getIntegerDivisionFunction(), this.getNullDateFunction()};
        if (!db.isSupportsStringCaseSensitiveQuery()) {
            functions = (Function[])ArrayUtil.append((Object[])functions, this.getLowerFunction());
        }
        this.setFunctions((Function[])functions);
    }

    @Override
    protected Function<String, String> getNullDateFunction() {
        return sql -> StringUtil.replace((String)sql, (String)"[$NULL_DATE$]", (String)"CAST(NULL AS DATE)");
    }

    @Override
    protected String replaceCastLong(Matcher matcher) {
        return matcher.replaceAll("CONVERT($1, SQL_BIGINT)");
    }

    @Override
    protected String replaceCastText(Matcher matcher) {
        return matcher.replaceAll("CONVERT($1, SQL_VARCHAR)");
    }

    @Override
    protected String replaceDropTableIfExistsText(Matcher matcher) {
        return matcher.replaceAll("DROP TABLE $1 IF EXISTS");
    }
}

