/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auto.login.AutoLoginException;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.DefaultAdminUtil;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SetupAdminAutoLogin
extends BaseAutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(SetupAdminAutoLogin.class);

    protected String[] doHandleException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) throws AutoLoginException {
        if (_log.isDebugEnabled()) {
            _log.debug((Throwable)exception);
        }
        throw new AutoLoginException((Throwable)exception);
    }

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (Validator.isNotNull((String)PropsValues.DEFAULT_ADMIN_PASSWORD)) {
            return null;
        }
        Company company = PortalUtil.getCompany((HttpServletRequest)httpServletRequest);
        User user = DefaultAdminUtil.fetchDefaultAdmin(company.getCompanyId());
        if (user == null) {
            return null;
        }
        String reminderQueryAnswer = user.getReminderQueryAnswer();
        if (user.isPasswordReset() && reminderQueryAnswer.equals("pending") && Validator.isNull((String)user.getReminderQueryQuestion()) && Validator.isNull((Object)user.getLastFailedLoginDate()) && Validator.isNull((Object)user.getLockoutDate())) {
            String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
            return credentials;
        }
        return null;
    }
}

