/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.util.ThemeFactoryUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ThemeServicePreAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(ThemeServicePreAction.class);

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        try {
            this.servicePre(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            throw new ActionException((Throwable)exception);
        }
    }

    protected void servicePre(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Theme theme = themeDisplay.getTheme();
        if (theme != null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Theme is already set");
            }
            return;
        }
        ColorScheme colorScheme = themeDisplay.getColorScheme();
        Layout layout = themeDisplay.getLayout();
        if (layout != null) {
            Layout masterLayout;
            theme = layout.getTheme();
            colorScheme = layout.getColorScheme();
            if (layout.getMasterLayoutPlid() > 0L && (masterLayout = LayoutLocalServiceUtil.fetchLayout((long)layout.getMasterLayoutPlid())) != null) {
                theme = masterLayout.getTheme();
                colorScheme = masterLayout.getColorScheme();
            }
        } else {
            String themeId = ThemeFactoryUtil.getDefaultRegularThemeId(themeDisplay.getCompanyId());
            String colorSchemeId = ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId();
            theme = ThemeLocalServiceUtil.getTheme((long)themeDisplay.getCompanyId(), (String)themeId);
            colorScheme = ThemeLocalServiceUtil.getColorScheme((long)themeDisplay.getCompanyId(), (String)theme.getThemeId(), (String)colorSchemeId);
        }
        httpServletRequest.setAttribute("COLOR_SCHEME", (Object)colorScheme);
        httpServletRequest.setAttribute("THEME", (Object)theme);
        themeDisplay.setLookAndFeel(theme, colorScheme);
    }
}

