/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.internal.cluster;

import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterEventType;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import java.util.List;

public class LiveUsersClusterEventListenerImpl
implements ClusterEventListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processClusterEvent(ClusterEvent clusterEvent) {
        List clusterNodes = clusterEvent.getClusterNodes();
        if (clusterNodes.isEmpty()) {
            return;
        }
        ClusterEventType clusterEventType = clusterEvent.getClusterEventType();
        String command = null;
        if (clusterEventType == ClusterEventType.DEPART) {
            command = "removeClusterNode";
        } else if (clusterEventType == ClusterEventType.JOIN) {
            command = "addClusterNode";
        } else {
            throw new IllegalArgumentException("Unknown cluster event type " + clusterEventType);
        }
        for (ClusterNode clusterNode : clusterNodes) {
            Message message = new Message();
            message.setPayload((Object)JSONUtil.put((String)"clusterNodeId", (Object)clusterNode.getClusterNodeId()).put("command", command).toString());
            ClusterInvokeThreadLocal.setEnabled((boolean)false);
            try {
                MessageBusUtil.sendMessage((String)"liferay/live_users", (Message)message);
            }
            finally {
                ClusterInvokeThreadLocal.setEnabled((boolean)true);
            }
        }
    }
}

