/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.internal.increment;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.internal.increment.IncreasableEntry;
import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.increment.Increment;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import java.util.Arrays;

public class BufferedIncreasableEntry<K, T>
extends IncreasableEntry<K, Increment<T>> {
    private final AopMethodInvocation _aopMethodInvocation;
    private final Object[] _arguments;
    private final long _companyId;

    public BufferedIncreasableEntry(AopMethodInvocation aopMethodInvocation, Object[] arguments, K key, Increment<T> value) {
        super(key, value);
        this._aopMethodInvocation = aopMethodInvocation;
        this._arguments = arguments;
        this._companyId = CompanyThreadLocal.getCompanyId();
    }

    @Override
    public BufferedIncreasableEntry<K, T> increase(Increment<T> deltaValue) {
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable((Long)this._companyId);){
            BufferedIncreasableEntry<Object, T> bufferedIncreasableEntry = new BufferedIncreasableEntry<Object, T>(this._aopMethodInvocation, this._arguments, this.key, ((Increment)this.value).increaseForNew(deltaValue.getValue()));
            return bufferedIncreasableEntry;
        }
    }

    public void proceed() throws Throwable {
        this._arguments[this._arguments.length - 1] = ((Increment)this.getValue()).getValue();
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable((Long)this._companyId);){
            this._aopMethodInvocation.proceed(this._arguments);
        }
    }

    @Override
    public String toString() {
        return StringBundler.concat((Object[])new Object[]{this._aopMethodInvocation, "(", Arrays.toString(this._arguments), ")"});
    }
}

