/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json;

import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONDeserializerImpl;
import com.liferay.portal.json.JSONInit;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.json.JSONSerializerImpl;
import com.liferay.portal.json.UnmodifiableJSONObjectImpl;
import com.liferay.portal.json.jabsorb.serializer.EnumSerializer;
import com.liferay.portal.json.jabsorb.serializer.LiferayJSONDeserializationWhitelist;
import com.liferay.portal.json.jabsorb.serializer.LiferayJSONSerializer;
import com.liferay.portal.json.jabsorb.serializer.LiferaySerializer;
import com.liferay.portal.json.jabsorb.serializer.LocaleSerializer;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONDeserializer;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.json.JSONTransformer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.Serializer;
import org.json.JSONML;

public class JSONFactoryImpl
implements JSONFactory {
    private static final String _NULL_JSON = "{}";
    private static final Log _log = LogFactoryUtil.getLog(JSONFactoryImpl.class);
    private final org.jabsorb.JSONSerializer _jsonSerializer;
    private final LiferayJSONDeserializationWhitelist _liferayJSONDeserializationWhitelist = new LiferayJSONDeserializationWhitelist();
    private final JSONObject _unmodifiableJSONObject = new UnmodifiableJSONObjectImpl();

    public JSONFactoryImpl() {
        JSONInit.init();
        this._jsonSerializer = new LiferayJSONSerializer(this._liferayJSONDeserializationWhitelist);
        try {
            this._jsonSerializer.registerDefaultSerializers();
            this._jsonSerializer.registerSerializer((Serializer)new EnumSerializer());
            this._jsonSerializer.registerSerializer((Serializer)new LiferaySerializer());
            this._jsonSerializer.registerSerializer((Serializer)new LocaleSerializer());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    public String convertJSONMLArrayToXML(String jsonml) {
        try {
            org.json.JSONArray jsonArray = new org.json.JSONArray(jsonml);
            return JSONML.toString((org.json.JSONArray)jsonArray);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            throw new IllegalStateException("Unable to convert to XML", exception);
        }
    }

    public String convertJSONMLObjectToXML(String jsonml) {
        try {
            org.json.JSONObject jsonObject = new org.json.JSONObject(jsonml);
            return JSONML.toString((org.json.JSONObject)jsonObject);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            throw new IllegalStateException("Unable to convert to XML", exception);
        }
    }

    public String convertXMLtoJSONMLArray(String xml) {
        try {
            org.json.JSONArray jsonArray = JSONML.toJSONArray((String)xml);
            return jsonArray.toString();
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            throw new IllegalStateException("Unable to convert to JSONML", exception);
        }
    }

    public String convertXMLtoJSONMLObject(String xml) {
        try {
            org.json.JSONObject jsonObject = JSONML.toJSONObject((String)xml);
            return jsonObject.toString();
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            throw new IllegalStateException("Unable to convert to JSONML", exception);
        }
    }

    public JSONTransformer createJavaScriptNormalizerJSONTransformer(List<String> javaScriptAttributes) {
        throw new UnsupportedOperationException("Temporally disabled until alloy-taglib.jar is updated");
    }

    public JSONArray createJSONArray() {
        return new JSONArrayImpl();
    }

    public JSONArray createJSONArray(Collection<?> collection) {
        return new JSONArrayImpl(collection);
    }

    public JSONArray createJSONArray(String json) throws JSONException {
        return new JSONArrayImpl(json);
    }

    public <T> JSONArray createJSONArray(T[] array) {
        return new JSONArrayImpl(Arrays.asList(array));
    }

    public <T> JSONDeserializer<T> createJSONDeserializer() {
        return new JSONDeserializerImpl();
    }

    public JSONObject createJSONObject() {
        return new JSONObjectImpl();
    }

    public JSONObject createJSONObject(Map<?, ?> map) {
        return new JSONObjectImpl(map);
    }

    public JSONObject createJSONObject(String json) throws JSONException {
        return new JSONObjectImpl(json);
    }

    public JSONSerializer createJSONSerializer() {
        return new JSONSerializerImpl();
    }

    public Object deserialize(JSONObject jsonObject) {
        return this.deserialize(jsonObject.toString());
    }

    public Object deserialize(String json) {
        try {
            return this._jsonSerializer.fromJSON(json);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            throw new IllegalStateException("Unable to deserialize object", exception);
        }
    }

    public LiferayJSONDeserializationWhitelist getLiferayJSONDeserializationWhitelist() {
        return this._liferayJSONDeserializationWhitelist;
    }

    public String getNullJSON() {
        return _NULL_JSON;
    }

    public JSONObject getUnmodifiableJSONObject() {
        return this._unmodifiableJSONObject;
    }

    public Object looseDeserialize(String json) {
        try {
            JSONDeserializer jsonDeserializer = this.createJSONDeserializer();
            return jsonDeserializer.deserialize(json);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            throw new IllegalStateException("Unable to deserialize object", exception);
        }
    }

    public <T> T looseDeserialize(String json, Class<T> clazz) {
        JSONDeserializer<T> jsonDeserializer = this.createJSONDeserializer();
        jsonDeserializer.use(null, clazz);
        return (T)jsonDeserializer.deserialize(json);
    }

    public String looseSerialize(Object object) {
        JSONSerializer jsonSerializer = this.createJSONSerializer();
        return jsonSerializer.serialize(object);
    }

    public String looseSerialize(Object object, JSONTransformer jsonTransformer, Class<?> clazz) {
        JSONSerializer jsonSerializer = this.createJSONSerializer();
        jsonSerializer.transform(jsonTransformer, clazz);
        return jsonSerializer.serialize(object);
    }

    public String looseSerialize(Object object, String ... includes) {
        JSONSerializer jsonSerializer = this.createJSONSerializer();
        jsonSerializer.include(includes);
        return jsonSerializer.serialize(object);
    }

    public String looseSerializeDeep(Object object) {
        JSONSerializer jsonSerializer = this.createJSONSerializer();
        return jsonSerializer.serializeDeep(object);
    }

    public String looseSerializeDeep(Object object, JSONTransformer jsonTransformer, Class<?> clazz) {
        JSONSerializer jsonSerializer = this.createJSONSerializer();
        jsonSerializer.transform(jsonTransformer, clazz);
        return jsonSerializer.serializeDeep(object);
    }

    public String serialize(Object object) {
        try {
            return this._jsonSerializer.toJSON(object);
        }
        catch (MarshallException marshallException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)marshallException);
            }
            throw new IllegalStateException("Unable to serialize object", marshallException);
        }
    }

    public String serializeThrowable(Throwable throwable) {
        String throwableMessage;
        JSONObject jsonObject = this.createJSONObject();
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        }
        if (Validator.isNull((String)(throwableMessage = throwable.getMessage()))) {
            throwableMessage = throwable.toString();
        }
        JSONObject errorJSONObject = this.createJSONObject();
        errorJSONObject.put("message", throwableMessage).put("type", ClassUtil.getClassName((Object)throwable));
        jsonObject.put("error", errorJSONObject).put("exception", throwableMessage).put("throwable", throwable.toString());
        if (throwable.getCause() == null) {
            return jsonObject.toString();
        }
        Throwable rootCauseThrowable = throwable;
        while (rootCauseThrowable.getCause() != null) {
            rootCauseThrowable = rootCauseThrowable.getCause();
        }
        JSONObject rootCauseJSONObject = this.createJSONObject();
        throwableMessage = rootCauseThrowable.getMessage();
        if (Validator.isNull((String)throwableMessage)) {
            throwableMessage = rootCauseThrowable.toString();
        }
        rootCauseJSONObject.put("message", throwableMessage).put("type", ClassUtil.getClassName((Object)rootCauseThrowable));
        jsonObject.put("rootCause", rootCauseJSONObject);
        return jsonObject.toString();
    }
}

