/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.transformer;

import com.liferay.portal.json.transformer.ObjectTransformer;
import com.liferay.portal.kernel.json.JSONContext;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;

public class UserJSONTransformer
extends ObjectTransformer {
    @Override
    public void transform(JSONContext jsonContext, Object object) {
        User user = (User)object;
        boolean hidePrivateUserData = true;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null && !user.isGuestUser() && (user.getUserId() == permissionChecker.getUserId() || UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)user.getUserId(), (String)"VIEW"))) {
            hidePrivateUserData = false;
        }
        if (hidePrivateUserData) {
            user.setPasswordUnencrypted("");
            user.setReminderQueryQuestion("");
            user.setReminderQueryAnswer("");
            user.setEmailAddress("");
            user.setFacebookId(0L);
            user.setComments("");
        }
        super.transform(jsonContext, object);
    }
}

