/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.registry;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierConfiguration;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.AuthVerifierPipeline;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class AuthVerifierRegistry {
    private static final ServiceTrackerMap<String, AuthVerifier> _serviceTrackerMap;

    public static AuthVerifier getAuthVerifier(String simpleClassName) {
        return (AuthVerifier)_serviceTrackerMap.getService((Object)simpleClassName);
    }

    private static AuthVerifierConfiguration _buildAuthVerifierConfiguration(ServiceReference<AuthVerifier> serviceReference, AuthVerifier authVerifier) {
        Class<?> clazz = authVerifier.getClass();
        String authVerifierPropertyName = AuthVerifierPipeline.getAuthVerifierPropertyName(clazz.getName());
        Properties properties = new Properties();
        for (String propertyKey : serviceReference.getPropertyKeys()) {
            if (!propertyKey.startsWith(authVerifierPropertyName)) continue;
            properties.put(propertyKey.substring(authVerifierPropertyName.length()), serviceReference.getProperty(propertyKey));
        }
        if (properties.isEmpty()) {
            return null;
        }
        AuthVerifierConfiguration authVerifierConfiguration = new AuthVerifierConfiguration();
        authVerifierConfiguration.setAuthVerifierClassName(clazz.getName());
        authVerifierConfiguration.setProperties(properties);
        return authVerifierConfiguration;
    }

    static {
        final BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        _serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, AuthVerifier.class, null, (serviceReference, emitter) -> {
            String authVerifierClassName = GetterUtil.getString((Object)serviceReference.getProperty("auth.verifier.class.name"));
            if (Validator.isNotNull((String)authVerifierClassName)) {
                emitter.emit((Object)authVerifierClassName);
            } else {
                AuthVerifier authVerifier = (AuthVerifier)bundleContext.getService(serviceReference);
                Class<?> clazz = authVerifier.getClass();
                emitter.emit((Object)clazz.getSimpleName());
                bundleContext.ungetService(serviceReference);
            }
        });
        ServiceTracker serviceTracker = new ServiceTracker(bundleContext, AuthVerifier.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<AuthVerifier, Tracked>(){

            public Tracked addingService(ServiceReference<AuthVerifier> serviceReference) {
                AuthVerifier authVerifier = (AuthVerifier)bundleContext.getService(serviceReference);
                AuthVerifierConfiguration authVerifierConfiguration = AuthVerifierRegistry._buildAuthVerifierConfiguration((ServiceReference<AuthVerifier>)serviceReference, authVerifier);
                ServiceRegistration serviceRegistration = null;
                if (authVerifierConfiguration != null) {
                    serviceRegistration = bundleContext.registerService(AuthVerifierConfiguration.class, (Object)authVerifierConfiguration, null);
                }
                return new Tracked(authVerifier, serviceRegistration);
            }

            public void modifiedService(ServiceReference<AuthVerifier> serviceReference, Tracked tracked) {
                AuthVerifierConfiguration authVerifierConfiguration;
                ServiceRegistration<AuthVerifierConfiguration> serviceRegistration = tracked.getServiceRegistration();
                if (serviceRegistration != null) {
                    serviceRegistration.unregister();
                }
                if ((authVerifierConfiguration = AuthVerifierRegistry._buildAuthVerifierConfiguration((ServiceReference<AuthVerifier>)serviceReference, tracked.getAuthVerifier())) != null) {
                    bundleContext.registerService(AuthVerifierConfiguration.class, (Object)authVerifierConfiguration, null);
                }
                tracked.setServiceRegistration(serviceRegistration);
            }

            public void removedService(ServiceReference<AuthVerifier> serviceReference, Tracked tracked) {
                ServiceRegistration<AuthVerifierConfiguration> serviceRegistration = tracked.getServiceRegistration();
                if (serviceRegistration != null) {
                    serviceRegistration.unregister();
                }
                bundleContext.ungetService(serviceReference);
            }
        });
        serviceTracker.open();
    }

    private static class Tracked {
        private AuthVerifier _authVerifier;
        private ServiceRegistration<AuthVerifierConfiguration> _serviceRegistration;

        public AuthVerifier getAuthVerifier() {
            return this._authVerifier;
        }

        public ServiceRegistration<AuthVerifierConfiguration> getServiceRegistration() {
            return this._serviceRegistration;
        }

        public void setAuthVerifier(AuthVerifier authVerifier) {
            this._authVerifier = authVerifier;
        }

        public void setServiceRegistration(ServiceRegistration<AuthVerifierConfiguration> serviceRegistration) {
            this._serviceRegistration = serviceRegistration;
        }

        private Tracked(AuthVerifier authVerifier, ServiceRegistration<AuthVerifierConfiguration> serviceRegistration) {
            this._authVerifier = authVerifier;
            this._serviceRegistration = serviceRegistration;
        }
    }
}

