/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.NoSuchResourceActionException;
import com.liferay.portal.kernel.exception.NoSuchResourcePermissionException;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.internal.service.permission.ModelPermissionsImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Resource;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.ResourcePermissionTable;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionUpdateHandler;
import com.liferay.portal.kernel.security.permission.PermissionUpdateHandlerRegistryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.SQLStateAcceptor;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.service.persistence.ResourceActionPersistence;
import com.liferay.portal.kernel.service.persistence.RolePersistence;
import com.liferay.portal.kernel.spring.aop.Property;
import com.liferay.portal.kernel.spring.aop.Retry;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.ResourceImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.ResourcePermissionLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ResourcePermissionLocalServiceImpl
extends ResourcePermissionLocalServiceBaseImpl {
    private static final String _FIND_MISSING_RESOURCE_PERMISSIONS = ResourcePermissionLocalServiceImpl.class.getName() + ".findMissingResourcePermissions";
    private static final String _UPDATE_ACTION_IDS = ResourcePermissionLocalServiceImpl.class.getName() + ".updateActionIds";
    private static final Log _log = LogFactoryUtil.getLog(ResourcePermissionLocalServiceImpl.class);
    private static final Snapshot<IndividualPortletResourcePermissionProvider> _individualPortletResourcePermissionProviderSnapshot = new Snapshot(ResourcePermissionLocalServiceImpl.class, IndividualPortletResourcePermissionProvider.class);
    @BeanReference(type=ResourceActionLocalService.class)
    private ResourceActionLocalService _resourceActionLocalService;
    @BeanReference(type=ResourceActionPersistence.class)
    private ResourceActionPersistence _resourceActionPersistence;
    @BeanReference(type=RoleLocalService.class)
    private RoleLocalService _roleLocalService;
    @BeanReference(type=RolePersistence.class)
    private RolePersistence _rolePersistence;

    public void addModelResourcePermissions(AuditedModel auditedModel, ServiceContext serviceContext) throws PortalException {
        ModelPermissions modelPermissions = serviceContext.getModelPermissions();
        if (this._matches(modelPermissions, auditedModel.getModelClassName())) {
            ModelPermissionsImpl.setUsed((ModelPermissions)modelPermissions);
            this.addModelResourcePermissions(auditedModel.getCompanyId(), this.getGroupId(auditedModel), auditedModel.getUserId(), auditedModel.getModelClassName(), String.valueOf(auditedModel.getPrimaryKeyObj()), modelPermissions);
        } else if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            long groupId = 0L;
            if (serviceContext.isAddGroupPermissions()) {
                groupId = this.getGroupId(auditedModel);
            }
            this.addResourcePermissions(auditedModel.getCompanyId(), groupId, auditedModel.getUserId(), auditedModel.getModelClassName(), String.valueOf(auditedModel.getPrimaryKeyObj()), false, serviceContext);
        } else {
            if (serviceContext.isDeriveDefaultPermissions()) {
                serviceContext.deriveDefaultPermissions(this.getGroupId(auditedModel), auditedModel.getModelClassName());
            }
            this.addModelResourcePermissions(auditedModel.getCompanyId(), this.getGroupId(auditedModel), auditedModel.getUserId(), auditedModel.getModelClassName(), String.valueOf(auditedModel.getPrimaryKeyObj()), serviceContext.getModelPermissions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelResourcePermissions(long companyId, long groupId, long userId, String name, String primKey, ModelPermissions modelPermissions) throws PortalException {
        if (!PermissionThreadLocal.isAddResource()) {
            return;
        }
        this.validate(name, false);
        if (primKey == null) {
            return;
        }
        if (!this._matches(modelPermissions, name)) {
            modelPermissions = ModelPermissionsFactory.create((String)name);
            modelPermissions.addRolePermissions("Owner", new String[0]);
        }
        ModelPermissionsImpl.setUsed((ModelPermissions)modelPermissions);
        boolean flushResourcePermissionEnabled = PermissionThreadLocal.isFlushResourcePermissionEnabled((String)name, (String)primKey);
        PermissionThreadLocal.setFlushResourcePermissionEnabled((String)name, (String)primKey, (boolean)false);
        try {
            Role ownerRole = this._roleLocalService.getRole(companyId, "Owner");
            List ownerActionIds = ResourceActionsUtil.getModelResourceActions((String)name);
            this.filterOwnerActions(name, ownerActionIds);
            String[] ownerPermissions = ownerActionIds.toArray(new String[0]);
            this.setOwnerResourcePermissions(companyId, name, 4, primKey, ownerRole.getRoleId(), userId, ownerPermissions);
            for (String roleName : modelPermissions.getRoleNames()) {
                Role role = this.getRole(companyId, groupId, roleName);
                this.setResourcePermissions(companyId, name, 4, primKey, role.getRoleId(), modelPermissions.getActionIds(roleName));
            }
        }
        finally {
            PermissionThreadLocal.setFlushResourcePermissionEnabled((String)name, (String)primKey, (boolean)flushResourcePermissionEnabled);
            PermissionCacheUtil.clearResourcePermissionCache(4, name, primKey);
            IndexWriterHelperUtil.updatePermissionFields((String)name, (String)primKey);
        }
    }

    public void addModelResourcePermissions(long companyId, long groupId, long userId, String name, String primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        ModelPermissions modelPermissions = ModelPermissionsFactory.create((String[])groupPermissions, (String[])guestPermissions, (String)name);
        this.addModelResourcePermissions(companyId, groupId, userId, name, primKey, modelPermissions);
    }

    @Retry(acceptor=SQLStateAcceptor.class, properties={@Property(name="SQLSTATE", value="23")})
    public void addResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException {
        if (scope == 1) {
            this.removeResourcePermissions(companyId, name, 2, roleId, actionId);
        } else if (scope == 2) {
            this.removeResourcePermissions(companyId, name, 1, roleId, actionId);
        } else if (scope == 4) {
            throw new NoSuchResourcePermissionException();
        }
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, 0L, new String[]{actionId}, 1);
    }

    public void addResourcePermissions(long companyId, long groupId, long userId, String name, String primKey, boolean portletActions, ServiceContext serviceContext) throws PortalException {
        if (!PermissionThreadLocal.isAddResource()) {
            return;
        }
        this.validate(name, portletActions);
        if (primKey == null) {
            return;
        }
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, 4, primKey);
        this._addResourcePermissions(companyId, groupId, userId, name, primKey, resourcePermissions, portletActions, serviceContext);
    }

    public void addResourcePermissions(long companyId, long groupId, long userId, String name, String[] primKeys, boolean portletActions, ServiceContext serviceContext) throws PortalException {
        if (!PermissionThreadLocal.isAddResource()) {
            return;
        }
        this.validate(name, portletActions);
        if (primKeys == null) {
            return;
        }
        HashMap resourcePermissionsMap = new HashMap();
        for (ResourcePermission resourcePermission : this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, 4, primKeys)) {
            List resourcePermissions = resourcePermissionsMap.computeIfAbsent(resourcePermission.getPrimKey(), key -> new ArrayList());
            resourcePermissions.add(resourcePermission);
        }
        for (String primKey : primKeys) {
            this._addResourcePermissions(companyId, groupId, userId, name, primKey, resourcePermissionsMap.getOrDefault(primKey, Collections.emptyList()), portletActions, serviceContext);
        }
    }

    public void addResourcePermissions(String resourceName, String roleName, int scope, long resourceActionBitwiseValue) {
        List roles = this._rolePersistence.findByName(roleName);
        if (roles.isEmpty()) {
            return;
        }
        Session session = this.resourcePermissionPersistence.openSession();
        try {
            String sql = CustomSQLUtil.get((String)_UPDATE_ACTION_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ROLE_ID$]", (String)ListUtil.toString((List)roles, (Accessor)Role.ROLE_ID_ACCESSOR));
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(resourceActionBitwiseValue);
            queryPos.add(resourceActionBitwiseValue);
            queryPos.add(resourceName);
            queryPos.add(scope);
            sqlQuery.executeUpdate();
            sql = CustomSQLUtil.get((String)_FIND_MISSING_RESOURCE_PERMISSIONS);
            sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("companyId", Type.LONG);
            sqlQuery.addScalar("name", Type.STRING);
            sqlQuery.addScalar("scope", Type.INTEGER);
            sqlQuery.addScalar("primKey", Type.STRING);
            sqlQuery.addScalar("roleId", Type.LONG);
            queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(resourceName);
            queryPos.add(scope);
            queryPos.add(roleName);
            List resourcePermissionArrays = sqlQuery.list(true);
            if (resourcePermissionArrays.isEmpty()) {
                return;
            }
            for (Object[] resourcePermissionArray : resourcePermissionArrays) {
                long resourcePermissionId = this.counterLocalService.increment(ResourcePermission.class.getName());
                ResourcePermission resourcePermission = this.resourcePermissionPersistence.create(resourcePermissionId);
                resourcePermission.setCompanyId(((Long)resourcePermissionArray[0]).longValue());
                resourcePermission.setName((String)resourcePermissionArray[1]);
                resourcePermission.setScope(((Integer)resourcePermissionArray[2]).intValue());
                String primKey = (String)resourcePermissionArray[3];
                resourcePermission.setPrimKey(primKey);
                resourcePermission.setPrimKeyId(GetterUtil.getLong((String)primKey));
                resourcePermission.setRoleId(((Long)resourcePermissionArray[4]).longValue());
                resourcePermission.setActionIds(resourceActionBitwiseValue);
                resourcePermission.setViewActionId(resourceActionBitwiseValue % 2L == 1L);
                session.save((Object)resourcePermission);
                PermissionCacheUtil.clearResourcePermissionCache(resourcePermission.getScope(), resourcePermission.getName(), resourcePermission.getPrimKey());
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.resourcePermissionPersistence.closeSession(session);
            this.resourcePermissionPersistence.clearCache();
        }
    }

    public void copyModelResourcePermissions(long companyId, String name, long sourcePrimKey, long targetPrimKey) throws PortalException {
        List sourceResourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, 4, String.valueOf(sourcePrimKey));
        if (sourceResourcePermissions.isEmpty()) {
            return;
        }
        long batchCounter = this.counterLocalService.increment(ResourcePermission.class.getName(), sourceResourcePermissions.size());
        batchCounter -= (long)sourceResourcePermissions.size();
        for (ResourcePermission sourceResourcePermission : sourceResourcePermissions) {
            ResourcePermission targetResourcePermission = this.resourcePermissionPersistence.create(++batchCounter);
            targetResourcePermission.setCompanyId(companyId);
            targetResourcePermission.setName(name);
            targetResourcePermission.setScope(sourceResourcePermission.getScope());
            targetResourcePermission.setPrimKey(String.valueOf(targetPrimKey));
            targetResourcePermission.setPrimKeyId(targetPrimKey);
            targetResourcePermission.setRoleId(sourceResourcePermission.getRoleId());
            targetResourcePermission.setOwnerId(sourceResourcePermission.getOwnerId());
            targetResourcePermission.setActionIds(sourceResourcePermission.getActionIds());
            targetResourcePermission.setViewActionId(sourceResourcePermission.isViewActionId());
            this.resourcePermissionPersistence.update((BaseModel)targetResourcePermission);
        }
    }

    public void deleteResourcePermissions(long companyId, String name, int scope, long primKey) throws PortalException {
        this.deleteResourcePermissions(companyId, name, scope, String.valueOf(primKey));
    }

    public void deleteResourcePermissions(long companyId, String name, int scope, String primKey) throws PortalException {
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, scope, primKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this.deleteResourcePermission(resourcePermission.getResourcePermissionId());
        }
    }

    public ResourcePermission fetchResourcePermission(long companyId, String name, int scope, String primKey, long roleId) {
        return this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, name, scope, primKey, roleId);
    }

    public Map<Long, Set<String>> getAvailableResourcePermissionActionIds(long companyId, String name, int scope, String primKey, Collection<String> actionIds) {
        if (actionIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List<ResourcePermission> resourcePermissions = this.getResourcePermissions(companyId, name, scope, primKey);
        HashMap<Long, Set<String>> roleIdsToActionIds = new HashMap<Long, Set<String>>();
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (resourcePermission.getActionIds() == 0L) {
                roleIdsToActionIds.put(resourcePermission.getRoleId(), Collections.emptySet());
                continue;
            }
            HashSet<String> availableActionIds = new HashSet<String>();
            for (String actionId : actionIds) {
                if (!resourcePermission.hasActionId(actionId)) continue;
                availableActionIds.add(actionId);
            }
            if (availableActionIds.isEmpty()) continue;
            roleIdsToActionIds.put(resourcePermission.getRoleId(), availableActionIds);
        }
        return roleIdsToActionIds;
    }

    public List<String> getAvailableResourcePermissionActionIds(long companyId, String name, int scope, String primKey, long roleId, Collection<String> actionIds) throws PortalException {
        ResourcePermission resourcePermission = this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, name, scope, primKey, roleId);
        if (resourcePermission == null) {
            return Collections.emptyList();
        }
        ArrayList<String> availableActionIds = new ArrayList<String>(actionIds.size());
        for (String actionId : actionIds) {
            if (!resourcePermission.hasAction(this._resourceActionLocalService.getResourceAction(name, actionId))) continue;
            availableActionIds.add(actionId);
        }
        return availableActionIds;
    }

    public Map<String, List<ResourcePermission>> getIndividualPortletResourcePermissions(long companyId) {
        GroupByStep dslQuery = DSLQueryFactoryUtil.select((Table)ResourcePermissionTable.INSTANCE).from((Table)ResourcePermissionTable.INSTANCE).where(ResourcePermissionTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)ResourcePermissionTable.INSTANCE.name.eq((Expression)ResourcePermissionTable.INSTANCE.primKey)).and((Expression)ResourcePermissionTable.INSTANCE.scope.eq((Object)4)));
        HashMap<String, List<ResourcePermission>> resourcePermissionsMap = new HashMap<String, List<ResourcePermission>>();
        for (ResourcePermission resourcePermission : (List)this.resourcePermissionPersistence.dslQuery((DSLQuery)dslQuery)) {
            List resourcePermissions = resourcePermissionsMap.computeIfAbsent(resourcePermission.getName(), key -> new ArrayList());
            resourcePermissions.add((ResourcePermission)resourcePermission.clone());
        }
        return resourcePermissionsMap;
    }

    public ResourcePermission getResourcePermission(long companyId, String name, int scope, String primKey, long roleId) throws PortalException {
        return this.resourcePermissionPersistence.findByC_N_S_P_R(companyId, name, scope, primKey, roleId);
    }

    public List<ResourcePermission> getResourcePermissions(long companyId, String name, int scope, String primKey) {
        return this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, scope, primKey);
    }

    public List<ResourcePermission> getResourcePermissions(String name) {
        return this.resourcePermissionPersistence.findByName(name);
    }

    public int getResourcePermissionsCount(long companyId, String name, int scope, String primKey) {
        return this.resourcePermissionPersistence.countByC_N_S_P(companyId, name, scope, primKey);
    }

    public List<ResourcePermission> getResourceResourcePermissions(long companyId, long groupId, String name, String primKey) {
        return this.resourcePermissionFinder.findByResource(companyId, groupId, name, primKey);
    }

    public List<ResourcePermission> getRoleResourcePermissions(long roleId) {
        return this.resourcePermissionPersistence.findByRoleId(roleId);
    }

    public List<ResourcePermission> getRoleResourcePermissions(long roleId, int[] scopes, int start, int end) {
        return this.resourcePermissionFinder.findByR_S(roleId, scopes, start, end);
    }

    public List<Role> getRoles(long companyId, String name, int scope, String primKey, String actionId) throws PortalException {
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, scope, primKey);
        if (resourcePermissions.isEmpty()) {
            return Collections.emptyList();
        }
        ResourceAction resourceAction = this._resourceActionLocalService.getResourceAction(name, actionId);
        HashSet<Long> rolesIds = new HashSet<Long>();
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (!resourcePermission.hasAction(resourceAction)) continue;
            rolesIds.add(resourcePermission.getRoleId());
        }
        ArrayList<Role> roles = new ArrayList<Role>(rolesIds.size());
        Iterator iterator = rolesIds.iterator();
        while (iterator.hasNext()) {
            long roleId = (Long)iterator.next();
            roles.add(this._roleLocalService.getRole(roleId));
        }
        return roles;
    }

    public List<ResourcePermission> getScopeResourcePermissions(int[] scopes) {
        return this.resourcePermissionPersistence.findByScope(scopes);
    }

    public boolean hasActionId(ResourcePermission resourcePermission, ResourceAction resourceAction) {
        return resourcePermission.hasAction(resourceAction);
    }

    public boolean hasResourcePermission(List<Resource> resources, long[] roleIds, String actionId) throws PortalException {
        if (roleIds.length == 0) {
            return false;
        }
        int size = resources.size();
        if (size < 2) {
            throw new IllegalArgumentException("The list of resources must contain at least two values");
        }
        Resource individualResource = resources.get(0);
        if (individualResource.getScope() != 4) {
            throw new IllegalArgumentException("The first resource must be an individual scope");
        }
        Resource companyResource = resources.get(size - 1);
        if (companyResource.getScope() != 1) {
            throw new IllegalArgumentException("The last resource must be a company scope");
        }
        int count = this.resourcePermissionPersistence.countByC_N_S_P(individualResource.getCompanyId(), individualResource.getName(), individualResource.getScope(), individualResource.getPrimKey());
        if (count < 1) {
            throw new NoSuchResourcePermissionException(StringBundler.concat((Object[])new Object[]{"{companyId=", individualResource.getCompanyId(), ", name=", individualResource.getName(), ", primKey=", individualResource.getPrimKey(), ", scope=", individualResource.getScope(), "}"}));
        }
        for (int i = size - 1; i >= 0; --i) {
            Resource resource = resources.get(i);
            if (!this.hasResourcePermission(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), roleIds, actionId)) continue;
            return true;
        }
        return false;
    }

    public boolean hasResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException {
        ResourcePermission resourcePermission = this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, name, scope, primKey, roleId);
        if (resourcePermission == null) {
            return false;
        }
        return resourcePermission.hasAction(this._resourceActionLocalService.getResourceAction(name, actionId));
    }

    public boolean hasResourcePermission(long companyId, String name, int scope, String primKey, long[] roleIds, String actionId) throws PortalException {
        if (roleIds.length == 0) {
            return false;
        }
        ResourceAction resourceAction = this._resourceActionLocalService.getResourceAction(name, actionId);
        if (roleIds.length > PropsValues.PERMISSIONS_ROLE_RESOURCE_PERMISSION_QUERY_THRESHOLD) {
            int count = this.resourcePermissionFinder.countByC_N_S_P_R_A(companyId, name, scope, primKey, roleIds, resourceAction.getBitwiseValue());
            if (count > 0) {
                return true;
            }
        } else {
            List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P_R(companyId, name, scope, primKey, roleIds);
            if (resourcePermissions.isEmpty()) {
                return false;
            }
            for (ResourcePermission resourcePermission : resourcePermissions) {
                if (!resourcePermission.hasAction(resourceAction)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasScopeResourcePermission(long companyId, String name, int scope, long roleId, String actionId) throws PortalException {
        ResourceAction resourceAction = this._resourceActionLocalService.getResourceAction(name, actionId);
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_R(companyId, name, scope, roleId);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (!resourcePermission.hasAction(resourceAction)) continue;
            return true;
        }
        return false;
    }

    public void initPortletDefaultPermissions(Portlet portlet) throws PortalException {
        Role guestRole = this._roleLocalService.getRole(portlet.getCompanyId(), "Guest");
        Role ownerRole = this._roleLocalService.getRole(portlet.getCompanyId(), "Owner");
        Role siteMemberRole = this._roleLocalService.getRole(portlet.getCompanyId(), "Site Member");
        List guestPortletActions = ResourceActionsUtil.getPortletResourceGuestDefaultActions((String)portlet.getRootPortletId());
        List ownerPortletActionIds = ResourceActionsUtil.getPortletResourceActions((String)portlet.getRootPortletId());
        List groupPortletActionIds = ResourceActionsUtil.getPortletResourceGroupDefaultActions((String)portlet.getRootPortletId());
        this._initPortletDefaultPermissions(portlet.getCompanyId(), portlet.getRootPortletId(), guestRole, ownerRole, siteMemberRole, guestPortletActions, ownerPortletActionIds, groupPortletActionIds);
        String rootModelResource = ResourceActionsUtil.getPortletRootModelResource((String)portlet.getRootPortletId());
        List modelResources = ResourceActionsUtil.getPortletModelResources((String)portlet.getRootPortletId());
        for (String modelResource : modelResources) {
            if (Validator.isBlank((String)modelResource)) continue;
            this.validate(modelResource, false);
            List groupModelActionIds = null;
            if (Objects.equals(rootModelResource, modelResource)) {
                groupModelActionIds = ResourceActionsUtil.getModelResourceGroupDefaultActions((String)rootModelResource);
            }
            List guestModelActionIds = ResourceActionsUtil.getModelResourceGuestDefaultActions((String)modelResource);
            List ownerModelActionIds = ResourceActionsUtil.getModelResourceActions((String)modelResource);
            this.filterOwnerActions(modelResource, ownerModelActionIds);
            this._initPortletDefaultPermissions(portlet.getCompanyId(), modelResource, guestRole, ownerRole, siteMemberRole, guestModelActionIds, ownerModelActionIds, groupModelActionIds);
        }
    }

    public void mergePermissions(long fromRoleId, long toRoleId) throws PortalException {
        Role fromRole = this._rolePersistence.findByPrimaryKey(fromRoleId);
        Role toRole = this._rolePersistence.findByPrimaryKey(toRoleId);
        if (fromRole.getType() != toRole.getType()) {
            throw new PortalException("Role types are mismatched");
        }
        if (toRole.isSystem()) {
            throw new PortalException("Cannot move permissions to system role");
        }
        if (fromRole.isSystem()) {
            throw new PortalException("Cannot move permissions from system role");
        }
        List<ResourcePermission> resourcePermissions = this.getRoleResourcePermissions(fromRoleId);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            resourcePermission.setRoleId(toRoleId);
            this.resourcePermissionPersistence.update((BaseModel)resourcePermission);
        }
        this._roleLocalService.deleteRole(fromRoleId);
    }

    public void reassignPermissions(long resourcePermissionId, long toRoleId) throws PortalException {
        ResourcePermission resourcePermission = this.getResourcePermission(resourcePermissionId);
        String name = resourcePermission.getName();
        long fromRoleId = resourcePermission.getRoleId();
        Role toRole = this._roleLocalService.getRole(toRoleId);
        List actionIds = null;
        actionIds = toRole.getType() == 1 ? ResourceActionsUtil.getModelResourceActions((String)name) : ResourceActionsUtil.getModelResourceGroupDefaultActions((String)name);
        this.setResourcePermissions(resourcePermission.getCompanyId(), name, resourcePermission.getScope(), resourcePermission.getPrimKey(), toRoleId, actionIds.toArray(new String[0]));
        this.resourcePermissionPersistence.remove(resourcePermissionId);
        List<ResourcePermission> resourcePermissions = this.getRoleResourcePermissions(fromRoleId);
        if (resourcePermissions.isEmpty()) {
            this._roleLocalService.deleteRole(fromRoleId);
        }
    }

    public void removeResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException {
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, 0L, new String[]{actionId}, 2);
    }

    public void removeResourcePermissions(long companyId, String name, int scope, long roleId, String actionId) throws PortalException {
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_R(companyId, name, scope, roleId);
        String[] actionIds = new String[]{actionId};
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this._updateResourcePermission(companyId, name, scope, resourcePermission.getPrimKey(), 0L, roleId, null, actionIds, 2, true, Collections.singletonMap(roleId, resourcePermission));
        }
    }

    @Retry(acceptor=SQLStateAcceptor.class, properties={@Property(name="SQLSTATE", value="23")})
    public void setOwnerResourcePermissions(long companyId, String name, int scope, String primKey, long roleId, long ownerId, String[] actionIds) throws PortalException {
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, ownerId, actionIds, 3);
    }

    @Retry(acceptor=SQLStateAcceptor.class, properties={@Property(name="SQLSTATE", value="23")})
    public void setResourcePermissions(long companyId, String name, int scope, String primKey, long roleId, String[] actionIds) throws PortalException {
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, 0L, actionIds, 3);
    }

    @Retry(acceptor=SQLStateAcceptor.class, properties={@Property(name="SQLSTATE", value="23")})
    public void setResourcePermissions(long companyId, String name, int scope, String primKey, Map<Long, String[]> roleIdsToActionIds) throws PortalException {
        this.updateResourcePermission(companyId, name, scope, primKey, 0L, roleIdsToActionIds);
    }

    public void updateModelResourcePermissions(AuditedModel auditedModel, ServiceContext serviceContext) throws PortalException {
        this.updateResourcePermissions(auditedModel.getCompanyId(), this.getGroupId(auditedModel), auditedModel.getModelClassName(), String.valueOf(auditedModel.getPrimaryKeyObj()), serviceContext.getModelPermissions());
    }

    public void updateResourcePermissions(long companyId, long groupId, String name, long primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        ResourceImpl resource = new ResourceImpl();
        resource.setCompanyId(companyId);
        resource.setName(name);
        resource.setScope(4);
        resource.setPrimKey(String.valueOf(primKey));
        if (groupPermissions == null) {
            groupPermissions = new String[]{};
        }
        if (guestPermissions == null) {
            guestPermissions = new String[]{};
        }
        this.addGroupPermissions(groupId, resource, groupPermissions);
        this.addGuestPermissions(resource, guestPermissions);
    }

    public void updateResourcePermissions(long companyId, long groupId, String name, String primKey, ModelPermissions modelPermissions) throws PortalException {
        if (!this._matches(modelPermissions, name)) {
            return;
        }
        ModelPermissionsImpl.setUsed((ModelPermissions)modelPermissions);
        for (String roleName : modelPermissions.getRoleNames()) {
            Role role = this.getRole(companyId, groupId, roleName);
            this.setResourcePermissions(companyId, name, 4, primKey, role.getRoleId(), modelPermissions.getActionIds(roleName));
        }
    }

    public void updateResourcePermissions(long companyId, long groupId, String name, String primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        ModelPermissions modelPermissions = ModelPermissionsFactory.create((String[])groupPermissions, (String[])guestPermissions, (String)name);
        this.updateResourcePermissions(companyId, groupId, name, primKey, modelPermissions);
    }

    public void updateResourcePermissions(long companyId, String name, int scope, String primKey, String newPrimKey) {
        List<ResourcePermission> resourcePermissions = this.getResourcePermissions(companyId, name, scope, primKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            resourcePermission.setPrimKey(newPrimKey);
            resourcePermission.setPrimKeyId(GetterUtil.getLong((String)newPrimKey));
            this.resourcePermissionPersistence.update((BaseModel)resourcePermission);
        }
    }

    protected void addGroupPermissions(long groupId, Resource resource, String[] actionIds) throws PortalException {
        Role role = this._roleLocalService.getDefaultGroupRole(groupId);
        this.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), actionIds);
    }

    protected void addGuestPermissions(Resource resource, String[] actionIds) throws PortalException {
        Role guestRole = this._roleLocalService.getRole(resource.getCompanyId(), "Guest");
        this.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), guestRole.getRoleId(), actionIds);
    }

    protected void filterOwnerActions(String name, List<String> actionIds) {
        List defaultOwnerActions = ResourceActionsUtil.getModelResourceOwnerDefaultActions((String)name);
        if (!defaultOwnerActions.isEmpty()) {
            actionIds.retainAll(defaultOwnerActions);
        }
    }

    protected long getGroupId(AuditedModel auditedModel) {
        if (auditedModel instanceof GroupedModel) {
            GroupedModel groupedModel = (GroupedModel)auditedModel;
            return groupedModel.getGroupId();
        }
        return BeanPropertiesUtil.getLongSilent((Object)auditedModel, (String)"groupId", (long)0L);
    }

    protected Role getRole(long companyId, long groupId, String roleName) throws PortalException {
        if (roleName.equals("PLACEHOLDER_DEFAULT_GROUP_ROLE")) {
            if (groupId == 0L) {
                throw new NoSuchRoleException("Specify a group ID other than 0 for role name PLACEHOLDER_DEFAULT_GROUP_ROLE");
            }
            return this._roleLocalService.getDefaultGroupRole(groupId);
        }
        return this._roleLocalService.getRole(companyId, roleName);
    }

    protected boolean isGuestRoleId(long companyId, long roleId, Boolean guestRole) {
        if (guestRole != null) {
            return guestRole;
        }
        Role role = this._roleLocalService.fetchRole(companyId, "Guest");
        return role != null && roleId == role.getRoleId();
    }

    protected void updateResourcePermission(long companyId, String name, int scope, String primKey, long roleId, long ownerId, String[] actionIds, int operator) throws PortalException {
        this._updateResourcePermission(companyId, name, scope, primKey, ownerId, roleId, null, actionIds, operator, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateResourcePermission(long companyId, String name, int scope, String primKey, long ownerId, Map<Long, String[]> roleIdsToActionIds) throws PortalException {
        boolean flushResourcePermissionEnabled = PermissionThreadLocal.isFlushResourcePermissionEnabled((String)name, (String)primKey);
        PermissionThreadLocal.setFlushResourcePermissionEnabled((String)name, (String)primKey, (boolean)false);
        try {
            PermissionUpdateHandler permissionUpdateHandler;
            String[] actionIds;
            long roleId;
            int start;
            long[] roleIds = ArrayUtil.toLongArray(roleIdsToActionIds.keySet());
            ArrayList resourcePermissions = new ArrayList(roleIds.length);
            int batchSize = 1000;
            for (start = 0; start < roleIds.length - batchSize; start += batchSize) {
                resourcePermissions.addAll(this.resourcePermissionPersistence.findByC_N_S_P_R(companyId, name, scope, primKey, ArrayUtil.subset((long[])roleIds, (int)start, (int)(start + batchSize))));
            }
            resourcePermissions.addAll(this.resourcePermissionPersistence.findByC_N_S_P_R(companyId, name, scope, primKey, ArrayUtil.subset((long[])roleIds, (int)start, (int)roleIds.length)));
            roleIdsToActionIds = new HashMap<Long, String[]>(roleIdsToActionIds);
            for (ResourcePermission resourcePermission : resourcePermissions) {
                roleId = resourcePermission.getRoleId();
                actionIds = roleIdsToActionIds.remove(roleId);
                this._updateResourcePermission(companyId, name, scope, primKey, ownerId, roleId, null, actionIds, 3, true, null);
            }
            if (roleIdsToActionIds.isEmpty()) {
                return;
            }
            for (Map.Entry entry : roleIdsToActionIds.entrySet()) {
                roleId = (Long)entry.getKey();
                actionIds = (String[])entry.getValue();
                this._updateResourcePermission(companyId, name, scope, primKey, ownerId, roleId, null, actionIds, 3, false, null);
            }
            if (!MergeLayoutPrototypesThreadLocal.isInProgress() && !ExportImportThreadLocal.isImportInProcess() && (permissionUpdateHandler = PermissionUpdateHandlerRegistryUtil.getPermissionUpdateHandler((String)name)) != null) {
                permissionUpdateHandler.updatedPermission(primKey);
            }
        }
        finally {
            PermissionThreadLocal.setFlushResourcePermissionEnabled((String)name, (String)primKey, (boolean)flushResourcePermissionEnabled);
            PermissionCacheUtil.clearResourcePermissionCache(scope, name, primKey);
            IndexWriterHelperUtil.updatePermissionFields((String)name, (String)primKey);
        }
    }

    protected void validate(String name, boolean portletActions) throws PortalException {
        List actions = null;
        actions = portletActions ? ResourceActionsUtil.getPortletResourceActions((String)name) : ResourceActionsUtil.getModelResourceActions((String)name);
        if (ListUtil.isEmpty((List)actions)) {
            int count;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Checking other resource actions because no model or portlet resource actions found for " + name));
            }
            if ((count = this._resourceActionPersistence.countByName(name)) == 0) {
                throw new NoSuchResourceActionException("There are no actions associated with the resource " + name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addResourcePermissions(long companyId, long groupId, long userId, String name, String primKey, List<ResourcePermission> resourcePermissions, boolean portletActions, ServiceContext serviceContext) throws PortalException {
        boolean flushResourcePermissionEnabled = PermissionThreadLocal.isFlushResourcePermissionEnabled((String)name, (String)primKey);
        PermissionThreadLocal.setFlushResourcePermissionEnabled((String)name, (String)primKey, (boolean)false);
        Map<Long, ResourcePermission> resourcePermissionsMap = this._getResourcePermissionsMap(resourcePermissions);
        boolean modified = false;
        try {
            List actions;
            List actionIds = null;
            if (portletActions) {
                actionIds = ResourceActionsUtil.getPortletResourceActions((String)name);
            } else {
                actionIds = ResourceActionsUtil.getModelResourceActions((String)name);
                this.filterOwnerActions(name, actionIds);
            }
            Role role = this._roleLocalService.getRole(companyId, "Owner");
            if (this._updateResourcePermission(companyId, name, 4, primKey, userId, role.getRoleId(), Boolean.FALSE, actionIds.toArray(new String[0]), 3, true, resourcePermissionsMap)) {
                modified = true;
            }
            if (groupId > 0L && serviceContext != null && serviceContext.isAddGroupPermissions()) {
                actions = null;
                actions = portletActions ? ResourceActionsUtil.getPortletResourceGroupDefaultActions((String)name) : ResourceActionsUtil.getModelResourceGroupDefaultActions((String)name);
                Role groupRole = this._roleLocalService.getDefaultGroupRole(groupId);
                if (this._updateResourcePermission(companyId, name, 4, primKey, 0L, groupRole.getRoleId(), Boolean.FALSE, actions.toArray(new String[0]), 3, true, resourcePermissionsMap)) {
                    modified = true;
                }
            }
            if (serviceContext != null && serviceContext.isAddGuestPermissions()) {
                actions = null;
                actions = portletActions ? ResourceActionsUtil.getPortletResourceGuestDefaultActions((String)name) : ResourceActionsUtil.getModelResourceGuestDefaultActions((String)name);
                Role guestRole = this._roleLocalService.getRole(companyId, "Guest");
                if (this._updateResourcePermission(companyId, name, 4, primKey, 0L, guestRole.getRoleId(), Boolean.TRUE, actions.toArray(new String[0]), 3, true, resourcePermissionsMap)) {
                    modified = true;
                }
            }
        }
        finally {
            PermissionThreadLocal.setFlushResourcePermissionEnabled((String)name, (String)primKey, (boolean)flushResourcePermissionEnabled);
            if (modified) {
                PermissionCacheUtil.clearResourcePermissionCache(4, name, primKey);
                if (serviceContext == null || serviceContext.isIndexingEnabled()) {
                    IndexWriterHelperUtil.updatePermissionFields((String)name, (String)primKey);
                }
            }
        }
    }

    private Map<Long, ResourcePermission> _getResourcePermissionsMap(List<ResourcePermission> resourcePermissions) {
        HashMap<Long, ResourcePermission> resourcePermissionsMap = new HashMap<Long, ResourcePermission>();
        for (ResourcePermission resourcePermission : resourcePermissions) {
            resourcePermissionsMap.put(resourcePermission.getRoleId(), resourcePermission);
        }
        return resourcePermissionsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initPortletDefaultPermissions(long companyId, String name, Role guestRole, Role ownerRole, Role siteMemberRole, List<String> guestActionIds, List<String> ownerActionIds, List<String> groupActionIds) throws PortalException {
        IndividualPortletResourcePermissionProvider individualPortletResourcePermissionProvider = (IndividualPortletResourcePermissionProvider)_individualPortletResourcePermissionProviderSnapshot.get();
        List resourcePermissions = null;
        if (individualPortletResourcePermissionProvider != null) {
            resourcePermissions = individualPortletResourcePermissionProvider.getResourcePermissions(companyId, name);
        }
        if (resourcePermissions == null) {
            resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, 4, name);
        }
        Map<Long, ResourcePermission> resourcePermissionsMap = this._getResourcePermissionsMap(resourcePermissions);
        boolean flushResourcePermissionEnabled = PermissionThreadLocal.isFlushResourcePermissionEnabled((String)name, (String)name);
        PermissionThreadLocal.setFlushResourcePermissionEnabled((String)name, (String)name, (boolean)false);
        boolean modified = false;
        try {
            boolean guestPermissionModified = this._updateResourcePermission(companyId, name, 4, name, 0L, guestRole.getRoleId(), Boolean.TRUE, guestActionIds.toArray(new String[0]), 3, true, resourcePermissionsMap);
            boolean ownerPermissionModified = this._updateResourcePermission(companyId, name, 4, name, 0L, ownerRole.getRoleId(), Boolean.FALSE, ownerActionIds.toArray(new String[0]), 3, true, resourcePermissionsMap);
            boolean siteMemberPermissionModified = false;
            if (groupActionIds != null) {
                siteMemberPermissionModified = this._updateResourcePermission(companyId, name, 4, name, 0L, siteMemberRole.getRoleId(), Boolean.FALSE, groupActionIds.toArray(new String[0]), 3, true, resourcePermissionsMap);
            }
            if (guestPermissionModified || ownerPermissionModified || siteMemberPermissionModified) {
                modified = true;
            }
        }
        finally {
            PermissionThreadLocal.setFlushResourcePermissionEnabled((String)name, (String)name, (boolean)flushResourcePermissionEnabled);
            if (modified) {
                PermissionCacheUtil.clearResourcePermissionCache(4, name, name);
                if (individualPortletResourcePermissionProvider != null) {
                    individualPortletResourcePermissionProvider.removeResourcePermissions(companyId, name);
                }
                IndexWriterHelperUtil.updatePermissionFields((String)name, (String)name);
            }
        }
    }

    private boolean _matches(ModelPermissions modelPermissions, String resourcePermissionName) {
        if (modelPermissions == null || ModelPermissionsImpl.RESOURCE_NAME_UNINITIALIZED.equals(modelPermissions.getResourceName())) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)new Exception("Uninitialized model permissions used for " + resourcePermissionName));
            }
            return false;
        }
        if (ModelPermissionsImpl.RESOURCE_NAME_FIRST_RESOURCE.equals(modelPermissions.getResourceName())) {
            if (!ModelPermissionsImpl.isUsed((ModelPermissions)modelPermissions)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)new Exception("First model permissions used for " + resourcePermissionName));
                }
                return true;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)new Exception("First model permissions already used for " + resourcePermissionName));
            }
            return false;
        }
        if (ModelPermissionsImpl.RESOURCE_NAME_ALL_RESOURCES.equals(modelPermissions.getResourceName())) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)new Exception("Model permissions for all resources used for " + resourcePermissionName));
            }
            return true;
        }
        if (resourcePermissionName.equals(modelPermissions.getResourceName())) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)new Exception("Correct model permissions used for " + resourcePermissionName));
            }
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Throwable)new Exception(StringBundler.concat((String[])new String[]{"Incorrect resource name ", modelPermissions.getResourceName(), " used for ", resourcePermissionName})));
        }
        return false;
    }

    private boolean _updateResourcePermission(long companyId, String name, int scope, String primKey, long ownerId, long roleId, Boolean guestRole, String[] actionIds, int operator, boolean fetch, Map<Long, ResourcePermission> resourcePermissionsMap) throws PortalException {
        ResourcePermission resourcePermission = null;
        if (resourcePermissionsMap != null) {
            resourcePermission = resourcePermissionsMap.get(roleId);
        } else if (fetch) {
            resourcePermission = this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, name, scope, primKey, roleId);
        }
        if (resourcePermission == null) {
            if ((operator == 1 || operator == 3) && actionIds.length == 0) {
                return false;
            }
            if (operator == 2) {
                return false;
            }
            long resourcePermissionId = this.counterLocalService.increment(ResourcePermission.class.getName());
            resourcePermission = this.resourcePermissionPersistence.create(resourcePermissionId);
            resourcePermission.setCompanyId(companyId);
            resourcePermission.setName(name);
            resourcePermission.setScope(scope);
            resourcePermission.setPrimKey(primKey);
            resourcePermission.setPrimKeyId(GetterUtil.getLong((String)primKey));
            resourcePermission.setRoleId(roleId);
            resourcePermission.setOwnerId(ownerId);
            if (resourcePermissionsMap != null) {
                resourcePermissionsMap.put(roleId, resourcePermission);
            }
        }
        List unsupportedActionIds = Collections.emptyList();
        if ((operator == 1 || operator == 3) && this.isGuestRoleId(companyId, roleId, guestRole)) {
            unsupportedActionIds = ResourceActionsUtil.getResourceGuestUnsupportedActions((String)name, (String)name);
        }
        long actionIdsLong = resourcePermission.getActionIds();
        if (operator == 3) {
            actionIdsLong = 0L;
        }
        for (String actionId : actionIds) {
            if (actionId == null) break;
            if (unsupportedActionIds.contains(actionId)) {
                throw new PrincipalException(actionId + "is not supported by role " + roleId);
            }
            ResourceAction resourceAction = this._resourceActionLocalService.getResourceAction(name, actionId);
            if (operator == 1 || operator == 3) {
                actionIdsLong |= resourceAction.getBitwiseValue();
                continue;
            }
            actionIdsLong &= resourceAction.getBitwiseValue() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (actionIdsLong != resourcePermission.getActionIds() || resourcePermission.isNew()) {
            resourcePermission.setActionIds(actionIdsLong);
            resourcePermission.setViewActionId(actionIdsLong % 2L == 1L);
            this.resourcePermissionPersistence.update((BaseModel)resourcePermission);
            if (ArrayUtil.contains((Object[])actionIds, (Object)"MANAGE_SUBGROUPS")) {
                PermissionCacheUtil.clearPrimaryKeyRoleCache();
            }
            IndexWriterHelperUtil.updatePermissionFields((String)name, (String)primKey);
            return true;
        }
        return false;
    }

    public static interface IndividualPortletResourcePermissionProvider {
        public List<ResourcePermission> getResourcePermissions(long var1, String var3);

        public void removeResourcePermissions(long var1, String var3);
    }
}

