/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.tools.ToolDependencies;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;

public class TCKtoJUnitConverter {
    private static final Log _log = LogFactoryUtil.getLog(TCKtoJUnitConverter.class);

    public static void main(String[] args) {
        ToolDependencies.wireBasic();
        if (args.length != 2) {
            throw new IllegalArgumentException();
        }
        new TCKtoJUnitConverter(args[0], args[1]);
    }

    public TCKtoJUnitConverter(String inputFile, String outputDir) {
        try {
            this._convert(new File(inputFile), new File(outputDir));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    private void _convert(File inputFile, File outputDir) throws Exception {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(inputFile));){
            String s = "";
            while ((s = unsyncBufferedReader.readLine()) != null) {
                if (!s.startsWith("Test finished: ")) continue;
                int x = s.indexOf("#");
                int y = s.lastIndexOf("/", x);
                String className = s.substring(15, y);
                className = StringUtil.replace((String)className, (char)'/', (char)'.');
                if ((y = s.indexOf(":", y)) == -1) {
                    y = s.length();
                }
                className = className + "." + s.substring(x + 1, y);
                String message = s.substring(y + 2);
                this._convert(className, message, outputDir);
            }
        }
    }

    private void _convert(String className, String message, File outputDir) throws Exception {
        boolean passed = false;
        if (message.startsWith("Passed.")) {
            passed = true;
        }
        String hostname = GetterUtil.getString((String)SystemProperties.get((String)"env.USERDOMAIN"));
        hostname = StringUtil.toLowerCase((String)hostname);
        StringBundler sb = new StringBundler();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        sb.append("<testsuite errors=\"");
        if (passed) {
            sb.append("0");
        } else {
            sb.append("1");
        }
        sb.append("\" failures=\"");
        if (passed) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        sb.append("\" hostname=\"");
        sb.append(hostname);
        sb.append("\" name=\"");
        sb.append(className);
        sb.append("\" tests=\"1\" time=\"0.0\" timestamp=\"");
        sb.append(System.currentTimeMillis());
        sb.append("\">\n");
        sb.append("\t<properties>\n");
        Properties properties = System.getProperties();
        ArrayList<String> propertyNames = new ArrayList<String>(properties.stringPropertyNames());
        propertyNames.sort(null);
        for (String propertyName : propertyNames) {
            sb.append("\t\t<property name=\"");
            sb.append(HtmlUtil.escape((String)propertyName));
            sb.append("\" value=\"");
            sb.append(HtmlUtil.escape((String)properties.getProperty(propertyName)));
            sb.append("\" />\n");
        }
        sb.append("\t</properties>\n");
        sb.append("\t<testcase classname=\"");
        sb.append(className);
        sb.append("\" name=\"test\" time=\"0.0\"");
        if (passed) {
            sb.append(" />\n");
        } else {
            String failureMessage = HtmlUtil.escape((String)message.substring(8));
            sb.append(">\n");
            sb.append("\t\t<failure message=\"");
            sb.append(failureMessage);
            sb.append("\" type=\"junit.framework.AssertionFailedError\">\n");
            sb.append(failureMessage);
            sb.append("\n\t\t</failure>\n");
            sb.append("\t</testcase>\n");
        }
        sb.append("\t<system-out><![CDATA[]]></system-out>\n");
        sb.append("\t<system-err><![CDATA[]]></system-err>\n");
        sb.append("</testsuite>");
        FileUtil.write((String)StringBundler.concat((Object[])new Object[]{outputDir, "/TEST-", className, ".xml"}), (String)sb.toString());
    }
}

