/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.WebDAVProps;
import com.liferay.portal.kernel.service.WebDAVPropsLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.webdav.methods.Method;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BasePropMethodImpl
implements Method {
    public static final QName ALLPROP = BasePropMethodImpl.createQName("allprop");
    public static final QName CREATIONDATE = BasePropMethodImpl.createQName("creationdate");
    public static final QName DISPLAYNAME = BasePropMethodImpl.createQName("displayname");
    public static final QName GETCONTENTLENGTH = BasePropMethodImpl.createQName("getcontentlength");
    public static final QName GETCONTENTTYPE = BasePropMethodImpl.createQName("getcontenttype");
    public static final QName GETLASTMODIFIED = BasePropMethodImpl.createQName("getlastmodified");
    public static final QName ISREADONLY = BasePropMethodImpl.createQName("isreadonly");
    public static final QName LOCKDISCOVERY = BasePropMethodImpl.createQName("lockdiscovery");
    public static final QName RESOURCETYPE = BasePropMethodImpl.createQName("resourcetype");
    private static final Log _log = LogFactoryUtil.getLog(BasePropMethodImpl.class);
    private static final List<QName> _allCollectionProps = Arrays.asList(CREATIONDATE, DISPLAYNAME, GETLASTMODIFIED, GETCONTENTTYPE, LOCKDISCOVERY, RESOURCETYPE);
    private static final List<QName> _allSimpleProps = Arrays.asList(CREATIONDATE, DISPLAYNAME, GETLASTMODIFIED, GETCONTENTTYPE, GETCONTENTLENGTH, ISREADONLY, LOCKDISCOVERY, RESOURCETYPE);

    protected static QName createQName(String name) {
        return SAXReaderUtil.createQName((String)name, (Namespace)WebDAVUtil.DAV_URI);
    }

    protected void addResponse(WebDAVRequest webDAVRequest, Resource resource, Set<QName> props, Element multistatus) throws Exception {
        props = new HashSet<QName>(props);
        Element responseElement = multistatus.addElement(BasePropMethodImpl.createQName("response"));
        Element hrefElement = responseElement.addElement(BasePropMethodImpl.createQName("href"));
        hrefElement.addText(GetterUtil.getString((String)resource.getHREF()));
        Element successStatElement = responseElement.addElement(BasePropMethodImpl.createQName("propstat"));
        Element successPropElement = successStatElement.addElement(BasePropMethodImpl.createQName("prop"));
        Element failureStatElement = responseElement.addElement(BasePropMethodImpl.createQName("propstat"));
        Element failurePropElement = failureStatElement.addElement(BasePropMethodImpl.createQName("prop"));
        boolean hasSuccess = false;
        boolean hasFailure = false;
        if (props.contains(ALLPROP)) {
            props.remove(ALLPROP);
            if (resource.isCollection()) {
                props.addAll(_allCollectionProps);
            } else {
                props.addAll(_allSimpleProps);
            }
        }
        if (props.contains(CREATIONDATE)) {
            props.remove(CREATIONDATE);
            Element successCreationDateElement = successPropElement.addElement(CREATIONDATE);
            successCreationDateElement.addText(GetterUtil.getString((String)resource.getCreateDateString()));
            hasSuccess = true;
        }
        if (props.contains(DISPLAYNAME)) {
            props.remove(DISPLAYNAME);
            Element successDisplayNameElement = successPropElement.addElement(DISPLAYNAME);
            successDisplayNameElement.addText(GetterUtil.getString((String)resource.getDisplayName()));
            hasSuccess = true;
        }
        if (props.contains(GETLASTMODIFIED)) {
            props.remove(GETLASTMODIFIED);
            Element successGetLastModifiedElement = successPropElement.addElement(GETLASTMODIFIED);
            successGetLastModifiedElement.addText(GetterUtil.getString((String)resource.getModifiedDate()));
            hasSuccess = true;
        }
        if (props.contains(GETCONTENTTYPE)) {
            props.remove(GETCONTENTTYPE);
            Element successGetContentTypeElement = successPropElement.addElement(GETCONTENTTYPE);
            successGetContentTypeElement.addText(GetterUtil.getString((String)resource.getContentType()));
            hasSuccess = true;
        }
        if (props.contains(GETCONTENTLENGTH)) {
            props.remove(GETCONTENTLENGTH);
            if (!resource.isCollection()) {
                Element successGetContentLengthElement = successPropElement.addElement(GETCONTENTLENGTH);
                successGetContentLengthElement.addText(String.valueOf(resource.getSize()));
                hasSuccess = true;
            } else {
                failurePropElement.addElement(GETCONTENTLENGTH);
                hasFailure = true;
            }
        }
        if (props.contains(ISREADONLY)) {
            props.remove(ISREADONLY);
            Element successIsReadOnlyElement = successPropElement.addElement(ISREADONLY);
            Lock lock = resource.getLock();
            if (lock == null || resource.isLocked()) {
                successIsReadOnlyElement.addText(Boolean.FALSE.toString());
            } else {
                successIsReadOnlyElement.addText(Boolean.TRUE.toString());
            }
            hasSuccess = true;
        }
        if (props.contains(LOCKDISCOVERY)) {
            props.remove(LOCKDISCOVERY);
            Lock lock = resource.getLock();
            if (lock != null) {
                Element lockDiscoveryElement = successPropElement.addElement(LOCKDISCOVERY);
                Element activeLockElement = lockDiscoveryElement.addElement(BasePropMethodImpl.createQName("activelock"));
                Element lockTypeElement = activeLockElement.addElement(BasePropMethodImpl.createQName("locktype"));
                lockTypeElement.addElement(BasePropMethodImpl.createQName("write"));
                Element lockScopeElement = activeLockElement.addElement(BasePropMethodImpl.createQName("lockscope"));
                lockScopeElement.addElement(BasePropMethodImpl.createQName("exclusive"));
                if (resource.isCollection()) {
                    Element depthElement = activeLockElement.addElement(BasePropMethodImpl.createQName("depth"));
                    depthElement.addText("Infinity");
                }
                Element ownerElement = activeLockElement.addElement(BasePropMethodImpl.createQName("owner"));
                ownerElement.addText(GetterUtil.getString((String)lock.getOwner()));
                long timeRemaining = 0L;
                Date expirationDate = lock.getExpirationDate();
                if (expirationDate != null) {
                    long now = System.currentTimeMillis();
                    timeRemaining = (expirationDate.getTime() - now) / 1000L;
                    if (timeRemaining <= 0L) {
                        timeRemaining = 1L;
                    }
                }
                Element timeoutElement = activeLockElement.addElement(BasePropMethodImpl.createQName("timeout"));
                if (timeRemaining > 0L) {
                    timeoutElement.addText("Second-" + timeRemaining);
                } else {
                    timeoutElement.addText("Infinite");
                }
                if (webDAVRequest.getUserId() == lock.getUserId()) {
                    Element lockTokenElement = activeLockElement.addElement(BasePropMethodImpl.createQName("locktoken"));
                    hrefElement = lockTokenElement.addElement(BasePropMethodImpl.createQName("href"));
                    hrefElement.addText(GetterUtil.getString((String)("opaquelocktoken:" + lock.getUuid())));
                }
                hasSuccess = true;
            } else {
                failurePropElement.addElement(LOCKDISCOVERY);
                hasFailure = true;
            }
        }
        if (props.contains(RESOURCETYPE)) {
            props.remove(RESOURCETYPE);
            Element resourceTypeElement = successPropElement.addElement(RESOURCETYPE);
            if (resource.isCollection()) {
                resourceTypeElement.addElement(BasePropMethodImpl.createQName("collection"));
            }
            hasSuccess = true;
        }
        WebDAVProps webDAVProps = WebDAVPropsLocalServiceUtil.getWebDAVProps((long)webDAVRequest.getCompanyId(), (String)resource.getClassName(), (long)resource.getPrimaryKey());
        Set customProps = webDAVProps.getPropsSet();
        for (QName qName : props) {
            if (customProps.contains(qName)) {
                Element qNameElement = successPropElement.addElement(qName);
                Namespace namespace = qName.getNamespace();
                qNameElement.addText(GetterUtil.getString((String)webDAVProps.getText(qName.getName(), namespace.getPrefix(), namespace.getURI())));
                hasSuccess = true;
                continue;
            }
            failurePropElement.addElement(qName);
            hasFailure = true;
        }
        if (hasSuccess) {
            Element successStatusElement = successStatElement.addElement(BasePropMethodImpl.createQName("status"));
            successStatusElement.addText("HTTP/1.1 200 OK");
        } else {
            responseElement.remove(successStatElement);
        }
        if (!hasSuccess && hasFailure) {
            Element failureStatusElement = failureStatElement.addElement(BasePropMethodImpl.createQName("status"));
            failureStatusElement.addText("HTTP/1.1 404 Not Found");
        } else {
            responseElement.remove(failureStatElement);
        }
    }

    protected void addResponse(WebDAVStorage storage, WebDAVRequest webDAVRequest, Resource resource, Set<QName> props, Element multistatusElement, long depth) throws Exception {
        this.addResponse(webDAVRequest, resource, props, multistatusElement);
        if (resource.isCollection() && depth != 0L) {
            List storageResources = storage.getResources(webDAVRequest);
            for (Resource storageResource : storageResources) {
                this.addResponse(webDAVRequest, storageResource, props, multistatusElement);
            }
        }
    }

    protected int writeResponseXML(WebDAVRequest webDAVRequest, Set<QName> props) throws Exception {
        WebDAVStorage storage = webDAVRequest.getWebDAVStorage();
        Document document = SAXReaderUtil.createDocument();
        Element multistatusElement = SAXReaderUtil.createElement((QName)BasePropMethodImpl.createQName("multistatus"));
        document.setRootElement(multistatusElement);
        Resource resource = storage.getResource(webDAVRequest);
        if (resource != null) {
            int status;
            block5: {
                long depth = WebDAVUtil.getDepth((HttpServletRequest)webDAVRequest.getHttpServletRequest());
                this.addResponse(storage, webDAVRequest, resource, props, multistatusElement, depth);
                String xml = document.formattedString("    ");
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Response XML\n" + xml));
                }
                status = 207;
                HttpServletResponse httpServletResponse = webDAVRequest.getHttpServletResponse();
                httpServletResponse.setContentType("text/xml; charset=UTF-8");
                httpServletResponse.setStatus(status);
                try {
                    ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)xml);
                    httpServletResponse.flushBuffer();
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Throwable)exception);
                }
            }
            return status;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("No resource found for " + storage.getRootPath() + webDAVRequest.getPath()));
        }
        return 404;
    }
}

