/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.methods.Method;
import com.liferay.portal.util.PropsUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class MethodFactoryUtil {
    public static Method create(HttpServletRequest httpServletRequest) throws WebDAVException {
        String method = httpServletRequest.getMethod();
        Map methods = MethodHolder._methods;
        Method methodImpl = (Method)methods.get(StringUtil.toUpperCase((String)method));
        if (methodImpl == null) {
            throw new WebDAVException("Method " + method + " is not implemented");
        }
        return methodImpl;
    }

    private static class MethodHolder {
        private static final Map<String, Object> _methods = new HashMap<String, Object>(){
            {
                try {
                    for (String methodName : Method.SUPPORTED_METHOD_NAMES) {
                        String defaultClassName = methodName.substring(1);
                        defaultClassName = StringUtil.toLowerCase((String)defaultClassName);
                        defaultClassName = methodName.substring(0, 1) + defaultClassName;
                        defaultClassName = "com.liferay.portal.webdav.methods." + defaultClassName + "MethodImpl";
                        String className = GetterUtil.getString((String)PropsUtil.get(MethodFactoryUtil.class.getName() + "." + methodName), (String)defaultClassName);
                        this.put(methodName, InstanceFactory.newInstance((ClassLoader)MethodFactoryUtil.class.getClassLoader(), (String)className));
                    }
                }
                catch (Exception exception) {
                    throw new ExceptionInInitializerError(exception);
                }
            }
        };

        private MethodHolder() {
        }
    }
}

