/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.exception.FileShortcutPermissionException;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionRegistryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portlet.documentlibrary.service.base.DLFileShortcutServiceBaseImpl;

public class DLFileShortcutServiceImpl
extends DLFileShortcutServiceBaseImpl {
    public DLFileShortcut addFileShortcut(long groupId, long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermissionUtil.check((ModelResourcePermission)ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName()), (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"ADD_SHORTCUT");
        try {
            ModelResourcePermission fileEntryModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileEntry.class.getName());
            fileEntryModelResourcePermission.check(this.getPermissionChecker(), toFileEntryId, "VIEW");
        }
        catch (PrincipalException principalException) {
            throw new FileShortcutPermissionException((Throwable)principalException);
        }
        return this.dlFileShortcutLocalService.addFileShortcut(this.getUserId(), groupId, repositoryId, folderId, toFileEntryId, serviceContext);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        ModelResourcePermission fileShortcutModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileShortcut.class.getName());
        fileShortcutModelResourcePermission.check(this.getPermissionChecker(), fileShortcutId, "DELETE");
        this.dlFileShortcutLocalService.deleteFileShortcut(fileShortcutId);
    }

    public DLFileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        ModelResourcePermission fileShortcutModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileShortcut.class.getName());
        fileShortcutModelResourcePermission.check(this.getPermissionChecker(), fileShortcutId, "VIEW");
        return this.dlFileShortcutLocalService.getFileShortcut(fileShortcutId);
    }

    public DLFileShortcut updateFileShortcut(long fileShortcutId, long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermission fileShortcutModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileShortcut.class.getName());
        fileShortcutModelResourcePermission.check(this.getPermissionChecker(), fileShortcutId, "UPDATE");
        try {
            ModelResourcePermission fileEntryModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileEntry.class.getName());
            fileEntryModelResourcePermission.check(this.getPermissionChecker(), toFileEntryId, "VIEW");
        }
        catch (PrincipalException principalException) {
            throw new FileShortcutPermissionException((Throwable)principalException);
        }
        return this.dlFileShortcutLocalService.updateFileShortcut(this.getUserId(), fileShortcutId, repositoryId, folderId, toFileEntryId, serviceContext);
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        try {
            ModelResourcePermission fileEntryModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileEntry.class.getName());
            fileEntryModelResourcePermission.check(this.getPermissionChecker(), oldToFileEntryId, "VIEW");
            fileEntryModelResourcePermission.check(this.getPermissionChecker(), newToFileEntryId, "VIEW");
        }
        catch (PrincipalException principalException) {
            throw new FileShortcutPermissionException((Throwable)principalException);
        }
        this.dlFileShortcutLocalService.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }
}

