/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.DefaultFileSystem;
import org.apache.commons.configuration.FileSystem;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertiesConfigurationLayout;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.configuration.SystemConfiguration;

public class ClassLoaderAggregateProperties
extends CompositeConfiguration {
    private static final Log _log = LogFactoryUtil.getLog(ClassLoaderAggregateProperties.class);
    private static final Field _commentField;
    private static final FileSystem _fileSystem;
    private static final Field _layoutDataField;
    private final CompositeConfiguration _baseCompositeConfiguration = new CompositeConfiguration();
    private final ClassLoader _classLoader;
    private final String _companyId;
    private final String _componentName;
    private final CompositeConfiguration _globalCompositeConfiguration = new CompositeConfiguration();
    private final List<String> _loadedSources = new ArrayList<String>();
    private final Configuration _prefixedSystemConfiguration;
    private final SystemConfiguration _systemConfiguration = new SystemConfiguration();

    public ClassLoaderAggregateProperties(ClassLoader classLoader, String companyId, String componentName) {
        this._classLoader = classLoader;
        this._companyId = companyId;
        this._componentName = componentName;
        this._prefixedSystemConfiguration = new SubsetConfiguration((Configuration)this._systemConfiguration, this._getPrefix(), null);
        this.setThrowExceptionOnMissing(false);
        this._addBaseFileName(componentName.concat(".properties"));
    }

    public CompositeConfiguration getBaseConfiguration() {
        return this._baseCompositeConfiguration;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        Iterator keyIterator = this.getKeys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            properties.setProperty(key, StringUtil.merge((Collection)this.getList(key)));
        }
        return properties;
    }

    public Object getProperty(String key) {
        Object value = null;
        if (value == null) {
            value = System.getProperty(this._getPrefix().concat(key));
        }
        if (value == null) {
            value = this._globalCompositeConfiguration.getProperty(this._getPrefix().concat(key));
        }
        if (value == null) {
            value = this._globalCompositeConfiguration.getProperty(key);
        }
        if (value == null) {
            value = this._baseCompositeConfiguration.getProperty(key);
        }
        if (value == null) {
            value = super.getProperty(key);
        }
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    public String getString(String key) {
        Object value = this.getProperty(key);
        if (value instanceof List) {
            return StringUtil.merge((Collection)((List)value));
        }
        return super.getString(key);
    }

    public String getString(String key, Filter filter) {
        Iterator iterator = filter.filterKeyIterator(key);
        while (iterator.hasNext()) {
            String value = super.getString((String)iterator.next(), null);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public String[] getStringArray(String key, Filter filter) {
        Iterator iterator = filter.filterKeyIterator(key);
        while (iterator.hasNext()) {
            List value = this.getList((String)iterator.next(), null);
            if (value == null) continue;
            return value.toArray(new String[0]);
        }
        return StringPool.EMPTY_ARRAY;
    }

    public List<String> loadedSources() {
        return this._loadedSources;
    }

    private void _addBaseFileName(String fileName) {
        ArrayList<String> includeAndOverrides;
        URL url = this._classLoader.getResource(fileName);
        Configuration configuration = this._addPropertiesSource(fileName, url, this._baseCompositeConfiguration, includeAndOverrides = new ArrayList<String>());
        if (configuration == null) {
            throw new SystemException("The base properties file was not found for " + this._componentName);
        }
        if (configuration.isEmpty() && _log.isDebugEnabled()) {
            _log.debug((Object)("Empty configuration " + fileName));
        }
        this.setProperty("include-and-override", includeAndOverrides);
    }

    private Configuration _addFileProperties(String fileName, CompositeConfiguration loadedCompositeConfiguration, List<String> includeAndOverrides) {
        URL url = ConfigurationUtils.locate((FileSystem)_fileSystem, null, (String)fileName);
        if (url == null) {
            return null;
        }
        try {
            PropertiesConfiguration newFileConfiguration = new PropertiesConfiguration(url){

                public String getEncoding() {
                    return "UTF-8";
                }
            };
            this._addIncludedPropertiesSources((Configuration)newFileConfiguration, loadedCompositeConfiguration, includeAndOverrides);
            return newFileConfiguration;
        }
        catch (ConfigurationException configurationException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Configuration source " + fileName + " ignored"), (Throwable)configurationException);
            }
            return null;
        }
    }

    private void _addIncludedPropertiesSources(Configuration newConfiguration, CompositeConfiguration loadedCompositeConfiguration, List<String> includeAndOverrides) {
        CompositeConfiguration tempCompositeConfiguration = new CompositeConfiguration();
        tempCompositeConfiguration.addConfiguration(this._prefixedSystemConfiguration);
        tempCompositeConfiguration.addConfiguration(newConfiguration);
        tempCompositeConfiguration.addConfiguration((Configuration)this._systemConfiguration);
        Object[] fileNames = tempCompositeConfiguration.getStringArray("include-and-override");
        Collections.addAll(includeAndOverrides, fileNames);
        ArrayUtil.reverse((Object[])fileNames);
        for (Object fileName : fileNames) {
            URL url = null;
            try {
                url = this._classLoader.getResource((String)fileName);
            }
            catch (RuntimeException runtimeException) {
                if (((String)fileName).startsWith("file:/")) {
                    throw runtimeException;
                }
                fileName = "file:/".concat((String)fileName);
                url = this._classLoader.getResource((String)fileName);
            }
            this._addPropertiesSource((String)fileName, url, loadedCompositeConfiguration, includeAndOverrides);
        }
    }

    private Configuration _addPropertiesSource(String sourceName, URL url, CompositeConfiguration loadedCompositeConfiguration, List<String> includeAndOverrides) {
        try {
            Configuration newConfiguration = null;
            newConfiguration = url != null ? this._addURLProperties(sourceName, url, loadedCompositeConfiguration, includeAndOverrides) : this._addFileProperties(sourceName, loadedCompositeConfiguration, includeAndOverrides);
            if (newConfiguration == null) {
                return newConfiguration;
            }
            loadedCompositeConfiguration.addConfiguration(newConfiguration);
            super.addConfiguration(newConfiguration);
            if (newConfiguration instanceof AbstractFileConfiguration) {
                AbstractFileConfiguration abstractFileConfiguration = (AbstractFileConfiguration)newConfiguration;
                URL abstractFileConfigurationURL = abstractFileConfiguration.getURL();
                this._loadedSources.add(abstractFileConfigurationURL.toString());
            } else {
                this._loadedSources.add(sourceName);
            }
            return newConfiguration;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Configuration source ", sourceName, " ignored: ", exception.getMessage()}));
            }
            return null;
        }
    }

    private Configuration _addURLProperties(String sourceFileName, URL url, CompositeConfiguration loadedCompositeConfiguration, List<String> includeAndOverrides) {
        try {
            String value;
            PropertiesConfiguration propertiesConfiguration;
            block8: {
                propertiesConfiguration = new PropertiesConfiguration(url){

                    public String getEncoding() {
                        return "UTF-8";
                    }
                };
                PropertiesConfigurationLayout propertiesConfigurationLayout = propertiesConfiguration.getLayout();
                try {
                    Map layoutData = (Map)_layoutDataField.get(propertiesConfigurationLayout);
                    for (Object propertyLayoutData : layoutData.values()) {
                        _commentField.set(propertyLayoutData, null);
                    }
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)("Unable to clear out comments from " + propertiesConfiguration), (Throwable)reflectiveOperationException);
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding resource " + url));
            }
            if (sourceFileName.equals("portal.properties") && (value = System.getenv("LIFERAY_INCLUDE_MINUS_AND_MINUS_OVERRIDE")) != null) {
                Collections.addAll((List)propertiesConfiguration.getProperty("include-and-override"), StringUtil.split((String)value));
            }
            this._addIncludedPropertiesSources((Configuration)propertiesConfiguration, loadedCompositeConfiguration, includeAndOverrides);
            return propertiesConfiguration;
        }
        catch (ConfigurationException configurationException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Configuration source " + url + " ignored"), (Throwable)configurationException);
            }
            return null;
        }
    }

    private String _getPrefix() {
        return this._componentName.concat(":");
    }

    static {
        _fileSystem = new DefaultFileSystem(){

            public URL locateFromURL(String basePath, String fileName) {
                if (fileName.indexOf(59) != -1) {
                    try {
                        return new URL(fileName);
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Throwable)malformedURLException);
                        }
                        return null;
                    }
                }
                return null;
            }
        };
        try {
            ClassLoader classLoader = PropertiesConfigurationLayout.class.getClassLoader();
            Class<?> propertyLayoutDataClass = classLoader.loadClass(PropertiesConfigurationLayout.class.getName() + "$PropertyLayoutData");
            _commentField = ReflectionUtil.getDeclaredField(propertyLayoutDataClass, (String)"comment");
            _layoutDataField = ReflectionUtil.getDeclaredField(PropertiesConfigurationLayout.class, (String)"layoutData");
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

