/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.db.partition.util.DBPartitionUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.dao.db.IndexMetadataFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;

public abstract class BaseDB
implements DB {
    protected static final String ALTER_COLUMN_NAME = "alter_column_name ";
    protected static final String ALTER_COLUMN_TYPE = "alter_column_type ";
    protected static final String ALTER_TABLE_NAME = "alter_table_name ";
    protected static final String CREATE_TABLE = "create table ";
    protected static final String DROP_INDEX = "drop index";
    protected static final String DROP_PRIMARY_KEY = "drop primary key";
    protected static final String[] RENAME_TABLE_TEMPLATE = new String[]{"@old-table@", "@new-table@"};
    protected static final String[] REWORD_TEMPLATE = new String[]{"@table@", "@old-column@", "@new-column@", "@type@", "@default@", "@nullable@"};
    protected static final int[] SQL_VARCHAR_TYPES = new int[]{-16, -1, -9, 12};
    protected static final String[] TEMPLATE = new String[]{"##", "TRUE", "FALSE", "'01/01/1970'", "CURRENT_TIMESTAMP", " BLOB", " SBLOB", " BIGDECIMAL", " BOOLEAN", " DATE", " DOUBLE", " INTEGER", " LONG", " STRING", " TEXT", " VARCHAR", " IDENTITY", "COMMIT_TRANSACTION"};
    protected static final Pattern columnTypePattern = Pattern.compile("(^\\w+)", 2);
    private static final Log _log = LogFactoryUtil.getLog(BaseDB.class);
    private static final Pattern _alterColumnNamePattern;
    private static final Pattern _alterColumnTypePattern;
    private static final Pattern _columnLengthPattern;
    private static final Pattern _defaultValuePattern;
    private static final Pattern _sqlTypeDecimalDigitsPattern;
    private static final Pattern _sqlTypeSizePattern;
    private static final Pattern _templatePattern;
    private final DBType _dbType;
    private final int _majorVersion;
    private final int _minorVersion;
    private final Map<String, Integer> _sqlTypeDecimalDigits = new HashMap<String, Integer>();
    private final Map<String, Integer> _sqlTypes = new HashMap<String, Integer>();
    private final Map<String, Integer> _sqlTypeSizes = new HashMap<String, Integer>();
    private boolean _supportsStringCaseSensitiveQuery = true;
    private final Map<String, String> _templates = new HashMap<String, String>();

    public void addIndexes(Connection connection, List<IndexMetadata> indexMetadatas) throws IOException, SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        DBInspector dbInspector = new DBInspector(connection);
        HashMap columnTableSizes = new HashMap();
        for (IndexMetadata indexMetadata : indexMetadatas) {
            String normalizedTabledName = dbInspector.normalizeName(indexMetadata.getTableName(), databaseMetaData);
            if (columnTableSizes.get(normalizedTabledName) == null) {
                try (ResultSet resultSet = databaseMetaData.getColumns(dbInspector.getCatalog(), dbInspector.getSchema(), normalizedTabledName, null);){
                    HashMap<String, Integer> columnSizes = new HashMap<String, Integer>();
                    while (resultSet.next()) {
                        int columnType = resultSet.getInt("DATA_TYPE");
                        if (!ArrayUtil.contains((int[])SQL_VARCHAR_TYPES, (int)columnType)) continue;
                        columnSizes.put(dbInspector.normalizeName(resultSet.getString("COLUMN_NAME"), databaseMetaData), resultSet.getInt("COLUMN_SIZE"));
                    }
                    columnTableSizes.put(normalizedTabledName, columnSizes);
                }
            }
            String[] columnNames = indexMetadata.getColumnNames();
            int[] columnSizes = new int[columnNames.length];
            for (int i = 0; i < columnNames.length; ++i) {
                columnSizes[i] = MapUtil.getInteger((Map)((Map)columnTableSizes.get(normalizedTabledName)), (String)columnNames[i], (int)0);
            }
            this.runSQL(this._applyMaxStringIndexLengthLimitation(indexMetadata.getCreateSQL(columnSizes)));
        }
    }

    public void alterColumnName(Connection connection, String tableName, String oldColumnName, String newColumnDefinition) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append(ALTER_COLUMN_NAME);
        sb.append(tableName);
        sb.append(" ");
        sb.append(oldColumnName);
        sb.append(" ");
        sb.append(newColumnDefinition);
        this.runSQL(connection, sb.toString());
    }

    public void alterColumnType(Connection connection, String tableName, String columnName, String newColumnType) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append(ALTER_COLUMN_TYPE);
        sb.append(tableName);
        sb.append(" ");
        sb.append(columnName);
        sb.append(" ");
        sb.append(newColumnType);
        this.runSQL(connection, sb.toString());
    }

    public void alterTableAddColumn(Connection connection, String tableName, String columnName, String columnType) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append("alter table ");
        sb.append(tableName);
        sb.append(" add ");
        sb.append(columnName);
        sb.append(" ");
        sb.append(columnType);
        this.runSQL(connection, sb.toString());
    }

    public void alterTableDropColumn(Connection connection, String tableName, String columnName) throws Exception {
        StringBundler sb = new StringBundler(4);
        sb.append("alter table ");
        sb.append(tableName);
        sb.append(" drop column ");
        sb.append(columnName);
        this.runSQL(connection, sb.toString());
    }

    public abstract String buildSQL(String var1) throws IOException, SQLException;

    public void copyTableRows(Connection connection, String sourceTableName, String targetTableName, Map<String, String> columnNamesMap, Map<String, String> defaultValuesMap) throws Exception {
        StringBundler sb = new StringBundler();
        sb.append("insert into ");
        sb.append(targetTableName);
        sb.append(" (");
        Object[] sourceColumnNames = ArrayUtil.toStringArray(columnNamesMap.keySet());
        Object[] targetColumnNames = (String[])TransformUtil.transform((Object[])sourceColumnNames, columnNamesMap::get, String.class);
        sb.append(StringUtil.merge((Object[])targetColumnNames, (String)", "));
        sb.append(") select ");
        for (int i = 0; i < sourceColumnNames.length; ++i) {
            String defaultValue;
            if (i > 0) {
                sb.append(", ");
            }
            if ((defaultValue = defaultValuesMap.get(targetColumnNames[i])) != null) {
                sb.append("COALESCE(");
            }
            sb.append(sourceTableName);
            sb.append(".");
            sb.append((String)sourceColumnNames[i]);
            if (defaultValue == null) continue;
            sb.append(", ");
            sb.append(defaultValue);
            sb.append(")");
        }
        sb.append(" from ");
        sb.append(sourceTableName);
        sb.append(" left join ");
        sb.append(targetTableName);
        sb.append(" on ");
        String[] primaryKeyColumnNames = this.getPrimaryKeyColumnNames(connection, sourceTableName);
        for (int i = 0; i < primaryKeyColumnNames.length; ++i) {
            String primaryKeyColumnName = primaryKeyColumnNames[i];
            sb.append(sourceTableName);
            sb.append(".");
            sb.append(primaryKeyColumnName);
            sb.append(" = ");
            sb.append(targetTableName);
            sb.append(".");
            sb.append(columnNamesMap.get(primaryKeyColumnName));
            if (i >= primaryKeyColumnNames.length - 1) continue;
            sb.append(" and ");
        }
        sb.append(" where ");
        sb.append(targetTableName);
        sb.append(".");
        sb.append(columnNamesMap.get(primaryKeyColumnNames[0]));
        sb.append(" IS NULL");
        this.runSQL(sb.toString());
    }

    public void copyTableStructure(Connection connection, String tableName, String newTableName) throws Exception {
        this.runSQL(connection, this.getCopyTableStructureSQL(tableName, newTableName));
        this.addPrimaryKey(connection, newTableName, this.getPrimaryKeyColumnNames(connection, tableName));
        ArrayList<IndexMetadata> indexMetadatas = new ArrayList<IndexMetadata>();
        String indexNamePrefix = "";
        if (!this.isSupportsDuplicatedIndexName()) {
            indexNamePrefix = "TMP_";
        }
        for (IndexMetadata indexMetadata : this.getIndexes(connection, tableName, null, false)) {
            indexMetadatas.add(new IndexMetadata(indexNamePrefix.concat(indexMetadata.getIndexName()), newTableName, indexMetadata.isUnique(), indexMetadata.getColumnNames()));
        }
        this.addIndexes(connection, indexMetadatas);
    }

    public List<IndexMetadata> dropIndexes(Connection connection, String tableName, String columnName) throws IOException, SQLException {
        List<IndexMetadata> indexMetadatas = this.getIndexes(connection, tableName, columnName, false);
        for (IndexMetadata indexMetadata : indexMetadatas) {
            this.runSQL(connection, indexMetadata.getDropSQL());
        }
        return indexMetadatas;
    }

    public DBType getDBType() {
        return this._dbType;
    }

    public String getDefaultValue(String columnDef) {
        Matcher matcher = _defaultValuePattern.matcher(columnDef);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return StringUtil.trim((String)columnDef);
    }

    public List<Index> getIndexes(Connection connection) throws SQLException {
        return TransformUtil.transform(this.getIndexes(connection, null, null, false), index -> new Index(index.getIndexName(), index.getTableName(), index.isUnique()));
    }

    public ResultSet getIndexResultSet(Connection connection, String tableName, boolean onlyUnique) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        DBInspector dbInspector = new DBInspector(connection);
        return databaseMetaData.getIndexInfo(dbInspector.getCatalog(), dbInspector.getSchema(), tableName, onlyUnique, false);
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public String[] getPrimaryKeyColumnNames(Connection connection, String tableName) throws SQLException {
        List<PrimaryKey> primaryKeys = this._getPrimaryKeys(connection, tableName);
        String[] primaryKeyColumnNames = new String[primaryKeys.size()];
        for (PrimaryKey primaryKey : primaryKeys) {
            primaryKeyColumnNames[((PrimaryKey)primaryKey)._keySeq - 1] = primaryKey._columnName;
        }
        return primaryKeyColumnNames;
    }

    public Integer getSQLType(String templateType) {
        return this._sqlTypes.get(templateType);
    }

    public Integer getSQLTypeDecimalDigits(String templateType) {
        return this._sqlTypeDecimalDigits.get(templateType);
    }

    public Integer getSQLTypeSize(String templateType) {
        return this._sqlTypeSizes.get(templateType);
    }

    public String getTemplateBlob() {
        return this.getTemplate()[5];
    }

    public String getTemplateFalse() {
        return this.getTemplate()[2];
    }

    public String getTemplateTrue() {
        return this.getTemplate()[1];
    }

    public String getVersionString() {
        return this._majorVersion + "." + this._minorVersion;
    }

    public boolean isSupportsAlterColumnName() {
        return true;
    }

    public boolean isSupportsAlterColumnType() {
        return true;
    }

    public boolean isSupportsDBPartition() {
        return false;
    }

    public boolean isSupportsInlineDistinct() {
        return true;
    }

    public boolean isSupportsQueryingAfterException() {
        return true;
    }

    public boolean isSupportsScrollableResults() {
        return true;
    }

    public boolean isSupportsStringCaseSensitiveQuery() {
        return this._supportsStringCaseSensitiveQuery;
    }

    public boolean isSupportsUpdateWithInnerJoin() {
        return true;
    }

    public void process(UnsafeConsumer<Long, Exception> unsafeConsumer) throws Exception {
        DBPartitionUtil.forEachCompanyId(unsafeConsumer);
    }

    public void removePrimaryKey(Connection connection, String tableName) throws Exception {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        DBInspector dbInspector = new DBInspector(connection);
        String normalizedTableName = dbInspector.normalizeName(tableName, databaseMetaData);
        this.runSQL(StringBundler.concat((String[])new String[]{"alter table ", normalizedTableName, " drop primary key"}));
    }

    public void renameTables(Connection connection, ObjectValuePair<String, String> ... tableNameObjectValuePairs) throws Exception {
        if (tableNameObjectValuePairs.length == 0) {
            return;
        }
        for (ObjectValuePair<String, String> tableNameObjectValuePair : tableNameObjectValuePairs) {
            if (tableNameObjectValuePair == null) {
                throw new IllegalArgumentException("Table name object value pair is null");
            }
            if (Objects.isNull(tableNameObjectValuePair.getKey())) {
                throw new IllegalArgumentException("Table name object value pair key is null");
            }
            if (!Objects.isNull(tableNameObjectValuePair.getValue())) continue;
            throw new IllegalArgumentException("Table name object value pair value is null");
        }
        this.doRenameTables(connection, tableNameObjectValuePairs);
    }

    public void runSQL(Connection connection, String sql) throws IOException, SQLException {
        this.runSQL(connection, new String[]{sql});
    }

    public void runSQL(Connection connection, String[] sqls) throws IOException, SQLException {
        try (Statement s = connection.createStatement();){
            for (String sql : sqls) {
                if (Validator.isNull((String)(sql = this.buildSQL(sql)))) continue;
                if ((sql = SQLTransformer.transform(sql.trim())).endsWith(";")) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                if (sql.endsWith("\ngo")) {
                    sql = sql.substring(0, sql.length() - 3);
                }
                if (sql.endsWith("\n/")) {
                    sql = sql.substring(0, sql.length() - 2);
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)sql);
                }
                try {
                    s.executeUpdate(sql);
                }
                catch (SQLException sqlException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)StringBundler.concat((Object[])new Object[]{"SQL: ", sql, "\nSQL state: ", sqlException.getSQLState(), "\nVendor: ", this.getDBType(), "\nVendor error code: ", sqlException.getErrorCode(), "\nVendor error message: ", sqlException.getMessage()}));
                    }
                    throw sqlException;
                }
            }
        }
    }

    public void runSQL(String sql) throws IOException, SQLException {
        this.runSQL(new String[]{sql});
    }

    public void runSQL(String[] sqls) throws IOException, SQLException {
        try (Connection connection = DataAccess.getConnection();){
            this.runSQL(connection, sqls);
        }
    }

    public void runSQLTemplateString(Connection connection, String template, boolean failOnError) throws IOException, NamingException, SQLException {
        if ((template = StringUtil.trim((String)template)) == null || template.isEmpty()) {
            return;
        }
        if (!template.endsWith(";")) {
            template = template + ";";
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(template));){
            StringBundler sb = new StringBundler();
            String line = null;
            Thread currentThread = Thread.currentThread();
            ClassLoader classLoader = currentThread.getContextClassLoader();
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("##")) continue;
                if (line.startsWith("@include ")) {
                    int pos = line.indexOf(" ");
                    int end = line.length();
                    if (StringUtil.endsWith((String)line, (String)";")) {
                        --end;
                    }
                    String includeFileName = line.substring(pos + 1, end);
                    InputStream inputStream = classLoader.getResourceAsStream("com/liferay/portal/tools/sql/dependencies/" + includeFileName);
                    if (inputStream == null) {
                        inputStream = classLoader.getResourceAsStream(includeFileName);
                    }
                    String include = StringUtil.read((InputStream)inputStream);
                    include = this.replaceTemplate(include);
                    this.runSQLTemplateString(include, true);
                    continue;
                }
                sb.append(line);
                sb.append("\n");
                if (!line.endsWith(";")) continue;
                String sql = sb.toString();
                sb.setIndex(0);
                try {
                    if (!sql.equals("COMMIT_TRANSACTION;\n")) {
                        this.runSQL(connection, sql);
                        continue;
                    }
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)"Skip commit sql");
                }
                catch (IOException ioException) {
                    if (failOnError) {
                        throw ioException;
                    }
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Throwable)ioException);
                }
                catch (SecurityException securityException) {
                    if (failOnError) {
                        throw securityException;
                    }
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Throwable)securityException);
                }
                catch (SQLException sqlException) {
                    if (failOnError) {
                        throw sqlException;
                    }
                    String message = GetterUtil.getString((String)sqlException.getMessage());
                    if (!message.startsWith("Duplicate key name") && _log.isWarnEnabled()) {
                        _log.warn((Object)(message + ": " + this.buildSQL(sql)));
                    }
                    if (!message.startsWith("Duplicate entry") && !message.startsWith("Specified key was too long")) continue;
                    _log.error((Object)line);
                }
            }
        }
    }

    public void runSQLTemplateString(String template, boolean failOnError) throws IOException, NamingException, SQLException {
        try (Connection connection = DataAccess.getConnection();){
            this.runSQLTemplateString(connection, template, failOnError);
        }
    }

    public void setSupportsStringCaseSensitiveQuery(boolean supportsStringCaseSensitiveQuery) {
        if (_log.isDebugEnabled()) {
            if (supportsStringCaseSensitiveQuery) {
                _log.debug((Object)"Database supports case sensitive queries");
            } else {
                _log.debug((Object)"Database does not support case sensitive queries");
            }
        }
        this._supportsStringCaseSensitiveQuery = supportsStringCaseSensitiveQuery;
        SQLTransformer.reloadSQLTransformer();
    }

    public AutoCloseable syncTables(Connection connection, String sourceTableName, String targetTableName, Map<String, String> columnNamesMap, Map<String, String> defaultValuesMap) throws Exception {
        DBInspector dbInspector = new DBInspector(connection);
        String deleteTriggerName = dbInspector.normalizeName("delete_" + sourceTableName);
        Object[] sourcePrimaryKeyColumnNames = this.getPrimaryKeyColumnNames(connection, sourceTableName);
        String[] targetPrimaryKeyColumnNames = (String[])TransformUtil.transform((Object[])sourcePrimaryKeyColumnNames, columnNamesMap::get, String.class);
        this.createSyncDeleteTrigger(connection, sourceTableName, targetTableName, deleteTriggerName, (String[])sourcePrimaryKeyColumnNames, targetPrimaryKeyColumnNames);
        String insertTriggerName = dbInspector.normalizeName("insert_" + sourceTableName);
        String[] sourceColumnNames = (String[])TransformUtil.transformToArray(columnNamesMap.entrySet(), Map.Entry::getKey, String.class);
        String[] targetColumnNames = (String[])TransformUtil.transformToArray(columnNamesMap.entrySet(), Map.Entry::getValue, String.class);
        this.createSyncInsertTrigger(connection, sourceTableName, targetTableName, insertTriggerName, sourceColumnNames, targetColumnNames, (String[])sourcePrimaryKeyColumnNames, targetPrimaryKeyColumnNames, defaultValuesMap);
        String updateTriggerName = dbInspector.normalizeName("update_" + sourceTableName);
        this.createSyncUpdateTrigger(connection, sourceTableName, targetTableName, updateTriggerName, sourceColumnNames, targetColumnNames, (String[])sourcePrimaryKeyColumnNames, targetPrimaryKeyColumnNames, defaultValuesMap);
        return () -> {
            this.dropTrigger(connection, sourceTableName, deleteTriggerName);
            this.dropTrigger(connection, sourceTableName, insertTriggerName);
            this.dropTrigger(connection, sourceTableName, updateTriggerName);
        };
    }

    public void updateIndexes(Connection connection, String tableName, String indexesSQL, boolean dropIndexes) throws Exception {
        HashSet<String> validIndexNames;
        List<Index> indexes = this._getIndexes(connection, tableName);
        if (dropIndexes) {
            validIndexNames = this.dropIndexes(connection, indexesSQL, indexes);
        } else {
            validIndexNames = new HashSet();
            for (Index index : indexes) {
                String indexName = StringUtil.toUpperCase((String)index.getIndexName());
                validIndexNames.add(indexName);
            }
        }
        this._addIndexes(connection, this._applyMaxStringIndexLengthLimitation(indexesSQL), validIndexNames);
    }

    protected BaseDB(DBType dbType, int majorVersion, int minorVersion) {
        this._dbType = dbType;
        this._majorVersion = majorVersion;
        this._minorVersion = minorVersion;
        String[] actual = this.getTemplate();
        for (int i = 0; i < TEMPLATE.length; ++i) {
            this._templates.put(TEMPLATE[i], actual[i]);
        }
        String[] templateTypes = (String[])ArrayUtil.clone((Object[])TEMPLATE, (int)5, (int)16);
        for (int i = 0; i < templateTypes.length; ++i) {
            String actualType = StringUtil.trim((String)this._templates.get(templateTypes[i]));
            String templateType = StringUtil.trim((String)templateTypes[i]);
            this._sqlTypes.put(templateType, this.getSQLTypes()[i]);
            Matcher matcher = _sqlTypeDecimalDigitsPattern.matcher(actualType);
            this._sqlTypeDecimalDigits.put(templateType, matcher.matches() ? GetterUtil.getInteger((String)matcher.group(1)) : -1);
            if (templateType.equals("DATE")) {
                this._sqlTypeSizes.put(templateType, -1);
                continue;
            }
            if (templateType.equals("STRING") || templateType.equals("TEXT")) {
                this._sqlTypeSizes.put(templateType, this.getSQLVarcharSizes().get(templateType));
                continue;
            }
            matcher = _sqlTypeSizePattern.matcher(actualType);
            this._sqlTypeSizes.put(templateType, matcher.matches() ? GetterUtil.getInteger((String)matcher.group(1), (int)-1) : -1);
        }
    }

    protected void addPrimaryKey(Connection connection, String tableName, String[] columnNames) throws IOException, SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        DBInspector dbInspector = new DBInspector(connection);
        StringBundler sb = new StringBundler();
        sb.append("alter table ");
        sb.append(dbInspector.normalizeName(tableName, databaseMetaData));
        sb.append(" add primary key (");
        for (String columnName : columnNames) {
            sb.append(columnName);
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        this.runSQL(sb.toString());
    }

    protected String[] buildColumnNameTokens(String line) {
        Matcher matcher = _alterColumnNamePattern.matcher(line);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid alter column name statement");
        }
        String defaultValue = matcher.group(5);
        String nullable = matcher.group(6);
        if (defaultValue != null) {
            nullable = "not null";
        } else {
            defaultValue = "";
            if (nullable == null) {
                nullable = "";
            }
        }
        return new String[]{matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), defaultValue, StringUtil.toLowerCase((String)nullable)};
    }

    protected String[] buildColumnTypeTokens(String line) {
        Matcher matcher = _alterColumnTypePattern.matcher(line);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid alter column type statement");
        }
        String defaultValue = matcher.group(4);
        String nullable = matcher.group(5);
        if (defaultValue != null) {
            nullable = "not null";
        } else if (nullable == null) {
            defaultValue = "";
            if (nullable == null) {
                nullable = "";
            }
        }
        return new String[]{matcher.group(1), matcher.group(2), "", matcher.group(3), defaultValue, StringUtil.toLowerCase((String)nullable)};
    }

    protected String[] buildTableNameTokens(String line) {
        String[] words = StringUtil.split((String)line, (char)' ');
        return new String[]{words[1], words[2]};
    }

    protected void createSyncDeleteTrigger(Connection connection, String sourceTableName, String targetTableName, String triggerName, String[] sourcePrimaryKeyColumnNames, String[] targetPrimaryKeyColumnNames) throws Exception {
        StringBundler sb = new StringBundler();
        sb.append("create trigger ");
        sb.append(triggerName);
        sb.append(" after delete on ");
        sb.append(sourceTableName);
        sb.append(" for each row delete from ");
        sb.append(targetTableName);
        sb.append(" where ");
        for (int i = 0; i < sourcePrimaryKeyColumnNames.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(targetPrimaryKeyColumnNames[i]);
            sb.append(" = old.");
            sb.append(sourcePrimaryKeyColumnNames[i]);
        }
        this.runSQL(connection, sb.toString());
    }

    protected void createSyncInsertTrigger(Connection connection, String sourceTableName, String targetTableName, String triggerName, String[] sourceColumnNames, String[] targetColumnNames, String[] sourcePrimaryKeyColumnNames, String[] targetPrimaryKeyColumnNames, Map<String, String> defaultValuesMap) throws Exception {
        StringBundler sb = new StringBundler();
        sb.append("create trigger ");
        sb.append(triggerName);
        sb.append(" after insert on ");
        sb.append(sourceTableName);
        sb.append(" for each row insert into ");
        sb.append(targetTableName);
        sb.append(" (");
        sb.append(StringUtil.merge((Object[])targetColumnNames, (String)", "));
        sb.append(") values (");
        for (int i = 0; i < sourceColumnNames.length; ++i) {
            String defaultValue;
            if (i > 0) {
                sb.append(", ");
            }
            if ((defaultValue = defaultValuesMap.get(targetColumnNames[i])) != null) {
                sb.append("COALESCE(");
            }
            sb.append("new.");
            sb.append(sourceColumnNames[i]);
            if (defaultValue == null) continue;
            sb.append(", ");
            sb.append(defaultValue);
            sb.append(")");
        }
        sb.append(")");
        this.runSQL(connection, sb.toString());
    }

    protected void createSyncUpdateTrigger(Connection connection, String sourceTableName, String targetTableName, String triggerName, String[] sourceColumnNames, String[] targetColumnNames, String[] sourcePrimaryKeyColumnNames, String[] targetPrimaryKeyColumnNames, Map<String, String> defaultValuesMap) throws Exception {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("create trigger ");
        sb.append(triggerName);
        sb.append(" after update on ");
        sb.append(sourceTableName);
        sb.append(" for each row update ");
        sb.append(targetTableName);
        sb.append(" set ");
        for (i = 0; i < sourceColumnNames.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(targetColumnNames[i]);
            sb.append(" = ");
            String defaultValue = defaultValuesMap.get(targetColumnNames[i]);
            if (defaultValue != null) {
                sb.append("COALESCE(");
            }
            sb.append("new.");
            sb.append(sourceColumnNames[i]);
            if (defaultValue == null) continue;
            sb.append(", ");
            sb.append(defaultValue);
            sb.append(")");
        }
        sb.append(" where ");
        for (i = 0; i < sourcePrimaryKeyColumnNames.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(targetPrimaryKeyColumnNames[i]);
            sb.append(" = old.");
            sb.append(sourcePrimaryKeyColumnNames[i]);
        }
        this.runSQL(connection, sb.toString());
    }

    protected void doRenameTables(Connection connection, ObjectValuePair<String, String> ... tableNameObjectValuePairs) throws Exception {
        int index;
        if (this.isSupportsDDLRollback()) {
            boolean autoCommit = connection.getAutoCommit();
            try {
                connection.setAutoCommit(false);
                for (ObjectValuePair<String, String> tableNameObjectValuePair : tableNameObjectValuePairs) {
                    this.runSQL(connection, this.getRenameTableSQL((String)tableNameObjectValuePair.getKey(), (String)tableNameObjectValuePair.getValue()));
                }
                connection.commit();
            }
            catch (Exception exception) {
                connection.rollback();
                throw exception;
            }
            finally {
                connection.setAutoCommit(autoCommit);
            }
        }
        ObjectValuePair<String, String> tableNameObjectValuePair = null;
        try {
            for (index = 0; index < tableNameObjectValuePairs.length; ++index) {
                tableNameObjectValuePair = tableNameObjectValuePairs[index];
                this.runSQL(connection, this.getRenameTableSQL((String)tableNameObjectValuePair.getKey(), (String)tableNameObjectValuePair.getValue()));
            }
        }
        catch (Exception exception1) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to rename table ", (String)tableNameObjectValuePair.getKey(), " to ", (String)tableNameObjectValuePair.getValue(), ". Attempting to rollback."}));
            try {
                while (index > 0) {
                    tableNameObjectValuePair = tableNameObjectValuePairs[--index];
                    this.runSQL(connection, this.getRenameTableSQL((String)tableNameObjectValuePair.getValue(), (String)tableNameObjectValuePair.getKey()));
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Successfully rolled back table renames");
                }
            }
            catch (Exception exception2) {
                _log.fatal((Object)"Unable to roll back table renames", (Throwable)exception2);
            }
            throw exception1;
        }
    }

    protected Set<String> dropIndexes(Connection connection, String indexesSQL, List<Index> indexes) throws IOException, SQLException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Dropping stale indexes");
        }
        HashSet<String> validIndexNames = new HashSet<String>();
        if (indexes.isEmpty()) {
            return validIndexNames;
        }
        String indexesSQLLowerCase = StringUtil.toLowerCase((String)indexesSQL);
        String[] lines = StringUtil.splitLines((String)indexesSQL);
        HashSet<String> indexNames = new HashSet<String>();
        for (String line : lines) {
            if (Validator.isNull((String)line)) continue;
            IndexMetadata indexMetadata = IndexMetadataFactoryUtil.createIndexMetadata((String)line);
            indexNames.add(StringUtil.toLowerCase((String)indexMetadata.getIndexName()));
        }
        for (Index index : indexes) {
            boolean unique;
            String indexNameUpperCase = StringUtil.toUpperCase((String)index.getIndexName());
            String indexNameLowerCase = StringUtil.toLowerCase((String)indexNameUpperCase);
            validIndexNames.add(indexNameUpperCase);
            if (indexNames.contains(indexNameLowerCase) && ((unique = index.isUnique()) && indexesSQLLowerCase.contains("create unique index " + indexNameLowerCase + " ") || !unique && indexesSQLLowerCase.contains("create index " + indexNameLowerCase + " "))) continue;
            validIndexNames.remove(indexNameUpperCase);
            String sql = StringBundler.concat((String[])new String[]{"drop index ", indexNameUpperCase, " on ", index.getTableName()});
            if (_log.isInfoEnabled()) {
                _log.info((Object)sql);
            }
            this.runSQL(connection, sql);
        }
        return validIndexNames;
    }

    protected void dropTrigger(Connection connection, String tableName, String triggerName) throws Exception {
        this.runSQL(connection, "drop trigger " + triggerName);
    }

    protected String getCopyTableStructureSQL(String tableName, String newTableName) {
        return StringBundler.concat((String[])new String[]{CREATE_TABLE, newTableName, " as select * from ", tableName, " where 1 = 0"});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IndexMetadata> getIndexes(Connection connection, String tableName, String columnName, boolean onlyUnique) throws SQLException {
        String normalizedColumnName;
        ArrayList<IndexMetadata> indexMetadatas = new ArrayList<IndexMetadata>();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        DB db = DBManagerUtil.getDB();
        DBInspector dbInspector = new DBInspector(connection);
        String catalog = dbInspector.getCatalog();
        String schema = dbInspector.getSchema();
        String normalizedTableName = tableName;
        if (normalizedTableName != null) {
            normalizedTableName = dbInspector.normalizeName(tableName, databaseMetaData);
        }
        if ((normalizedColumnName = columnName) != null) {
            normalizedColumnName = dbInspector.normalizeName(columnName, databaseMetaData);
        }
        try (ResultSet tableResultSet = databaseMetaData.getTables(catalog, schema, normalizedTableName, new String[]{"TABLE"});){
            while (tableResultSet.next()) {
                ResultSet indexResultSet;
                block28: {
                    normalizedTableName = dbInspector.normalizeName(tableResultSet.getString("TABLE_NAME"), databaseMetaData);
                    indexResultSet = db.getIndexResultSet(connection, normalizedTableName, onlyUnique);
                    Throwable throwable = null;
                    try {
                        boolean unique = false;
                        Object[] columnNames = new String[]{};
                        String previousIndexName = null;
                        while (indexResultSet.next()) {
                            String lowerCaseIndexName;
                            String indexName = indexResultSet.getString("INDEX_NAME");
                            if (indexName == null || !(lowerCaseIndexName = StringUtil.toLowerCase((String)indexName)).startsWith("liferay_") && !lowerCaseIndexName.startsWith("ix_")) continue;
                            if (previousIndexName != null && !previousIndexName.equals(indexName)) {
                                if (normalizedColumnName == null || ArrayUtil.contains((Object[])columnNames, (Object)normalizedColumnName)) {
                                    indexMetadatas.add(new IndexMetadata(previousIndexName, normalizedTableName, unique, (String[])columnNames));
                                }
                                columnNames = new String[]{};
                            }
                            previousIndexName = indexName;
                            unique = !indexResultSet.getBoolean("NON_UNIQUE");
                            columnNames = (String[])ArrayUtil.append((Object[])columnNames, (Object)dbInspector.normalizeName(indexResultSet.getString("COLUMN_NAME"), databaseMetaData));
                        }
                        if (previousIndexName != null && (normalizedColumnName == null || ArrayUtil.contains((Object[])columnNames, (Object)normalizedColumnName))) {
                            indexMetadatas.add(new IndexMetadata(previousIndexName, normalizedTableName, unique, (String[])columnNames));
                        }
                        if (indexResultSet == null) continue;
                        if (throwable == null) break block28;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (indexResultSet == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    indexResultSet.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            indexResultSet.close();
                            throw throwable3;
                        }
                    }
                    try {
                        indexResultSet.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                indexResultSet.close();
            }
            return new ArrayList<IndexMetadata>(indexMetadatas);
        }
    }

    protected String getRenameTableSQL(String oldTableName, String newTableName) {
        return StringBundler.concat((String[])new String[]{"alter table ", oldTableName, " rename to ", newTableName});
    }

    protected abstract int[] getSQLTypes();

    protected Map<String, Integer> getSQLVarcharSizes() {
        return HashMapBuilder.put((Object)"STRING", (Object)-1).put((Object)"TEXT", (Object)-1).build();
    }

    protected abstract String[] getTemplate();

    protected boolean isSupportsDDLRollback() {
        return true;
    }

    protected boolean isSupportsDuplicatedIndexName() {
        return true;
    }

    protected String limitColumnLength(String column, int length) {
        return StringBundler.concat((Object[])new Object[]{column, "\\(", length, "\\)"});
    }

    protected String replaceTemplate(String template) {
        if (Validator.isNull((String)template)) {
            return null;
        }
        StringBundler sb = null;
        int endIndex = 0;
        Matcher matcher = _templatePattern.matcher(template);
        while (matcher.find()) {
            int startIndex = matcher.start();
            if (sb == null) {
                sb = new StringBundler();
            }
            sb.append(template.substring(endIndex, startIndex));
            endIndex = matcher.end();
            String matched = template.substring(startIndex, endIndex);
            sb.append(this._templates.get(matched));
        }
        if (sb == null) {
            return this._applyMaxStringIndexLengthLimitation(template);
        }
        if (template.length() > endIndex) {
            sb.append(template.substring(endIndex));
        }
        return this._applyMaxStringIndexLengthLimitation(sb.toString());
    }

    protected abstract String reword(String var1) throws IOException, SQLException;

    private void _addIndexes(Connection connection, String indexesSQL, Set<String> validIndexNames) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Adding indexes");
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(indexesSQL));){
            String sql = null;
            while ((sql = unsyncBufferedReader.readLine()) != null) {
                int y;
                int x;
                String indexName;
                if (Validator.isNull((String)sql) || validIndexNames.contains(indexName = sql.substring((x = sql.lastIndexOf(" ", (y = sql.indexOf(" on ")) - 1)) + 1, y))) continue;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)sql);
                }
                try {
                    this.runSQL(connection, sql);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)(exception.getMessage() + ": " + sql));
                }
            }
        }
    }

    private String _applyMaxStringIndexLengthLimitation(String template) {
        if (!template.contains("[$COLUMN_LENGTH:")) {
            return template;
        }
        DBType dbType = this.getDBType();
        int stringIndexMaxLength = GetterUtil.getInteger((String)PropsUtil.get((String)"database.string.index.max.length", (Filter)new Filter(dbType.getName())), (int)-1);
        Matcher matcher = _columnLengthPattern.matcher(template);
        if (stringIndexMaxLength < 0) {
            return matcher.replaceAll("$1");
        }
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int length = Integer.valueOf(matcher.group(2));
            if (length > stringIndexMaxLength) {
                matcher.appendReplacement(sb, this.limitColumnLength(matcher.group(1), stringIndexMaxLength));
                continue;
            }
            matcher.appendReplacement(sb, matcher.group(1));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private List<Index> _getIndexes(Connection connection, String tableName) throws Exception {
        return TransformUtil.transform(this.getIndexes(connection, tableName, null, false), index -> new Index(index.getIndexName(), index.getTableName(), index.isUnique()));
    }

    private List<PrimaryKey> _getPrimaryKeys(Connection connection, String tableName) throws SQLException {
        ArrayList<PrimaryKey> primaryKeys = new ArrayList<PrimaryKey>();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        DBInspector dbInspector = new DBInspector(connection);
        try (ResultSet resultSet = databaseMetaData.getPrimaryKeys(dbInspector.getCatalog(), dbInspector.getSchema(), dbInspector.normalizeName(tableName, databaseMetaData));){
            while (resultSet.next()) {
                primaryKeys.add(new PrimaryKey(dbInspector.normalizeName(resultSet.getString("COLUMN_NAME"), databaseMetaData), resultSet.getInt("KEY_SEQ")));
            }
        }
        return primaryKeys;
    }

    static {
        _columnLengthPattern = Pattern.compile("([^,(\\s]+)\\[\\$COLUMN_LENGTH:(\\d+)\\$\\]");
        _defaultValuePattern = Pattern.compile("^(')?(\\d+|.*)\\1(::.*| )?", 2);
        _sqlTypeDecimalDigitsPattern = Pattern.compile("^\\w+(?:\\(\\d+,\\s(\\d+)\\))", 2);
        _sqlTypeSizePattern = Pattern.compile("^\\w+(?:\\((\\d+).*\\))", 2);
        StringBundler sb = new StringBundler(TEMPLATE.length * 5 - 6);
        for (int i = 0; i < TEMPLATE.length; ++i) {
            String variable = TEMPLATE[i];
            if (variable.equals("##") || variable.equals("'01/01/1970'")) {
                sb.append(variable);
            } else {
                sb.append("(?<!\\[\\$)");
                sb.append(variable);
                sb.append("(?!\\$\\])");
                sb.append("\\b");
            }
            sb.append("|");
        }
        sb.setIndex(sb.index() - 1);
        _templatePattern = Pattern.compile(sb.toString());
        String dataTypeRegex = "(\\w+(?:\\([^\\)]+\\))?)";
        String defaultAndNullableRegex = "(?:(?:DEFAULT\\s+('?.*[^']'?)\\s+NOT\\s+NULL)|((?:NOT\\s+)?NULL))";
        _alterColumnNamePattern = Pattern.compile(StringBundler.concat((String[])new String[]{"^ALTER_COLUMN_NAME\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+", dataTypeRegex, "\\s*", defaultAndNullableRegex, "?;?$"}), 2);
        _alterColumnTypePattern = Pattern.compile(StringBundler.concat((String[])new String[]{"^ALTER_COLUMN_TYPE\\s+(\\S+)\\s+(\\S+)\\s+", dataTypeRegex, "\\s*", defaultAndNullableRegex, "?;?$"}), 2);
    }

    private static class PrimaryKey {
        private final String _columnName;
        private final int _keySeq;

        private PrimaryKey(String columnName, int keySeq) {
            this._columnName = columnName;
            this._keySeq = keySeq;
        }
    }
}

