/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.pool.metrics;

import com.liferay.portal.dao.jdbc.util.DynamicDataSource;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.jdbc.pool.metrics.ConnectionPoolMetrics;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;

public class HikariConnectionPoolMetrics
implements ConnectionPoolMetrics {
    private static final Log _log = LogFactoryUtil.getLog(HikariConnectionPoolMetrics.class);
    private final Object _dataSource;
    private final Method _getHikariPoolMXBeanMethod;
    private final Method _getPoolNameMethod;
    private String _name;

    public HikariConnectionPoolMetrics(Object dataSource) throws ReflectiveOperationException {
        this._dataSource = dataSource;
        Class<?> clazz = dataSource.getClass();
        this._getPoolNameMethod = clazz.getMethod("getPoolName", new Class[0]);
        this._getHikariPoolMXBeanMethod = clazz.getMethod("getHikariPoolMXBean", new Class[0]);
    }

    public String getConnectionPoolName() {
        if (this._name == null) {
            this._name = this._getConnectionPoolName();
        }
        return this._name;
    }

    public int getNumActive() {
        try {
            HikariPoolMXBean hikariPoolMXBean = (HikariPoolMXBean)this._getHikariPoolMXBeanMethod.invoke(this._dataSource, new Object[0]);
            return hikariPoolMXBean.getActiveConnections();
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public int getNumIdle() {
        try {
            HikariPoolMXBean hikariPoolMXBean = (HikariPoolMXBean)this._getHikariPoolMXBeanMethod.invoke(this._dataSource, new Object[0]);
            return hikariPoolMXBean.getIdleConnections();
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    private String _getConnectionPoolName() {
        block8: {
            Advised advised;
            LazyConnectionDataSourceProxy lazyConnectionDataSourceProxy = (LazyConnectionDataSourceProxy)PortalBeanLocatorUtil.locate((String)"liferayDataSource");
            DataSource targetDataSource = lazyConnectionDataSourceProxy.getTargetDataSource();
            if (this._dataSource.equals(targetDataSource)) {
                return "liferayDataSource";
            }
            if (AopUtils.isAopProxy((Object)targetDataSource) && targetDataSource instanceof Advised && (targetDataSource = (advised = (Advised)targetDataSource).getTargetSource()) instanceof DynamicDataSource) {
                try {
                    DynamicDataSource dynamicDataSource = (DynamicDataSource)targetDataSource;
                    if (this._dataSource.equals(dynamicDataSource.getReadDataSource())) {
                        return "readDataSource";
                    }
                    if (this._dataSource.equals(dynamicDataSource.getWriteDataSource())) {
                        return "writeDataSource";
                    }
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block8;
                    _log.debug((Throwable)exception);
                }
            }
        }
        try {
            return (String)this._getPoolNameMethod.invoke(this._dataSource, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

