/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate.event;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import java.io.Serializable;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class MVCCSynchronizerPostUpdateEventListener
implements PostUpdateEventListener {
    public static final MVCCSynchronizerPostUpdateEventListener INSTANCE = new MVCCSynchronizerPostUpdateEventListener();

    public void onPostUpdate(PostUpdateEvent postUpdateEvent) {
        Object entity = postUpdateEvent.getEntity();
        if (entity instanceof MVCCModel) {
            long ctCollectionId = 0L;
            if (entity instanceof CTModel) {
                CTModel ctModel = (CTModel)entity;
                ctCollectionId = ctModel.getCtCollectionId();
            }
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);){
                PortalCache portalCache;
                MVCCModel mvccModel = (MVCCModel)entity;
                long mvccVersion = mvccModel.getMvccVersion();
                Class<?> modelClass = entity.getClass();
                BaseModel baseModel = (BaseModel)entity;
                Serializable primaryKeyObj = baseModel.getPrimaryKeyObj();
                Serializable localCacheResult = EntityCacheUtil.getLocalCacheResult(modelClass, (Serializable)primaryKeyObj);
                if (localCacheResult instanceof MVCCModel) {
                    MVCCModel localCacheMVCCModel = (MVCCModel)localCacheResult;
                    localCacheMVCCModel.setMvccVersion(mvccVersion);
                }
                if ((portalCache = EntityCacheUtil.getPortalCache(modelClass)) == null) {
                    return;
                }
                Serializable entityCacheResult = (Serializable)portalCache.get(primaryKeyObj);
                if (entityCacheResult instanceof MVCCModel) {
                    MVCCModel entityCacheMVCCModel = (MVCCModel)entityCacheResult;
                    entityCacheMVCCModel.setMvccVersion(mvccVersion);
                }
            }
        }
    }

    @Deprecated
    public boolean requiresPostCommitHanding(EntityPersister entityPersister) {
        throw new UnsupportedOperationException();
    }
}

