/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.partition.util;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.jdbc.util.ConnectionWrapper;
import com.liferay.portal.dao.jdbc.util.DataSourceWrapper;
import com.liferay.portal.dao.jdbc.util.StatementWrapper;
import com.liferay.portal.db.partition.db.DBPartitionDB;
import com.liferay.portal.db.partition.db.DBPartitionMySQLDB;
import com.liferay.portal.db.partition.db.DBPartitionPostgreSQLDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ThrowableCollector;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sql.DataSource;

public class DBPartitionUtil {
    private static final String _DATABASE_PARTITION_SCHEMA_NAME_PREFIX = GetterUtil.get((String)PropsUtil.get((String)"database.partition.schema.name.prefix"), (String)"lpartition_");
    private static final boolean _DATABASE_PARTITION_THREAD_POOL_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"database.partition.thread.pool.enabled"), (boolean)true);
    private static final String _QUARTZ_TABLE_NAME_PREFIX = GetterUtil.get((String)PropsUtil.get((String)"persisted.scheduler.org.quartz.jobStore.tablePrefix"), (String)"QUARTZ_");
    private static final Log _log = LogFactoryUtil.getLog(DBPartitionUtil.class);
    private static final List<Long> _companyIds = new CopyOnWriteArrayList<Long>();
    private static DBPartitionDB _dbPartitionDB;
    private static volatile long _defaultCompanyId;
    private static String _defaultPartitionName;

    public static boolean addDBPartition(long companyId) throws PortalException {
        if (!DBPartition.isPartitionEnabled() || companyId == _defaultCompanyId) {
            return false;
        }
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        try (AutoCloseable autoCloseable = DBPartitionUtil._disableAutoCommit(connection);
             PreparedStatement preparedStatement = connection.prepareStatement(_dbPartitionDB.getCreatePartitionSQL(connection, DBPartitionUtil._getPartitionName(companyId)));){
            preparedStatement.executeUpdate();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            DBInspector dbInspector = new DBInspector(connection);
            try (ResultSet resultSet = databaseMetaData.getTables(dbInspector.getCatalog(), dbInspector.getSchema(), null, new String[]{"TABLE"});
                 Statement statement = connection.createStatement();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (dbInspector.isObjectTable(DBPartitionUtil._getCompanyIds(), tableName)) continue;
                    if (dbInspector.isControlTable(tableName)) {
                        statement.executeUpdate(_dbPartitionDB.getCreateViewSQL(_defaultPartitionName, DBPartitionUtil._getPartitionName(companyId), tableName));
                        continue;
                    }
                    statement.executeUpdate(_dbPartitionDB.getCreateTableSQL(_defaultPartitionName, DBPartitionUtil._getPartitionName(companyId), tableName));
                    if (!dbInspector.isPartitionedControlTable(tableName)) continue;
                    statement.executeUpdate(DBPartitionUtil._getCopyDataSQL(_defaultPartitionName, DBPartitionUtil._getPartitionName(companyId), tableName, DBPartitionUtil._getColumnNames(connection, tableName), ""));
                }
            }
            connection.commit();
        }
        catch (Exception exception) {
            if (!_dbPartitionDB.isDDLTransactional()) {
                try (Statement statement = connection.createStatement();){
                    statement.executeUpdate(_dbPartitionDB.getDropPartitionSQL(DBPartitionUtil._getPartitionName(companyId)));
                }
                catch (SQLException sqlException) {
                    throw new PortalException("Unable to roll back schema creation", (Throwable)sqlException);
                }
            }
            throw new PortalException((Throwable)exception);
        }
        _companyIds.add(companyId);
        return true;
    }

    public static void checkDatabasePartitionSchemaNamePrefix() throws PortalException {
        if (DBPartition.isPartitionEnabled() && _DATABASE_PARTITION_SCHEMA_NAME_PREFIX.length() > 11) {
            throw new PortalException("The value for property \"database.partition.schema.name.prefix\" is greater than 11 characters");
        }
    }

    public static boolean extractDBPartition(long companyId) throws PortalException {
        if (!DBPartition.isPartitionEnabled() || companyId == _defaultCompanyId) {
            return false;
        }
        DBPartitionUtil._extractDBPartition(companyId);
        return true;
    }

    public static void forEachCompanyId(UnsafeConsumer<Long, Exception> unsafeConsumer) throws Exception {
        if (!DBPartition.isPartitionEnabled()) {
            unsafeConsumer.accept(null);
            return;
        }
        if (CompanyThreadLocal.isLocked()) {
            unsafeConsumer.accept((Object)CompanyThreadLocal.getCompanyId());
            return;
        }
        if (_DATABASE_PARTITION_THREAD_POOL_ENABLED) {
            DBPartitionUtil._forEachCompanyIdConcurrently(unsafeConsumer);
            return;
        }
        List<Long> companyIds = DBPartitionUtil._getCompanyIds();
        if (companyIds.isEmpty()) {
            unsafeConsumer.accept(null);
        } else {
            for (long companyId : companyIds) {
                SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)companyId);
                Throwable throwable = null;
                try {
                    unsafeConsumer.accept((Object)companyId);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (safeCloseable == null) continue;
                    if (throwable != null) {
                        try {
                            safeCloseable.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    safeCloseable.close();
                }
            }
        }
    }

    public static long getCurrentCompanyId() {
        long companyId = CompanyThreadLocal.getCompanyId();
        if (!DBPartition.isPartitionEnabled()) {
            return companyId;
        }
        if (companyId == 0L) {
            companyId = _defaultCompanyId;
        }
        return companyId;
    }

    public static boolean insertDBPartition(long companyId) throws PortalException {
        if (!DBPartition.isPartitionEnabled()) {
            return false;
        }
        DBPartitionUtil._insertDBPartition(companyId);
        return true;
    }

    public static boolean removeDBPartition(long companyId) throws PortalException {
        if (!DBPartition.isPartitionEnabled() || companyId == _defaultCompanyId) {
            return false;
        }
        DBPartitionUtil._dropDBPartition(companyId);
        return true;
    }

    public static void replaceByTable(Connection connection, boolean copyData, String viewName) throws Exception {
        long companyId = DBPartitionUtil.getCurrentCompanyId();
        if (companyId == _defaultCompanyId) {
            return;
        }
        try (Statement statement = connection.createStatement();){
            statement.execute(_dbPartitionDB.getDropViewSQL(DBPartitionUtil._getPartitionName(companyId), viewName));
            statement.execute(_dbPartitionDB.getCreateTableSQL(_defaultPartitionName, DBPartitionUtil._getPartitionName(companyId), viewName));
            if (copyData) {
                statement.executeUpdate(DBPartitionUtil._getCopyDataSQL(_defaultPartitionName, DBPartitionUtil._getPartitionName(companyId), viewName, DBPartitionUtil._getColumnNames(connection, viewName), ""));
            }
        }
    }

    public static void setDefaultCompanyId(Connection connection) throws SQLException {
        if (DBPartition.isPartitionEnabled()) {
            try (PreparedStatement preparedStatement = connection.prepareStatement("select companyId from Company where webId = '" + PropsValues.COMPANY_DEFAULT_WEB_ID + "'");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    _defaultCompanyId = resultSet.getLong(1);
                }
            }
        }
    }

    public static void setDefaultCompanyId(long companyId) {
        if (DBPartition.isPartitionEnabled()) {
            _defaultCompanyId = companyId;
        }
    }

    public static DataSource wrapDataSource(DataSource dataSource) throws SQLException {
        if (!DBPartition.isPartitionEnabled()) {
            return dataSource;
        }
        DB db = DBManagerUtil.getDB((DBType)DBManagerUtil.getDBType((Object)DialectDetector.getDialect(dataSource)), (DataSource)dataSource);
        if (!db.isSupportsDBPartition()) {
            throw new Error("Database partitioning is not supported for " + db.getDBType());
        }
        if (db.getDBType() == DBType.MYSQL) {
            _dbPartitionDB = new DBPartitionMySQLDB();
        } else if (db.getDBType() == DBType.POSTGRESQL) {
            _dbPartitionDB = new DBPartitionPostgreSQLDB();
        }
        try (Connection connection = dataSource.getConnection();){
            _defaultPartitionName = _dbPartitionDB.getDefaultPartitionName(connection);
        }
        return new DataSourceWrapper(dataSource){

            @Override
            public Connection getConnection() throws SQLException {
                return DBPartitionUtil._getConnectionWrapper(super.getConnection());
            }

            @Override
            public Connection getConnection(String userName, String password) throws SQLException {
                return DBPartitionUtil._getConnectionWrapper(super.getConnection());
            }
        };
    }

    private static void _deleteCompanyData(long companyId, String tableName, String fromPartitionName, Statement statement) throws Exception {
        DBPartitionUtil._deleteData(tableName, fromPartitionName, statement, " where companyId = " + companyId);
    }

    private static void _deleteData(String tableName, String fromPartitionName, Statement statement, String whereClause) throws Exception {
        statement.executeUpdate(StringBundler.concat((String[])new String[]{"delete from ", fromPartitionName, ".", tableName, whereClause}));
    }

    private static AutoCloseable _disableAutoCommit(Connection connection) throws Exception {
        boolean autoCommit = connection.getAutoCommit();
        connection.setAutoCommit(false);
        return () -> connection.setAutoCommit(autoCommit);
    }

    private static void _dropDBPartition(long companyId) throws PortalException {
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        DBInspector dbInspector = new DBInspector(connection);
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(_dbPartitionDB.getCatalog(connection, _defaultPartitionName), _dbPartitionDB.getSchema(connection, _defaultPartitionName), null, new String[]{"TABLE"});
                 Statement statement = connection.createStatement();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!dbInspector.isControlTable(tableName)) continue;
                    if (dbInspector.hasColumn(tableName, "companyId")) {
                        DBPartitionUtil._deleteCompanyData(companyId, tableName, _defaultPartitionName, statement);
                        continue;
                    }
                    if (!DBPartitionUtil._isCopyableQuartzTable(tableName)) continue;
                    DBPartitionUtil._deleteData(tableName, _defaultPartitionName, statement, DBPartitionUtil._getQuartzWhereClauseSQL(companyId, tableName));
                }
                statement.executeUpdate(_dbPartitionDB.getDropPartitionSQL(DBPartitionUtil._getPartitionName(companyId)));
            }
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
        _companyIds.remove(companyId);
    }

    private static void _extractDBPartition(long companyId) throws PortalException {
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        ArrayList<String> controlTableNames = new ArrayList<String>();
        DBInspector dbInspector = new DBInspector(connection);
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(_dbPartitionDB.getCatalog(connection, _defaultPartitionName), _dbPartitionDB.getSchema(connection, _defaultPartitionName), null, new String[]{"TABLE"});
                 Statement statement = connection.createStatement();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!dbInspector.isControlTable(tableName)) continue;
                    controlTableNames.add(tableName);
                    DBPartitionUtil._extractTable(companyId, tableName, statement, dbInspector);
                }
            }
        }
        catch (Exception exception1) {
            if (ListUtil.isEmpty(controlTableNames) || _dbPartitionDB.isDDLTransactional()) {
                throw new PortalException((Throwable)exception1);
            }
            try (AutoCloseable autoCloseable = DBPartitionUtil._disableAutoCommit(connection);){
                for (String tableName : controlTableNames) {
                    Statement statement = connection.createStatement();
                    Throwable throwable = null;
                    try {
                        DBPartitionUtil._restoreView(companyId, tableName, statement, dbInspector);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                connection.commit();
            }
            catch (Exception exception2) {
                throw new PortalException(StringBundler.concat((String[])new String[]{"Unable to roll back the extraction of database ", "partition. Recover a backup of the database ", "partition ", DBPartitionUtil._getPartitionName(companyId), "."}), (Throwable)exception2);
            }
            throw new PortalException("Removal of database partition extraction was rolled back", (Throwable)exception1);
        }
        _companyIds.remove(companyId);
    }

    private static void _extractTable(long companyId, String tableName, Statement statement, DBInspector dbInspector) throws Exception {
        statement.executeUpdate(_dbPartitionDB.getDropViewSQL(DBPartitionUtil._getPartitionName(companyId), tableName));
        statement.executeUpdate(_dbPartitionDB.getCreateTableSQL(_defaultPartitionName, DBPartitionUtil._getPartitionName(companyId), tableName));
        if (dbInspector.hasColumn(tableName, "companyId")) {
            DBPartitionUtil._moveCompanyData(companyId, _defaultPartitionName, DBPartitionUtil._getPartitionName(companyId), tableName, statement);
        } else if (DBPartitionUtil._isCopyableQuartzTable(tableName)) {
            DBPartitionUtil._moveData(_defaultPartitionName, DBPartitionUtil._getPartitionName(companyId), tableName, DBPartitionUtil._getColumnNames(statement.getConnection(), tableName), statement, DBPartitionUtil._getQuartzWhereClauseSQL(companyId, tableName));
        } else {
            statement.executeUpdate(DBPartitionUtil._getCopyDataSQL(_defaultPartitionName, DBPartitionUtil._getPartitionName(companyId), tableName, DBPartitionUtil._getColumnNames(statement.getConnection(), tableName), ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _forEachCompanyIdConcurrently(UnsafeConsumer<Long, Exception> unsafeConsumer) throws Exception {
        ThrowableCollector throwableCollector;
        block18: {
            ExecutorService executorService = Executors.newWorkStealingPool();
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            throwableCollector = new ThrowableCollector();
            try {
                List<Long> companyIds = DBPartitionUtil._getCompanyIds();
                if (companyIds.isEmpty()) {
                    unsafeConsumer.accept(null);
                    break block18;
                }
                Iterator<Long> iterator = companyIds.iterator();
                while (iterator.hasNext()) {
                    long companyId = iterator.next();
                    if (companyId == _defaultCompanyId) {
                        SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)companyId);
                        Throwable throwable = null;
                        try {
                            unsafeConsumer.accept((Object)companyId);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (safeCloseable == null) continue;
                            if (throwable != null) {
                                try {
                                    safeCloseable.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            safeCloseable.close();
                            continue;
                        }
                    }
                    Future<Void> future = executorService.submit(() -> {
                        try (SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)companyId);){
                            unsafeConsumer.accept((Object)companyId);
                        }
                        catch (Exception exception) {
                            throwableCollector.collect((Throwable)exception);
                        }
                        return null;
                    });
                    futures.add(future);
                }
            }
            finally {
                executorService.shutdown();
                for (Future future : futures) {
                    future.get();
                }
            }
        }
        Throwable throwable = throwableCollector.getThrowable();
        if (throwable != null) {
            ReflectionUtil.throwException((Throwable)throwable);
        }
    }

    private static List<String> _getColumnNames(Connection connection, String tableName) throws SQLException {
        DBInspector dbInspector = new DBInspector(connection);
        ArrayList<String> columnNames = new ArrayList<String>();
        try (ResultSet resultSet = dbInspector.getColumnsResultSet(tableName);){
            while (resultSet.next()) {
                columnNames.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        return columnNames;
    }

    private static List<Long> _getCompanyIds() throws SQLException {
        if (_companyIds.isEmpty()) {
            for (long companyId : PortalInstancePool.getCompanyIds()) {
                _companyIds.add(companyId);
            }
        }
        return _companyIds;
    }

    private static Connection _getConnectionWrapper(final Connection connection) {
        return new ConnectionWrapper(connection){

            @Override
            public Statement createStatement() throws SQLException {
                this._setPartition();
                return DBPartitionUtil._wrapStatement(super.createStatement());
            }

            @Override
            public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
                this._setPartition();
                return DBPartitionUtil._wrapStatement(super.createStatement(resultSetType, resultSetConcurrency));
            }

            @Override
            public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                this._setPartition();
                return DBPartitionUtil._wrapStatement(super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
            }

            @Override
            public String getCatalog() throws SQLException {
                return _dbPartitionDB.getCatalog(connection, DBPartitionUtil._getPartitionName(CompanyThreadLocal.getCompanyId()));
            }

            @Override
            public String getSchema() {
                return _dbPartitionDB.getSchema(connection, DBPartitionUtil._getPartitionName(CompanyThreadLocal.getCompanyId()));
            }

            @Override
            public PreparedStatement prepareStatement(String sql) throws SQLException {
                this._setPartition();
                return super.prepareStatement(sql);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
                this._setPartition();
                return super.prepareStatement(sql, autoGeneratedKeys);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                this._setPartition();
                return super.prepareStatement(sql, resultSetType, resultSetConcurrency);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                this._setPartition();
                return super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
                this._setPartition();
                return super.prepareStatement(sql, columnIndexes);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
                this._setPartition();
                return super.prepareStatement(sql, columnNames);
            }

            private void _setPartition() throws SQLException {
                long companyId = CompanyThreadLocal.getCompanyId();
                String partitionName = DBPartitionUtil._getPartitionName(companyId);
                _dbPartitionDB.setPartition(connection, partitionName);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Using database partition ", partitionName, " and company ", companyId}));
                }
            }
        };
    }

    private static String _getCopyDataSQL(String fromPartitionName, String toPartitionName, String tableName, List<String> columnNames, String whereClause) {
        return StringBundler.concat((String[])new String[]{"insert into ", toPartitionName, ".", tableName, "(", StringUtil.merge(columnNames), ") select ", StringUtil.merge(columnNames), " from ", fromPartitionName, ".", tableName, whereClause});
    }

    private static String _getPartitionName(long companyId) {
        if (companyId == 0L || companyId == _defaultCompanyId) {
            return _defaultPartitionName;
        }
        return _DATABASE_PARTITION_SCHEMA_NAME_PREFIX + companyId;
    }

    private static String _getQuartzWhereClauseSQL(long companyId, String tableName) {
        if (StringUtil.endsWith((String)tableName, (String)"JOB_DETAILS")) {
            return " where job_name like '%@" + companyId + "'";
        }
        return " where trigger_name like '%@" + companyId + "'";
    }

    private static void _insertDBPartition(long companyId) throws PortalException {
        AutoCloseable autoCloseable = null;
        ArrayList<String> copiedTableNames = new ArrayList<String>();
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        try (Statement statement = connection.createStatement();){
            autoCloseable = DBPartitionUtil._disableAutoCommit(connection);
            DBInspector dbInspector = new DBInspector(connection);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(_dbPartitionDB.getCatalog(connection, _defaultPartitionName), _dbPartitionDB.getSchema(connection, _defaultPartitionName), null, new String[]{"TABLE"});){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!dbInspector.isControlTable(tableName)) continue;
                    if (dbInspector.hasColumn(tableName, "companyId")) {
                        statement.executeUpdate(DBPartitionUtil._getCopyDataSQL(DBPartitionUtil._getPartitionName(companyId), _defaultPartitionName, tableName, DBPartitionUtil._getColumnNames(connection, tableName), " where companyId = " + companyId));
                        copiedTableNames.add(tableName);
                    } else if (DBPartitionUtil._isCopyableQuartzTable(tableName)) {
                        statement.executeUpdate(DBPartitionUtil._getCopyDataSQL(DBPartitionUtil._getPartitionName(companyId), _defaultPartitionName, tableName, DBPartitionUtil._getColumnNames(connection, tableName), DBPartitionUtil._getQuartzWhereClauseSQL(companyId, tableName)));
                        copiedTableNames.add(tableName);
                    }
                    statement.executeUpdate(_dbPartitionDB.getDropTableSQL(DBPartitionUtil._getPartitionName(companyId), tableName));
                    statement.executeUpdate(_dbPartitionDB.getCreateViewSQL(_defaultPartitionName, DBPartitionUtil._getPartitionName(companyId), tableName));
                }
                connection.commit();
            }
        }
        catch (Exception exception1) {
            if (_dbPartitionDB.isDDLTransactional()) {
                throw new PortalException((Throwable)exception1);
            }
            try (Statement statement2 = connection.createStatement();){
                DBInspector dbInspector = new DBInspector(connection);
                for (String copiedTableName : copiedTableNames) {
                    DBPartitionUtil._extractTable(companyId, copiedTableName, statement2, dbInspector);
                }
                connection.commit();
            }
            catch (Exception exception2) {
                throw new PortalException(StringBundler.concat((Object[])new Object[]{"Unable to roll back the data inserted into the ", "default schema for tables ", copiedTableNames, " and company ID ", companyId}), (Throwable)exception2);
            }
            throw new PortalException(StringBundler.concat((String[])new String[]{"Unable to roll back the insertion of database partition. ", "Recover a backup of the database schema ", DBPartitionUtil._getPartitionName(companyId), "."}), (Throwable)exception1);
        }
        finally {
            if (autoCloseable != null) {
                try {
                    autoCloseable.close();
                }
                catch (Exception exception) {
                    throw new PortalException((Throwable)exception);
                }
            }
        }
        _companyIds.add(companyId);
    }

    private static boolean _isCopyableQuartzTable(String tableName) {
        return StringUtil.startsWith((String)tableName, (String)_QUARTZ_TABLE_NAME_PREFIX) && (StringUtil.endsWith((String)tableName, (String)"JOB_DETAILS") || StringUtil.endsWith((String)tableName, (String)"TRIGGERS"));
    }

    private static boolean _isSkip(Connection connection, String tableName) throws SQLException {
        try {
            DBInspector dbInspector = new DBInspector(connection);
            if (dbInspector.isControlTable(tableName) && CompanyThreadLocal.getCompanyId() != _defaultCompanyId || dbInspector.hasView(tableName)) {
                return true;
            }
        }
        catch (Exception exception) {
            throw new SQLException("Unable to check if the table " + tableName + " is a control table", exception);
        }
        return false;
    }

    private static void _moveCompanyData(long companyId, String fromPartitionName, String toPartitionName, String tableName, Statement statement) throws Exception {
        DBPartitionUtil._moveData(fromPartitionName, toPartitionName, tableName, DBPartitionUtil._getColumnNames(statement.getConnection(), tableName), statement, " where companyId = " + companyId);
    }

    private static void _moveData(String fromPartitionName, String toPartitionName, String tableName, List<String> columnNames, Statement statement, String whereClause) throws Exception {
        statement.executeUpdate(DBPartitionUtil._getCopyDataSQL(fromPartitionName, toPartitionName, tableName, columnNames, whereClause));
        DBPartitionUtil._deleteData(tableName, fromPartitionName, statement, whereClause);
    }

    private static void _restoreView(long companyId, String tableName, Statement statement, DBInspector dbInspector) throws Exception {
        if (dbInspector.hasColumn(tableName, "companyId")) {
            DBPartitionUtil._moveCompanyData(companyId, DBPartitionUtil._getPartitionName(companyId), _defaultPartitionName, tableName, statement);
        } else if (DBPartitionUtil._isCopyableQuartzTable(tableName)) {
            DBPartitionUtil._moveData(DBPartitionUtil._getPartitionName(companyId), _defaultPartitionName, tableName, DBPartitionUtil._getColumnNames(statement.getConnection(), tableName), statement, DBPartitionUtil._getQuartzWhereClauseSQL(companyId, tableName));
        }
        statement.executeUpdate(_dbPartitionDB.getDropTableSQL(DBPartitionUtil._getPartitionName(companyId), tableName));
        statement.executeUpdate(_dbPartitionDB.getCreateViewSQL(_defaultPartitionName, DBPartitionUtil._getPartitionName(companyId), tableName));
    }

    private static Statement _wrapStatement(final Statement statement) {
        return new StatementWrapper(statement){

            @Override
            public int executeUpdate(String sql) throws SQLException {
                Connection connection = statement.getConnection();
                String lowerCaseSQL = StringUtil.toLowerCase((String)sql);
                String[] query = sql.split(" ");
                if (StringUtil.startsWith((String)lowerCaseSQL, (String)"alter table") && DBPartitionUtil._isSkip(connection, query[2]) || StringUtil.startsWith((String)lowerCaseSQL, (String)"create index") && DBPartitionUtil._isSkip(connection, query[4]) || StringUtil.startsWith((String)lowerCaseSQL, (String)"create unique index") && DBPartitionUtil._isSkip(connection, query[5])) {
                    return 0;
                }
                if (StringUtil.startsWith((String)lowerCaseSQL, (String)"drop index")) {
                    if (query.length >= 5 && DBPartitionUtil._isSkip(connection, query[4])) {
                        return 0;
                    }
                    if (query.length <= 4) {
                        sql = StringUtil.replace((String)sql, (String)"drop index ", (String)"drop index if exists ");
                        sql = StringUtil.replace((String)sql, (String)"DROP INDEX ", (String)"DROP INDEX IF EXISTS ");
                    }
                }
                if (!StringUtil.startsWith((String)lowerCaseSQL, (String)"alter table")) {
                    return super.executeUpdate(sql);
                }
                sql = _dbPartitionDB.getSafeAlterTable(sql);
                int returnValue = super.executeUpdate(sql);
                try {
                    DBInspector dbInspector = new DBInspector(connection);
                    String tableName = query[2];
                    if (!dbInspector.isControlTable(tableName)) {
                        return returnValue;
                    }
                    Iterator iterator = DBPartitionUtil._getCompanyIds().iterator();
                    while (iterator.hasNext()) {
                        long companyId = (Long)iterator.next();
                        if (companyId == _defaultCompanyId) continue;
                        super.execute(_dbPartitionDB.getCreateViewSQL(_defaultPartitionName, DBPartitionUtil._getPartitionName(companyId), tableName));
                    }
                    return returnValue;
                }
                catch (Exception exception) {
                    throw new SQLException(exception);
                }
            }
        };
    }
}

