/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.deploy.hot.ServiceBag;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.AopInvocationHandler;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceWrapperRegistry {
    private static final Log _log = LogFactoryUtil.getLog(ServiceWrapperRegistry.class);
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private final ServiceTracker<ServiceWrapper<?>, Closeable> _serviceTracker = new ServiceTracker(this._bundleContext, ServiceWrapper.class.getName(), (ServiceTrackerCustomizer)new ServiceWrapperServiceTrackerCustomizer());

    public ServiceWrapperRegistry() {
        this._serviceTracker.open();
    }

    public void close() {
        this._serviceTracker.close();
    }

    private class ServiceWrapperServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ServiceWrapper<?>, Closeable> {
        private ServiceWrapperServiceTrackerCustomizer() {
        }

        public Closeable addingService(ServiceReference<ServiceWrapper<?>> serviceReference) {
            ServiceWrapper serviceWrapper = (ServiceWrapper)ServiceWrapperRegistry.this._bundleContext.getService(serviceReference);
            try {
                return this._getServiceBag(serviceWrapper);
            }
            catch (Throwable throwable) {
                _log.error((Object)("Unable to get service bag for " + serviceWrapper.getClass()), throwable);
                return null;
            }
        }

        public void modifiedService(ServiceReference<ServiceWrapper<?>> serviceReference, Closeable closeable) {
        }

        public void removedService(ServiceReference<ServiceWrapper<?>> serviceReference, Closeable closeable) {
            ServiceWrapperRegistry.this._bundleContext.ungetService(serviceReference);
            try {
                closeable.close();
            }
            catch (IOException ioException) {
                _log.error((Throwable)ioException);
            }
        }

        private <T> ServiceBag<?> _createServiceBag(Object service, ServiceWrapper<T> serviceWrapper, Class<?> serviceTypeClass, ServiceReference<?> serviceReference) {
            Object serviceProxy = service;
            if (!ProxyUtil.isProxyClass(serviceProxy.getClass())) {
                _log.error((Object)"Service hooks require Spring to be configured to use JdkDynamicProxy and will not work with CGLIB");
                if (serviceReference != null) {
                    ServiceWrapperRegistry.this._bundleContext.ungetService(serviceReference);
                }
                return null;
            }
            AopInvocationHandler aopInvocationHandler = (AopInvocationHandler)ProxyUtil.fetchInvocationHandler((Object)serviceProxy, AopInvocationHandler.class);
            serviceWrapper.setWrappedService(aopInvocationHandler.getTarget());
            return new ServiceBag<T>(aopInvocationHandler, serviceTypeClass, serviceWrapper, ServiceWrapperRegistry.this._bundleContext, serviceReference);
        }

        private <T> Closeable _getServiceBag(final ServiceWrapper<T> serviceWrapper) throws NoSuchMethodException {
            Class<?> clazz = serviceWrapper.getClass();
            Method method = clazz.getMethod("getWrappedService", new Class[0]);
            final Class<?> serviceTypeClass = method.getReturnType();
            ServiceReference serviceReference = ServiceWrapperRegistry.this._bundleContext.getServiceReference(serviceTypeClass);
            if (serviceReference == null) {
                ServiceTracker serviceTracker = new ServiceTracker<T, ServiceBag<?>>(ServiceWrapperRegistry.this._bundleContext, serviceTypeClass, null){

                    public ServiceBag<?> addingService(ServiceReference<T> serviceReference) {
                        return ServiceWrapperServiceTrackerCustomizer.this._createServiceBag(ServiceWrapperRegistry.this._bundleContext.getService(serviceReference), serviceWrapper, serviceTypeClass, serviceReference);
                    }

                    public void removedService(ServiceReference<T> serviceReference, ServiceBag<?> serviceBag) {
                        serviceBag.replace();
                    }
                };
                serviceTracker.open();
                return () -> ((ServiceTracker)serviceTracker).close();
            }
            ServiceBag<?> serviceBag = this._createServiceBag(ServiceWrapperRegistry.this._bundleContext.getService(serviceReference), serviceWrapper, serviceTypeClass, serviceReference);
            return serviceBag::replace;
        }
    }
}

