/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.jabsorb.serializer;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONObject;

public class LocaleSerializer
extends AbstractSerializer {
    private static final Class<?>[] _JSON_CLASSES = new Class[]{JSONObject.class};
    private static final Class<?>[] _SERIALIZABLE_CLASSES = new Class[]{Locale.class};
    private static final Log _log = LogFactoryUtil.getLog(LocaleSerializer.class);

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return Locale.class.isAssignableFrom(clazz) && (jsonClazz == null || jsonClazz == JSONObject.class);
    }

    public Class<?>[] getJSONClasses() {
        return _JSON_CLASSES;
    }

    public Class<?>[] getSerializableClasses() {
        return _SERIALIZABLE_CLASSES;
    }

    public Object marshall(SerializerState serializerState, Object parentObject, Object object) throws MarshallException {
        JSONObject jsonObject = new JSONObject();
        if (this.ser.getMarshallClassHints()) {
            try {
                Class<?> javaClass = object.getClass();
                jsonObject.put("javaClass", (Object)javaClass.getName());
            }
            catch (Exception exception) {
                throw new MarshallException("Unable to put javaClass", (Throwable)exception);
            }
        }
        JSONObject localeJSONObject = new JSONObject();
        try {
            jsonObject.put("locale", (Object)localeJSONObject);
            serializerState.push(object, (Object)localeJSONObject, (Object)"locale");
        }
        catch (Exception exception) {
            throw new MarshallException("Unable to put locale", (Throwable)exception);
        }
        try {
            Locale locale = (Locale)object;
            localeJSONObject.put("country", (Object)locale.getCountry()).put("language", (Object)locale.getLanguage()).put("variant", (Object)locale.getVariant());
        }
        catch (Exception exception) {
            throw new MarshallException("Unable to put country, language, and variant", (Throwable)exception);
        }
        finally {
            serializerState.pop();
        }
        return jsonObject;
    }

    public ObjectMatch tryUnmarshall(SerializerState serializerState, Class clazz, Object object) throws UnmarshallException {
        JSONObject localeJSONObject = this.getLocaleJSONObject(object);
        ObjectMatch objectMatch = ObjectMatch.ROUGHLY_SIMILAR;
        if (localeJSONObject.has("language")) {
            objectMatch = ObjectMatch.OKAY;
        }
        serializerState.setSerialized(object, (Object)objectMatch);
        return objectMatch;
    }

    public Object unmarshall(SerializerState serializerState, Class clazz, Object object) throws UnmarshallException {
        String variant;
        String language;
        String country;
        block7: {
            JSONObject localeJSONObject;
            block6: {
                localeJSONObject = this.getLocaleJSONObject(object);
                country = null;
                try {
                    country = localeJSONObject.getString("country");
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug((Throwable)exception);
                }
            }
            language = null;
            try {
                language = localeJSONObject.getString("language");
            }
            catch (Exception exception) {
                throw new UnmarshallException("language is undefined", (Throwable)exception);
            }
            variant = null;
            try {
                variant = localeJSONObject.getString("variant");
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Throwable)exception);
            }
        }
        Locale locale = null;
        locale = Validator.isNotNull((String)country) && Validator.isNotNull((String)language) && Validator.isNotNull((String)variant) ? new Locale(language, country, variant) : (Validator.isNotNull((String)country) && Validator.isNotNull((String)language) ? new Locale(language, country) : new Locale(language));
        serializerState.setSerialized(object, (Object)locale);
        return locale;
    }

    protected JSONObject getLocaleJSONObject(Object object) throws UnmarshallException {
        JSONObject jsonObject = (JSONObject)object;
        String javaClassName = null;
        try {
            javaClassName = jsonObject.getString("javaClass");
        }
        catch (Exception exception) {
            throw new UnmarshallException("Unable to get javaClass", (Throwable)exception);
        }
        if (javaClassName == null) {
            throw new UnmarshallException("javaClass is undefined");
        }
        try {
            Class.forName(javaClassName);
        }
        catch (Exception exception) {
            throw new UnmarshallException("Unable to load javaClass " + javaClassName, (Throwable)exception);
        }
        JSONObject localeJSONObject = null;
        try {
            localeJSONObject = jsonObject.getJSONObject("locale");
        }
        catch (Exception exception) {
            throw new UnmarshallException("Unable to get locale", (Throwable)exception);
        }
        if (localeJSONObject == null) {
            throw new UnmarshallException("locale is undefined");
        }
        return localeJSONObject;
    }
}

