/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util;

import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.layoutconfiguration.util.LayoutTemplateLocator;
import com.liferay.portal.layoutconfiguration.util.PortletRenderer;
import com.liferay.portal.layoutconfiguration.util.velocity.TemplateProcessor;
import com.liferay.portlet.internal.PortletBagUtil;
import com.liferay.portlet.internal.PortletTypeUtil;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.StopWatch;

public class RuntimePageUtil {
    private static final Log _log = LogFactoryUtil.getLog(RuntimePageUtil.class);

    public static LayoutTemplate getLayoutTemplate(String templateId) {
        LayoutTemplateLocator layoutTemplateLocator = new LayoutTemplateLocator(templateId);
        return LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)layoutTemplateLocator.getLayoutTemplateId(), (boolean)layoutTemplateLocator.isStandard(), (String)layoutTemplateLocator.getThemeId());
    }

    public static StringBundler getProcessedTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, String templateId, String content) throws Exception {
        return RuntimePageUtil.doDispatch(httpServletRequest, httpServletResponse, portletId, templateId, content, null);
    }

    public static void processTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, String templateId, String content) throws Exception {
        StringBundler sb = RuntimePageUtil.doDispatch(httpServletRequest, httpServletResponse, portletId, templateId, content, null);
        sb.writeTo((Writer)httpServletResponse.getWriter());
    }

    public static void processTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, String templateId, String content, String langType) throws Exception {
        StringBundler sb = RuntimePageUtil.doDispatch(httpServletRequest, httpServletResponse, portletId, templateId, content, langType);
        sb.writeTo((Writer)httpServletResponse.getWriter());
    }

    protected static StringBundler doDispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, String templateId, String content, String langType) throws Exception {
        String pluginServletContextName;
        ServletContext pluginServletContext;
        LayoutTemplate layoutTemplate;
        ClassLoader pluginClassLoader = null;
        LayoutTemplateLocator layoutTemplateLocator = new LayoutTemplateLocator(templateId);
        if (langType == null) {
            langType = LayoutTemplateLocalServiceUtil.getLangType((String)layoutTemplateLocator.getLayoutTemplateId(), (boolean)layoutTemplateLocator.isStandard(), (String)layoutTemplateLocator.getThemeId());
        }
        if ((layoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)layoutTemplateLocator.getLayoutTemplateId(), (boolean)layoutTemplateLocator.isStandard(), (String)layoutTemplateLocator.getThemeId())) != null && (pluginServletContext = ServletContextPool.get((String)(pluginServletContextName = GetterUtil.getString((String)layoutTemplate.getServletContextName())))) != null) {
            pluginClassLoader = (ClassLoader)pluginServletContext.getAttribute("PLUGIN_CLASS_LOADER");
        }
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap(pluginClassLoader);){
            StringBundler stringBundler = RuntimePageUtil.doProcessTemplate(httpServletRequest, httpServletResponse, portletId, templateId, content, langType, false);
            return stringBundler;
        }
    }

    protected static StringBundler doProcessTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, String templateId, String content, String langType, boolean restricted) throws Exception {
        javax.portlet.Portlet portlet;
        TemplateProcessor processor = new TemplateProcessor(httpServletRequest, httpServletResponse, portletId);
        TemplateManager templateManager = TemplateManagerUtil.getTemplateManager((String)langType);
        Template template = templateManager.getTemplate((TemplateResource)new StringTemplateResource(templateId, content), restricted);
        template.put((Object)"processor", (Object)processor);
        template.prepare(httpServletRequest);
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        template.prepareTaglib(httpServletRequest, (HttpServletResponse)new PipingServletResponse(httpServletResponse, (Writer)unsyncStringWriter));
        try {
            template.processTemplate((Writer)unsyncStringWriter);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            throw exception;
        }
        Map<Integer, List<PortletRenderer>> portletRenderersMap = processor.getPortletRenderers();
        HashMap<String, Map<String, Object>> portletHeaderRequestMap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<Integer, List<PortletRenderer>> entry : portletRenderersMap.entrySet()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing portlets with render weight " + entry.getKey()));
            }
            List<PortletRenderer> portletRenderers = entry.getValue();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Start serial header phase");
            }
            for (PortletRenderer portletRenderer : portletRenderers) {
                Portlet portletModel = portletRenderer.getPortlet();
                if (!portletModel.isReady() || !PortletTypeUtil.isHeaderPortlet(portlet = PortletBagUtil.getPortletInstance(httpServletRequest.getServletContext(), portletModel, portletModel.getRootPortletId()))) continue;
                Map<String, Object> headerRequestMap = portletRenderer.renderHeaders(httpServletRequest, httpServletResponse, portletModel.getHeaderRequestAttributePrefixes());
                String rendererPortletId = portletModel.getPortletId();
                portletHeaderRequestMap.put(rendererPortletId, headerRequestMap);
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Serially rendered headers for portlet ", rendererPortletId, " in ", stopWatch.getTime(), " ms"}));
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Finished serial header phase in " + stopWatch.getTime() + " ms"));
        }
        HashMap<String, StringBundler> contentsMap = new HashMap<String, StringBundler>();
        for (Map.Entry<Integer, List<PortletRenderer>> entry : portletRenderersMap.entrySet()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing portlets with render weight " + entry.getKey()));
            }
            List<PortletRenderer> portletRenderers = entry.getValue();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Start serial rendering");
            }
            for (PortletRenderer portletRenderer : portletRenderers) {
                portlet = portletRenderer.getPortlet();
                String rendererPortletId = portlet.getPortletId();
                contentsMap.put(rendererPortletId, portletRenderer.render(httpServletRequest, httpServletResponse, (Map)portletHeaderRequestMap.get(rendererPortletId)));
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Serially rendered portlet ", rendererPortletId, " in ", stopWatch.getTime(), " ms"}));
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Finished serial rendering in " + stopWatch.getTime() + " ms"));
        }
        return StringUtil.replaceWithStringBundler((String)unsyncStringWriter.toString(), (String)"[$TEMPLATE_PORTLET_", (String)"$]", contentsMap);
    }
}

