/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ModelHints;
import com.liferay.portal.kernel.model.ModelHintsCallback;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class BaseModelHintsImpl
implements ModelHints {
    private static final Log _log = LogFactoryUtil.getLog(BaseModelHintsImpl.class);
    private Map<String, Map<String, String>> _defaultHints;
    private Map<String, Map<String, FieldDataBag>> _fieldDataBagsMap;
    private Map<String, Map<String, String>> _hintCollections;
    private Set<String> _models;
    private final boolean _productionMode;

    public BaseModelHintsImpl() {
        this(false);
    }

    public BaseModelHintsImpl(boolean productionMode) {
        this._productionMode = productionMode;
    }

    public void afterPropertiesSet() {
        this._hintCollections = new ConcurrentHashMap<String, Map<String, String>>();
        this._defaultHints = new ConcurrentHashMap<String, Map<String, String>>();
        this._fieldDataBagsMap = new ConcurrentHashMap<String, Map<String, FieldDataBag>>();
        this._models = new ConcurrentSkipListSet<String>();
        try {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            for (String config : this.getModelHintsConfigs()) {
                if (config.startsWith("classpath*:")) {
                    String name = config.substring("classpath*:".length());
                    Enumeration<URL> enumeration = classLoader.getResources(name);
                    if (_log.isDebugEnabled() && !enumeration.hasMoreElements()) {
                        _log.debug((Object)("No resources found for " + name));
                    }
                    while (enumeration.hasMoreElements()) {
                        URL url = enumeration.nextElement();
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Loading ", name, " from ", url}));
                        }
                        InputStream inputStream = url.openStream();
                        Throwable throwable = null;
                        try {
                            this.read(classLoader, url.toString(), inputStream);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    continue;
                }
                InputStream inputStream = classLoader.getResourceAsStream(config);
                if (inputStream == null) {
                    File file = new File(config);
                    if (!file.exists()) continue;
                    inputStream = new FileInputStream(file);
                }
                try (InputStream curInputStream = inputStream;){
                    this.read(classLoader, config, curInputStream);
                }
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    public String buildCustomValidatorName(String validatorName) {
        return StringBundler.concat((String[])new String[]{validatorName, "_", StringUtil.randomId()});
    }

    public Map<String, String> getDefaultHints(String model) {
        return this._defaultHints.get(model);
    }

    public Object getFieldsElement(String model, String field) {
        Map<String, FieldDataBag> fieldDataBags = this._fieldDataBagsMap.get(model);
        if (fieldDataBags == null) {
            return null;
        }
        FieldDataBag fieldDataBag = fieldDataBags.get(field);
        if (fieldDataBag == null) {
            return null;
        }
        return fieldDataBag._element;
    }

    public Map<String, String> getHints(String model, String field) {
        Map<String, FieldDataBag> fieldDataBags = this._fieldDataBagsMap.get(model);
        if (fieldDataBags == null) {
            return null;
        }
        FieldDataBag fieldDataBag = fieldDataBags.get(field);
        if (fieldDataBag == null) {
            return null;
        }
        return fieldDataBag._hints;
    }

    public int getMaxLength(String model, String field) {
        Map<String, String> hints = this.getHints(model, field);
        if (hints == null) {
            return Integer.MAX_VALUE;
        }
        int maxLength = GetterUtil.getInteger((String)"75");
        return GetterUtil.getInteger((String)hints.get("max-length"), (int)maxLength);
    }

    public abstract ModelHintsCallback getModelHintsCallback();

    public abstract String[] getModelHintsConfigs();

    public List<String> getModels() {
        return ListUtil.fromCollection(this._models);
    }

    public Tuple getSanitizeTuple(String model, String field) {
        Map<String, FieldDataBag> fieldDataBags = this._fieldDataBagsMap.get(model);
        if (fieldDataBags == null) {
            return null;
        }
        FieldDataBag fieldDataBag = fieldDataBags.get(field);
        if (fieldDataBag == null) {
            return null;
        }
        return fieldDataBag._sanitize;
    }

    public List<Tuple> getSanitizeTuples(String model) {
        Map<String, FieldDataBag> fieldDataBags = this._fieldDataBagsMap.get(model);
        if (fieldDataBags == null) {
            return Collections.emptyList();
        }
        ArrayList<Tuple> sanitizeTuples = new ArrayList<Tuple>();
        for (FieldDataBag fieldDataBag : fieldDataBags.values()) {
            Tuple tuple = fieldDataBag._sanitize;
            if (tuple == null) continue;
            sanitizeTuples.add(tuple);
        }
        return sanitizeTuples;
    }

    public abstract SAXReader getSAXReader();

    public String getType(String model, String field) {
        Map<String, FieldDataBag> fieldDataBags = this._fieldDataBagsMap.get(model);
        if (fieldDataBags == null) {
            return null;
        }
        FieldDataBag fieldDataBag = fieldDataBags.get(field);
        if (fieldDataBag == null) {
            return null;
        }
        return fieldDataBag._type;
    }

    public List<Tuple> getValidators(String model, String field) {
        Map<String, FieldDataBag> fieldDataBags = this._fieldDataBagsMap.get(model);
        if (fieldDataBags == null) {
            return null;
        }
        FieldDataBag fieldDataBag = fieldDataBags.get(field);
        if (fieldDataBag == null) {
            return null;
        }
        return fieldDataBag._validators;
    }

    public String getValue(String model, String field, String name, String defaultValue) {
        Map<String, String> hints = this.getHints(model, field);
        if (hints == null) {
            return defaultValue;
        }
        return GetterUtil.getString((String)hints.get(name), (String)defaultValue);
    }

    public boolean hasField(String model, String field) {
        Map<String, FieldDataBag> fieldDataBags = this._fieldDataBagsMap.get(model);
        if (fieldDataBags == null) {
            return false;
        }
        FieldDataBag fieldDataBag = fieldDataBags.get(field);
        return fieldDataBag != null;
    }

    public boolean isCustomValidator(String validatorName) {
        return validatorName.equals("custom");
    }

    public boolean isLocalized(String model, String field) {
        Map<String, FieldDataBag> fieldDataBags = this._fieldDataBagsMap.get(model);
        if (fieldDataBags == null) {
            return false;
        }
        FieldDataBag fieldDataBag = fieldDataBags.get(field);
        if (fieldDataBag == null) {
            return false;
        }
        return fieldDataBag._localized;
    }

    public void read(ClassLoader classLoader, InputStream inputStream) throws Exception {
        this.read(classLoader, null, inputStream);
    }

    public void read(ClassLoader classLoader, String source) throws Exception {
        this.read(classLoader, source, classLoader.getResourceAsStream(source));
    }

    public void read(ClassLoader classLoader, String source, InputStream inputStream) throws Exception {
        String name;
        if (inputStream == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Cannot load " + source));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading " + source));
        }
        SAXReader saxReader = this.getSAXReader();
        Document document = saxReader.read(inputStream);
        Element rootElement = document.getRootElement();
        List rootElements = rootElement.elements("hint-collection");
        for (Element hintCollectionElement : rootElements) {
            name = hintCollectionElement.attributeValue("name");
            Map<String, String> hints = this._hintCollections.get(name);
            if (hints == null) {
                hints = new HashMap<String, String>();
                this._hintCollections.put(name, hints);
            }
            List hintElements = hintCollectionElement.elements("hint");
            for (Element hintElement : hintElements) {
                String hintName = hintElement.attributeValue("name");
                String hintValue = hintElement.getText();
                hints.put(hintName, hintValue);
            }
        }
        rootElements = rootElement.elements("model");
        for (Element modelElement : rootElements) {
            Map<String, FieldDataBag> fieldDataBags;
            name = modelElement.attributeValue("name");
            ModelHintsCallback modelHintsCallback = this.getModelHintsCallback();
            modelHintsCallback.execute(classLoader, name);
            HashMap<String, String> defaultHints = new HashMap<String, String>();
            if (!this._productionMode) {
                this._defaultHints.put(name, defaultHints);
                Element defaultHintsElement = modelElement.element("default-hints");
                if (defaultHintsElement != null) {
                    List hintElements = defaultHintsElement.elements("hint");
                    for (Element hintElement : hintElements) {
                        String hintName = hintElement.attributeValue("name");
                        String hintValue = hintElement.getText();
                        defaultHints.put(hintName, hintValue);
                    }
                }
            }
            if ((fieldDataBags = this._fieldDataBagsMap.get(name)) == null) {
                fieldDataBags = new HashMap<String, FieldDataBag>();
                this._fieldDataBagsMap.put(name, fieldDataBags);
            }
            this._models.add(name);
            List modelElements = modelElement.elements("field");
            for (Element fieldElement : modelElements) {
                String fieldName = fieldElement.attributeValue("name");
                FieldDataBag fieldDataBag = new FieldDataBag();
                fieldDataBags.put(fieldName, fieldDataBag);
                String fieldType = fieldElement.attributeValue("type");
                boolean fieldLocalized = GetterUtil.getBoolean((String)fieldElement.attributeValue("localized"));
                Map fieldHints = HashMapBuilder.putAll(defaultHints).build();
                List fieldElements = fieldElement.elements("hint-collection");
                for (Element hintCollectionElement : fieldElements) {
                    Map<String, String> hints = this._hintCollections.get(hintCollectionElement.attributeValue("name"));
                    fieldHints.putAll(hints);
                }
                fieldElements = fieldElement.elements("hint");
                for (Element hintElement : fieldElements) {
                    String hintName = hintElement.attributeValue("name");
                    String hintValue = hintElement.getText();
                    fieldHints.put(hintName, hintValue);
                }
                Tuple fieldSanitize = null;
                Element sanitizeElement = fieldElement.element("sanitize");
                if (sanitizeElement != null) {
                    String contentType = sanitizeElement.attributeValue("content-type");
                    String modes = sanitizeElement.attributeValue("modes");
                    fieldSanitize = new Tuple(new Object[]{fieldName, contentType, modes});
                }
                TreeMap<String, Tuple> fieldValidators = new TreeMap<String, Tuple>();
                fieldElements = fieldElement.elements("validator");
                for (Element validatorElement : fieldElements) {
                    String validatorName = validatorElement.attributeValue("name");
                    if (Validator.isNull((String)validatorName)) continue;
                    String validatorErrorMessage = GetterUtil.getString((String)validatorElement.attributeValue("error-message"));
                    String validatorValue = GetterUtil.getString((String)validatorElement.getText());
                    boolean customValidator = this.isCustomValidator(validatorName);
                    if (customValidator) {
                        validatorName = this.buildCustomValidatorName(validatorName);
                    }
                    Tuple fieldValidator = new Tuple(new Object[]{fieldName, validatorName, validatorErrorMessage, validatorValue, customValidator});
                    fieldValidators.put(validatorName, fieldValidator);
                }
                if (this._productionMode) {
                    fieldElement = null;
                }
                fieldDataBag._element = fieldElement;
                fieldDataBag._localized = fieldLocalized;
                fieldDataBag._type = fieldType;
                if (fieldHints.isEmpty()) {
                    fieldHints = Collections.emptyMap();
                } else if (fieldHints.size() == 1) {
                    Set set = fieldHints.entrySet();
                    Iterator iterator = set.iterator();
                    Map.Entry entry = iterator.next();
                    fieldHints = Collections.singletonMap(entry.getKey(), entry.getValue());
                }
                fieldDataBag._hints = fieldHints;
                if (fieldSanitize != null) {
                    fieldDataBag._sanitize = fieldSanitize;
                }
                if (fieldValidators.isEmpty()) continue;
                fieldDataBag._validators = ListUtil.fromMapValues(fieldValidators);
            }
        }
    }

    public String trimString(String model, String field, String value) {
        if (value == null) {
            return value;
        }
        int maxLength = this.getMaxLength(model, field);
        if (value.length() > maxLength) {
            return value.substring(0, maxLength);
        }
        return value;
    }

    private static class FieldDataBag {
        private Element _element;
        private Map<String, String> _hints;
        private boolean _localized;
        private Tuple _sanitize;
        private String _type;
        private List<Tuple> _validators;

        private FieldDataBag() {
        }
    }
}

