/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.adapter.util;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.adapter.builder.ModelAdapterBuilder;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;

public class ModelAdapterUtil {
    private static final Log _log = LogFactoryUtil.getLog(ModelAdapterUtil.class);
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ServiceTrackerMap<String, ModelAdapterBuilder> _serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)_bundleContext, ModelAdapterBuilder.class, null, (serviceReference, emitter) -> {
        block4: {
            ModelAdapterBuilder modelAdapterBuilder = (ModelAdapterBuilder)_bundleContext.getService(serviceReference);
            Type genericInterface = ModelAdapterUtil._getGenericInterface(modelAdapterBuilder, ModelAdapterBuilder.class);
            if (genericInterface == null || !(genericInterface instanceof ParameterizedType)) {
                return;
            }
            ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
            Object[] typeArguments = parameterizedType.getActualTypeArguments();
            if (ArrayUtil.isEmpty((Object[])typeArguments) || typeArguments.length != 2) {
                return;
            }
            try {
                Class adapteeModelClass = (Class)typeArguments[0];
                Class adaptedModelClass = (Class)typeArguments[1];
                emitter.emit((Object)ModelAdapterUtil._getKey(adapteeModelClass, adaptedModelClass));
            }
            catch (ClassCastException classCastException) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)classCastException);
            }
        }
    });

    public static <T, V> List<V> adapt(List<T> adapteeModels, Class<T> adapteeModelClass, Class<V> adaptedModelClass) {
        ArrayList<V> adaptedModels = new ArrayList<V>();
        for (T adapteeModel : adapteeModels) {
            adaptedModels.add(ModelAdapterUtil.adapt(adapteeModel, adapteeModelClass, adaptedModelClass));
        }
        return adaptedModels;
    }

    public static <T, V> List<V> adapt(List<T> adapteeModels, Class<V> adaptedModelClass) {
        ArrayList<V> adaptedModels = new ArrayList<V>();
        for (T adapteeModel : adapteeModels) {
            adaptedModels.add(ModelAdapterUtil.adapt(adapteeModel, adaptedModelClass));
        }
        return adaptedModels;
    }

    public static <T, V> V adapt(T adapteeModel, Class<T> adapteeModelClass, Class<V> adaptedModelClass) {
        return ModelAdapterUtil._adapt(adapteeModel, adapteeModelClass, adaptedModelClass);
    }

    public static <T, V> V adapt(T adapteeModel, Class<V> adaptedModelClass) {
        Class<?> adapteeModelClass = adapteeModel.getClass();
        return ModelAdapterUtil._adapt(adapteeModel, adapteeModelClass, adaptedModelClass);
    }

    private static <T, V> V _adapt(T adapteeModel, Class<T> adapteeModelClass, Class<V> adaptedModelClass) {
        ModelAdapterBuilder modelAdapterBuilder = (ModelAdapterBuilder)_serviceTrackerMap.getService((Object)ModelAdapterUtil._getKey(adapteeModelClass, adaptedModelClass));
        return (V)modelAdapterBuilder.build(adapteeModel);
    }

    private static Type _getGenericInterface(Class<?> clazz, Class<?> interfaceClass) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            Type rawType;
            if (!(genericInterface instanceof ParameterizedType) || !(rawType = (parameterizedType = (ParameterizedType)genericInterface).getRawType()).equals(interfaceClass)) continue;
            return parameterizedType;
        }
        return null;
    }

    private static Type _getGenericInterface(Object object, Class<?> interfaceClass) {
        Class<?> clazz = object.getClass();
        Type genericInterface = ModelAdapterUtil._getGenericInterface(clazz, interfaceClass);
        if (genericInterface != null) {
            return genericInterface;
        }
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            genericInterface = ModelAdapterUtil._getGenericInterface(superClass, interfaceClass);
            if (genericInterface == null) continue;
            return genericInterface;
        }
        return null;
    }

    private static <T, V> String _getKey(Class<T> adapteeModelClass, Class<V> adaptedModelClass) {
        return adapteeModelClass.getName() + "->" + adaptedModelClass.getName();
    }
}

