/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.plugin;

import com.liferay.portal.kernel.model.Plugin;
import com.liferay.portal.kernel.model.PluginSetting;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.PluginSettingLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

public class PluginUtil {
    public static <P extends Plugin> List<P> restrictPlugins(List<P> plugins, long companyId, long userId) {
        return PluginUtil.restrictPlugins(plugins, companyId, 0L, userId);
    }

    public static <P extends Plugin> List<P> restrictPlugins(List<P> plugins, long companyId, long groupId, long userId) {
        ArrayList<Plugin> visiblePlugins = new ArrayList<Plugin>(plugins.size());
        for (Plugin plugin : plugins) {
            PluginSetting pluginSetting = PluginSettingLocalServiceUtil.getPluginSetting((long)companyId, (String)plugin.getPluginId(), (String)plugin.getPluginType());
            if (!pluginSetting.isActive() || !pluginSetting.hasPermission(userId, groupId)) continue;
            visiblePlugins.add(plugin);
        }
        return visiblePlugins;
    }

    public static <P extends Plugin> List<P> restrictPlugins(List<P> plugins, User user) {
        return PluginUtil.restrictPlugins(plugins, user.getCompanyId(), user.getUserId());
    }
}

