/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.UndeployedExternalRepositoryException;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.registry.RepositoryClassDefinition;
import com.liferay.portal.repository.registry.RepositoryClassDefinitionCatalog;

public class RepositoryFactoryImpl
implements RepositoryFactory {
    @BeanReference(type=RepositoryClassDefinitionCatalog.class)
    private RepositoryClassDefinitionCatalog _repositoryClassDefinitionCatalog;
    @BeanReference(type=RepositoryLocalService.class)
    private RepositoryLocalService _repositoryLocalService;

    public LocalRepository createLocalRepository(long repositoryId) throws PortalException {
        RepositoryFactory repositoryFactory = this.getRepositoryFactory(this._getRepositoryCompanyId(repositoryId), this.getRepositoryClassName(repositoryId));
        return repositoryFactory.createLocalRepository(repositoryId);
    }

    public com.liferay.portal.kernel.repository.Repository createRepository(long repositoryId) throws PortalException {
        RepositoryFactory repositoryFactory = this.getRepositoryFactory(this._getRepositoryCompanyId(repositoryId), this.getRepositoryClassName(repositoryId));
        return repositoryFactory.createRepository(repositoryId);
    }

    protected String getRepositoryClassName(long repositoryId) {
        Repository repository = this._repositoryLocalService.fetchRepository(repositoryId);
        if (repository != null) {
            return repository.getClassName();
        }
        return LiferayRepository.class.getName();
    }

    protected RepositoryFactory getRepositoryFactory(long companyId, String className) {
        RepositoryClassDefinition repositoryDefinition = this._repositoryClassDefinitionCatalog.getRepositoryClassDefinition(companyId, className);
        if (repositoryDefinition == null) {
            throw new UndeployedExternalRepositoryException(className);
        }
        return repositoryDefinition;
    }

    private long _getRepositoryCompanyId(long repositoryId) {
        Repository repository = this._repositoryLocalService.fetchRepository(repositoryId);
        if (repository != null) {
            return repository.getCompanyId();
        }
        return 0L;
    }
}

