/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.security.auth.AuthDNE;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.AuthFailure;
import com.liferay.portal.kernel.security.auth.Authenticator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;

public class AuthPipeline {
    private static final ServiceTrackerList<AuthDNE> _authDNEs = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), AuthDNE.class);
    private static final ServiceTrackerMap<String, List<Authenticator>> _authenticators = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)SystemBundleUtil.getBundleContext(), Authenticator.class, (String)"key");
    private static final ServiceTrackerMap<String, List<AuthFailure>> _authFailures = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)SystemBundleUtil.getBundleContext(), AuthFailure.class, (String)"key");

    public static int authenticateByEmailAddress(String key, long companyId, String emailAddress, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        return AuthPipeline._authenticate(key, companyId, emailAddress, password, "emailAddress", headerMap, parameterMap);
    }

    public static int authenticateByScreenName(String key, long companyId, String screenName, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        return AuthPipeline._authenticate(key, companyId, screenName, password, "screenName", headerMap, parameterMap);
    }

    public static int authenticateByUserId(String key, long companyId, long userId, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        return AuthPipeline._authenticate(key, companyId, String.valueOf(userId), password, "userId", headerMap, parameterMap);
    }

    public static void onDoesNotExist(long companyId, String authType, String login, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        List authDNEs = _authDNEs.toList();
        if (authDNEs.isEmpty()) {
            return;
        }
        for (AuthDNE authDNE : authDNEs) {
            try {
                authDNE.onDoesNotExist(companyId, authType, login, headerMap, parameterMap);
            }
            catch (AuthException authException) {
                throw authException;
            }
            catch (Exception exception) {
                throw new AuthException((Throwable)exception);
            }
        }
    }

    public static void onFailureByEmailAddress(String key, long companyId, String emailAddress, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline._onFailure(key, companyId, emailAddress, "emailAddress", headerMap, parameterMap);
    }

    public static void onFailureByScreenName(String key, long companyId, String screenName, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline._onFailure(key, companyId, screenName, "screenName", headerMap, parameterMap);
    }

    public static void onFailureByUserId(String key, long companyId, long userId, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline._onFailure(key, companyId, String.valueOf(userId), "userId", headerMap, parameterMap);
    }

    public static void onMaxFailuresByEmailAddress(String key, long companyId, String emailAddress, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline.onFailureByEmailAddress(key, companyId, emailAddress, headerMap, parameterMap);
    }

    public static void onMaxFailuresByScreenName(String key, long companyId, String screenName, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline.onFailureByScreenName(key, companyId, screenName, headerMap, parameterMap);
    }

    public static void onMaxFailuresByUserId(String key, long companyId, long userId, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline.onFailureByUserId(key, companyId, userId, headerMap, parameterMap);
    }

    private static int _authenticate(String key, long companyId, String login, String password, String authType, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        List authenticators = (List)_authenticators.getService((Object)key);
        if (ListUtil.isEmpty((List)authenticators)) {
            return 1;
        }
        boolean skipLiferayCheck = false;
        for (Authenticator authenticator : authenticators) {
            try {
                int authResult = -1;
                if (authType.equals("emailAddress")) {
                    authResult = authenticator.authenticateByEmailAddress(companyId, login, password, headerMap, parameterMap);
                } else if (authType.equals("screenName")) {
                    authResult = authenticator.authenticateByScreenName(companyId, login, password, headerMap, parameterMap);
                } else if (authType.equals("userId")) {
                    long userId = GetterUtil.getLong((String)login);
                    authResult = authenticator.authenticateByUserId(companyId, userId, password, headerMap, parameterMap);
                }
                if (authResult == 2) {
                    skipLiferayCheck = true;
                    continue;
                }
                if (authResult == 1) continue;
                return authResult;
            }
            catch (AuthException authException) {
                throw authException;
            }
            catch (Exception exception) {
                throw new AuthException((Throwable)exception);
            }
        }
        if (skipLiferayCheck) {
            return 2;
        }
        return 1;
    }

    private static void _onFailure(String key, long companyId, String login, String authType, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        List authFailures = (List)_authFailures.getService((Object)key);
        if (authFailures.isEmpty()) {
            return;
        }
        for (AuthFailure authFailure : authFailures) {
            try {
                if (authType.equals("emailAddress")) {
                    authFailure.onFailureByEmailAddress(companyId, login, headerMap, parameterMap);
                    continue;
                }
                if (authType.equals("screenName")) {
                    authFailure.onFailureByScreenName(companyId, login, headerMap, parameterMap);
                    continue;
                }
                if (!authType.equals("userId")) continue;
                long userId = GetterUtil.getLong((String)login);
                authFailure.onFailureByUserId(companyId, userId, headerMap, parameterMap);
            }
            catch (AuthException authException) {
                throw authException;
            }
            catch (Exception exception) {
                throw new AuthException((Throwable)exception);
            }
        }
    }
}

