/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.internal.security.permission.contributor.RoleCollectionImpl;
import com.liferay.portal.kernel.exception.NoSuchResourcePermissionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Resource;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.security.permission.contributor.RoleCollection;
import com.liferay.portal.kernel.security.permission.contributor.RoleContributor;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutSetPrototypePermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.BasePermissionChecker;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.UserBagFactoryUtil;
import com.liferay.portal.service.permission.LayoutPrototypePermissionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.time.StopWatch;

public class AdvancedPermissionChecker
extends BasePermissionChecker {
    private static final Log _log = LogFactoryUtil.getLog(AdvancedPermissionChecker.class);
    private Map<Long, long[]> _contributedRoleIds;
    private RoleContributor[] _roleContributors;

    @Override
    public AdvancedPermissionChecker clone() {
        return new AdvancedPermissionChecker();
    }

    @Override
    public long[] getGuestUserRoleIds() {
        long[] roleIds = PermissionCacheUtil.getUserGroupRoleIds(this.guestUserId, 0L);
        if (roleIds != null) {
            return roleIds;
        }
        List roles = RoleLocalServiceUtil.getUserRoles((long)this.guestUserId);
        roleIds = ListUtil.toLongArray((List)roles, (Accessor)Role.ROLE_ID_ACCESSOR);
        if (roleIds.length > 1) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"More than one role ID was returned for the guest user. This may cause guest users to have more permissions than intended.");
            }
            Arrays.sort(roleIds);
        }
        PermissionCacheUtil.putUserGroupRoleIds(this.guestUserId, 0L, roleIds);
        return roleIds;
    }

    @Override
    public long[] getRoleIds(long userId, long groupId) {
        try {
            return this._applyRoleContributors(this.doGetRoleIds(userId, groupId), groupId);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return PermissionChecker.DEFAULT_ROLE_IDS;
        }
    }

    public UserBag getUserBag() throws PortalException {
        return UserBagFactoryUtil.create(this.getUserId());
    }

    public boolean hasOwnerPermission(long companyId, String name, String primKey, long ownerId, String actionId) {
        List guestUnsupportedActions;
        if (ownerId != this.getUserId()) {
            return false;
        }
        boolean ownerIsGuestUser = false;
        if (ownerId == this.guestUserId) {
            ownerIsGuestUser = true;
        }
        if (ownerIsGuestUser && (guestUnsupportedActions = name.indexOf(46) != -1 ? ResourceActionsUtil.getModelResourceGuestUnsupportedActions((String)name) : ResourceActionsUtil.getPortletResourceGuestUnsupportedActions((String)name)).contains(actionId)) {
            return false;
        }
        try {
            long ownerRoleId = this.getOwnerRoleId();
            if (ownerIsGuestUser) {
                Role guestRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
                ownerRoleId = guestRole.getRoleId();
            }
            return ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)name, (int)4, (String)primKey, (long)ownerRoleId, (String)actionId);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
    }

    public boolean hasPermission(Group group, String name, String primKey, String actionId) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        long groupId = 0L;
        try {
            if (group != null) {
                if (group.isLayout()) {
                    Layout layout = LayoutLocalServiceUtil.getLayout((long)group.getClassPK());
                    group = layout.getGroup();
                } else if (group.isUserPersonalSite()) {
                    return false;
                }
                if (group.isUser() && group.getClassPK() == this.getUserId()) {
                    group = GroupLocalServiceUtil.getGroup((long)this.getCompanyId(), (String)"User Personal Site");
                }
                groupId = group.getGroupId();
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        long[] roleIds = this.getRoleIds(this.getUserId(), groupId);
        Boolean value = PermissionCacheUtil.getPermission(groupId, name, primKey, roleIds, actionId);
        if (value != null) {
            return value;
        }
        value = this._hasPermissionImpl(group, name, primKey, roleIds, actionId);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Checking permission for ", groupId, " ", name, " ", primKey, " ", actionId, " takes ", stopWatch.getTime(), " ms"}));
        }
        PermissionCacheUtil.putPermission(groupId, name, primKey, roleIds, actionId, value);
        return value;
    }

    public void init(User user, RoleContributor[] roleContributors) {
        this.init(user);
        this._roleContributors = roleContributors;
    }

    public boolean isCompanyAdmin() {
        try {
            return this.isCompanyAdminImpl(this.user.getCompanyId());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public boolean isCompanyAdmin(long companyId) {
        try {
            return this.isCompanyAdminImpl(companyId);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public boolean isContentReviewer(long companyId, long groupId) {
        try {
            return this.isContentReviewerImpl(companyId, groupId);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public boolean isGroupAdmin(long groupId) {
        try {
            Group group = null;
            if (groupId > 0L) {
                group = GroupLocalServiceUtil.fetchGroup((long)groupId);
            }
            return this._isGroupAdminImpl(group);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public boolean isGroupMember(long groupId) {
        try {
            return this.isGroupMemberImpl(groupId);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public boolean isGroupOwner(long groupId) {
        try {
            return this.isGroupOwnerImpl(groupId);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public boolean isOrganizationAdmin(long organizationId) {
        try {
            return this.isOrganizationAdminImpl(organizationId);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public boolean isOrganizationOwner(long organizationId) {
        try {
            return this.isOrganizationOwnerImpl(organizationId);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    protected void addTeamRoles(long userId, Group group, Set<Long> roleIds) throws Exception {
        Group stagingGroup;
        int count = TeamLocalServiceUtil.getGroupTeamsCount((long)group.getGroupId());
        List roles = null;
        if (count > 0) {
            roles = RoleLocalServiceUtil.getUserTeamRoles((long)userId, (long)group.getGroupId());
            for (Role role : roles) {
                roleIds.add(role.getRoleId());
            }
        }
        if (group.isStaged() && !group.isStagedRemotely() && (count = TeamLocalServiceUtil.getGroupTeamsCount((long)(stagingGroup = group.getStagingGroup()).getGroupId())) > 0) {
            roles = RoleLocalServiceUtil.getUserTeamRoles((long)userId, (long)stagingGroup.getGroupId());
            for (Role role : roles) {
                roleIds.add(role.getRoleId());
            }
        }
    }

    protected boolean doCheckPermission(long companyId, long groupId, String name, String primKey, long[] roleIds, String actionId, StopWatch stopWatch) throws Exception {
        this.logHasUserPermission(groupId, name, primKey, actionId, stopWatch, 1);
        List<Resource> resources = this.getResources(companyId, groupId, name, primKey, actionId);
        resources = this.fixMissingResources(companyId, groupId, name, primKey, actionId, resources);
        this.logHasUserPermission(groupId, name, primKey, actionId, stopWatch, 3);
        boolean value = ResourceLocalServiceUtil.hasUserPermissions((long)this.user.getUserId(), (long)groupId, resources, (String)actionId, (long[])roleIds);
        this.logHasUserPermission(groupId, name, primKey, actionId, stopWatch, 4);
        return value;
    }

    protected long[] doGetRoleIds(long userId, long groupId) throws Exception {
        long[] userUserGroupsIds;
        if (!this.signedIn) {
            return this.getGuestUserRoleIds();
        }
        long[] roleIds = PermissionCacheUtil.getUserGroupRoleIds(userId, groupId);
        if (roleIds != null) {
            return roleIds;
        }
        if (this._contributedRoleIds != null) {
            this._contributedRoleIds.remove(groupId);
        }
        Group group = null;
        long parentGroupId = 0L;
        if (groupId > 0L && (group = GroupLocalServiceUtil.getGroup((long)groupId)).isLayout() && (parentGroupId = group.getParentGroupId()) > 0L) {
            group = GroupLocalServiceUtil.getGroup((long)parentGroupId);
        }
        UserBag userBag = this.getUserBag();
        Set roleIdsSet = SetUtil.fromArray((long[])userBag.getRoleIds());
        List userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)userId, (long)groupId);
        for (UserGroupRole userGroupRole : userGroupRoles) {
            roleIdsSet.add(userGroupRole.getRoleId());
        }
        if (parentGroupId > 0L) {
            userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)userId, (long)parentGroupId);
            for (UserGroupRole userGroupRole : userGroupRoles) {
                roleIdsSet.add(userGroupRole.getRoleId());
            }
        }
        if ((userUserGroupsIds = userBag.getUserUserGroupsIds()).length > 0) {
            List userGroupGroupRoles = UserGroupGroupRoleLocalServiceUtil.getUserGroupGroupRolesByUser((long)userId, (long)groupId);
            for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
                roleIdsSet.add(userGroupGroupRole.getRoleId());
            }
            if (parentGroupId > 0L) {
                userGroupGroupRoles = UserGroupGroupRoleLocalServiceUtil.getUserGroupGroupRoles((long)userId, (long)parentGroupId);
                for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
                    roleIdsSet.add(userGroupGroupRole.getRoleId());
                }
            }
        }
        if (group != null) {
            Role powerUserRole;
            if (group.isOrganization() && userBag.hasUserOrgGroup(group)) {
                Role organizationUserRole = RoleLocalServiceUtil.getRole((long)group.getCompanyId(), (String)"Organization User");
                roleIdsSet.add(organizationUserRole.getRoleId());
            }
            if (group.isSite() && (userBag.hasUserGroup(group) || userBag.hasUserOrgGroup(group))) {
                Role siteMemberRole = RoleLocalServiceUtil.getRole((long)group.getCompanyId(), (String)"Site Member");
                roleIdsSet.add(siteMemberRole.getRoleId());
            }
            if (group.isUserPersonalSite() && userBag.hasRole(powerUserRole = RoleLocalServiceUtil.getRole((long)this.getCompanyId(), (String)"Power User"))) {
                Role siteMemberRole = RoleLocalServiceUtil.getRole((long)group.getCompanyId(), (String)"Site Member");
                roleIdsSet.add(siteMemberRole.getRoleId());
            }
            if (group.isOrganization() && userBag.hasUserOrgGroup(group) || group.isSite() && userBag.hasUserGroup(group)) {
                this.addTeamRoles(userId, group, roleIdsSet);
            }
        }
        if (this.checkGuest) {
            for (long roleId : this.getGuestUserRoleIds()) {
                roleIdsSet.add(roleId);
            }
        }
        roleIds = ArrayUtil.toLongArray((Collection)roleIdsSet);
        Arrays.sort(roleIds);
        PermissionCacheUtil.putUserGroupRoleIds(userId, groupId, roleIds);
        return roleIds;
    }

    protected List<Resource> fixMissingResources(long companyId, long groupId, String name, String primKey, String actionId, List<Resource> resources) throws Exception {
        String message;
        int count = ResourcePermissionLocalServiceUtil.getResourcePermissionsCount((long)companyId, (String)name, (int)4, (String)primKey);
        if (count > 0) {
            return resources;
        }
        String newIndividualResourcePrimKey = null;
        if (primKey.contains("_LAYOUT_")) {
            newIndividualResourcePrimKey = name;
            if (_log.isDebugEnabled()) {
                message = StringBundler.concat((String[])new String[]{"Using defaults because custom permissions for portlet ", "resource ", name, " are not defined"});
                _log.debug((Object)message, (Throwable)new IllegalArgumentException(message));
            }
        } else if (groupId > 0L && ResourceActionsUtil.isRootModelResource((String)name)) {
            newIndividualResourcePrimKey = name;
            if (_log.isDebugEnabled()) {
                message = StringBundler.concat((String[])new String[]{"Using defaults because custom permissions for root model ", "resource ", name, " are not defined"});
                _log.debug((Object)message, (Throwable)new IllegalArgumentException(message));
            }
        } else if (primKey.equals("0") || primKey.equals(String.valueOf(-1L)) || primKey.equals(String.valueOf(companyId)) && !name.equals(Company.class.getName())) {
            newIndividualResourcePrimKey = name;
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(9);
                sb.append("Using ");
                sb.append(name);
                sb.append(" as the primary key instead of the legacy primary ");
                sb.append("key ");
                sb.append(primKey);
                sb.append(" that was used for permission checking of ");
                sb.append(name);
                sb.append(" in company ");
                sb.append(companyId);
                _log.warn((Object)sb.toString(), (Throwable)new IllegalArgumentException(sb.toString()));
            }
        }
        if (newIndividualResourcePrimKey != null) {
            Resource individualResource = resources.get(0);
            if (individualResource.getScope() != 4) {
                throw new IllegalArgumentException("The first resource must be an individual scope");
            }
            individualResource.setPrimKey(name);
        }
        return resources;
    }

    protected List<Resource> getResources(long companyId, long groupId, String name, String primKey, String actionId) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>(4);
        Resource individualResource = ResourceLocalServiceUtil.getResource((long)companyId, (String)name, (int)4, (String)primKey);
        resources.add(individualResource);
        if (groupId > 0L) {
            Resource groupResource = ResourceLocalServiceUtil.getResource((long)companyId, (String)name, (int)2, (String)String.valueOf(groupId));
            resources.add(groupResource);
        }
        if (this.signedIn && groupId > 0L) {
            Resource groupTemplateResource = ResourceLocalServiceUtil.getResource((long)companyId, (String)name, (int)3, (String)String.valueOf(0L));
            resources.add(groupTemplateResource);
        }
        Resource companyResource = ResourceLocalServiceUtil.getResource((long)companyId, (String)name, (int)1, (String)String.valueOf(companyId));
        resources.add(companyResource);
        return resources;
    }

    protected boolean isCompanyAdminImpl(long companyId) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin()) {
            return true;
        }
        Boolean value = PermissionCacheUtil.getUserPrimaryKeyRole(this.getUserId(), companyId, "Administrator");
        if (value == null) {
            value = RoleLocalServiceUtil.hasUserRole((long)this.user.getUserId(), (long)companyId, (String)"Administrator", (boolean)true);
            PermissionCacheUtil.putUserPrimaryKeyRole(this.getUserId(), companyId, "Administrator", value);
        }
        return value;
    }

    protected boolean isContentReviewerImpl(long groupId) throws PortalException {
        if (this.isCompanyAdmin() || this.isGroupAdmin(groupId)) {
            return true;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        return RoleLocalServiceUtil.hasUserRole((long)this.getUserId(), (long)group.getCompanyId(), (String)"Portal Content Reviewer", (boolean)true) || group.isSite() && UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)groupId, (String)"Site Content Reviewer", (boolean)true);
    }

    protected boolean isContentReviewerImpl(long companyId, long groupId) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin() || this.isCompanyAdmin(companyId)) {
            return true;
        }
        if (groupId <= 0L) {
            return false;
        }
        if (this.isGroupAdmin(groupId)) {
            return true;
        }
        Boolean value = PermissionCacheUtil.getUserPrimaryKeyRole(this.getUserId(), groupId, "Site Content Reviewer");
        if (value == null) {
            value = this.isContentReviewerImpl(groupId);
            PermissionCacheUtil.putUserPrimaryKeyRole(this.getUserId(), groupId, "Site Content Reviewer", value);
        }
        return value;
    }

    protected boolean isGroupAdminImpl(Group group) throws Exception {
        if (group.isLayout()) {
            long parentGroupId = group.getParentGroupId();
            if (parentGroupId == 0L) {
                return false;
            }
            group = GroupLocalServiceUtil.getGroup((long)parentGroupId);
        }
        if (group.isSite()) {
            if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)group.getGroupId(), (String)"Site Administrator", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)group.getGroupId(), (String)"Site Owner", (boolean)true)) {
                return true;
            }
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            Group parentGroup = group;
            while (!parentGroup.isRoot()) {
                if (!this.doCheckPermission((parentGroup = parentGroup.getParentGroup()).getCompanyId(), parentGroup.getGroupId(), Group.class.getName(), String.valueOf(parentGroup.getGroupId()), this.getRoleIds(this.getUserId(), parentGroup.getGroupId()), "MANAGE_SUBGROUPS", stopWatch)) continue;
                return true;
            }
        }
        if (group.isCompany()) {
            return this.isCompanyAdmin();
        }
        if (group.isLayoutPrototype()) {
            return LayoutPrototypePermissionUtil.contains(this, group.getClassPK(), "UPDATE");
        }
        if (group.isLayoutSetPrototype()) {
            return LayoutSetPrototypePermissionUtil.contains((PermissionChecker)this, (long)group.getClassPK(), (String)"UPDATE");
        }
        if (group.isOrganization()) {
            long organizationId = group.getOrganizationId();
            while (organizationId != 0L) {
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                long organizationGroupId = organization.getGroupId();
                if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)organizationGroupId, (String)"Organization Administrator", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                    return true;
                }
                organizationId = organization.getParentOrganizationId();
            }
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            Organization organization = OrganizationLocalServiceUtil.getOrganization((long)group.getOrganizationId());
            while (!organization.isRoot()) {
                Organization parentOrganization = organization.getParentOrganization();
                Group parentGroup = parentOrganization.getGroup();
                if (this.doCheckPermission(parentGroup.getCompanyId(), parentGroup.getGroupId(), Organization.class.getName(), String.valueOf(parentOrganization.getOrganizationId()), this.getRoleIds(this.getUserId(), parentGroup.getGroupId()), "MANAGE_SUBORGANIZATIONS", stopWatch)) {
                    return true;
                }
                organization = parentOrganization;
            }
        }
        return false;
    }

    protected boolean isGroupMemberImpl(long groupId) throws Exception {
        if (!this.signedIn || groupId <= 0L) {
            return false;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        Role role = RoleLocalServiceUtil.getRole((long)group.getCompanyId(), (String)"Site Member");
        int count = Arrays.binarySearch(this.getRoleIds(this.getUserId(), group.getGroupId()), role.getRoleId());
        if (count >= 0) {
            return true;
        }
        UserBag userBag = this.getUserBag();
        return userBag.hasUserGroup(group);
    }

    protected boolean isGroupOwnerImpl(Group group) throws PortalException {
        if (group.isSite() && UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)group.getGroupId(), (String)"Site Owner", (boolean)true)) {
            return true;
        }
        if (group.isLayoutPrototype()) {
            return LayoutPrototypePermissionUtil.contains(this, group.getClassPK(), "UPDATE");
        }
        if (group.isLayoutSetPrototype()) {
            return LayoutSetPrototypePermissionUtil.contains((PermissionChecker)this, (long)group.getClassPK(), (String)"UPDATE");
        }
        if (group.isOrganization()) {
            long organizationId = group.getOrganizationId();
            while (organizationId != 0L) {
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                long organizationGroupId = organization.getGroupId();
                if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                    return true;
                }
                organizationId = organization.getParentOrganizationId();
            }
        } else if (group.isUser()) {
            long groupUserId = group.getClassPK();
            if (this.getUserId() == groupUserId) {
                return true;
            }
        }
        return false;
    }

    protected boolean isGroupOwnerImpl(long groupId) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin()) {
            return true;
        }
        if (groupId <= 0L) {
            return false;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (this.isCompanyAdmin(group.getCompanyId())) {
            return true;
        }
        Boolean value = PermissionCacheUtil.getUserPrimaryKeyRole(this.getUserId(), group.getGroupId(), "Site Owner");
        if (value == null) {
            value = this.isGroupOwnerImpl(group);
            PermissionCacheUtil.putUserPrimaryKeyRole(this.getUserId(), group.getGroupId(), "Site Owner", value);
        }
        return value;
    }

    protected boolean isOrganizationAdminImpl(long organizationId) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin()) {
            return true;
        }
        if (organizationId <= 0L) {
            return false;
        }
        Organization organization = OrganizationLocalServiceUtil.fetchOrganization((long)organizationId);
        if (organization == null) {
            return false;
        }
        if (this.isCompanyAdmin(organization.getCompanyId())) {
            return true;
        }
        Boolean value = PermissionCacheUtil.getUserPrimaryKeyRole(this.getUserId(), organization.getOrganizationId(), "Organization Administrator");
        if (value == null) {
            value = this.isOrganizationAdminImpl(organization);
            PermissionCacheUtil.putUserPrimaryKeyRole(this.getUserId(), organization.getOrganizationId(), "Organization Administrator", value);
        }
        return value;
    }

    protected boolean isOrganizationAdminImpl(Organization organization) throws PortalException {
        while (organization != null) {
            long organizationGroupId = organization.getGroupId();
            long userId = this.getUserId();
            if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)userId, (long)organizationGroupId, (String)"Organization Administrator", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)userId, (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                return true;
            }
            organization = organization.getParentOrganization();
        }
        return false;
    }

    protected boolean isOrganizationOwnerImpl(long organizationId) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin()) {
            return true;
        }
        if (organizationId <= 0L) {
            return false;
        }
        Organization organization = OrganizationLocalServiceUtil.fetchOrganization((long)organizationId);
        if (organization == null) {
            return false;
        }
        if (this.isCompanyAdmin(organization.getCompanyId())) {
            return true;
        }
        Boolean value = PermissionCacheUtil.getUserPrimaryKeyRole(this.getUserId(), organization.getOrganizationId(), "Organization Owner");
        if (value == null) {
            value = this.isOrganizationOwnerImpl(organization);
            PermissionCacheUtil.putUserPrimaryKeyRole(this.getUserId(), organization.getOrganizationId(), "Organization Owner", value);
        }
        return value;
    }

    protected boolean isOrganizationOwnerImpl(Organization organization) throws PortalException {
        while (organization != null) {
            long organizationGroupId = organization.getGroupId();
            if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this.getUserId(), (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                return true;
            }
            organization = organization.getParentOrganization();
        }
        return false;
    }

    protected void logHasUserPermission(long groupId, String name, String primKey, String actionId, StopWatch stopWatch, int block) {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Checking user permission block ", block, " for ", groupId, " ", name, " ", primKey, " ", actionId, " takes ", stopWatch.getTime(), " ms"}));
    }

    private long[] _applyRoleContributors(long[] roleIds, long groupId) {
        if (this._roleContributors.length == 0) {
            return roleIds;
        }
        if (this._contributedRoleIds == null) {
            this._contributedRoleIds = new HashMap<Long, long[]>();
        }
        return this._contributedRoleIds.computeIfAbsent(groupId, key -> {
            try {
                RoleCollectionImpl roleCollectionImpl = new RoleCollectionImpl(this.user, this.getUserBag(), roleIds, groupId, this);
                for (RoleContributor roleContributor : this._roleContributors) {
                    roleContributor.contribute((RoleCollection)roleCollectionImpl);
                }
                return roleCollectionImpl.getRoleIds();
            }
            catch (PortalException portalException) {
                return (long[])ReflectionUtil.throwException((Throwable)portalException);
            }
        });
    }

    private boolean _hasGuestPermission(Group group, String name, String primKey, String actionId) {
        List actions;
        List resourceActions = ResourceActionsUtil.getResourceActions((String)name);
        if (!resourceActions.contains(actionId)) {
            return false;
        }
        if (name.indexOf(46) != -1 ? (actions = ResourceActionsUtil.getModelResourceGuestUnsupportedActions((String)name)).contains(actionId) : (actions = ResourceActionsUtil.getPortletResourceGuestUnsupportedActions((String)name)).contains(actionId)) {
            return false;
        }
        long companyId = this.user.getCompanyId();
        long groupId = 0L;
        if (group != null) {
            companyId = group.getCompanyId();
            groupId = group.getGroupId();
        }
        try {
            List<Resource> resources = this.getResources(companyId, groupId, name, primKey, actionId);
            resources = this.fixMissingResources(companyId, groupId, name, primKey, actionId, resources);
            return ResourceLocalServiceUtil.hasUserPermissions((long)this.guestUserId, (long)groupId, resources, (String)actionId, (long[])this._applyRoleContributors(this.getGuestUserRoleIds(), groupId));
        }
        catch (NoSuchResourcePermissionException noSuchResourcePermissionException) {
            throw new IllegalArgumentException("Someone may be trying to circumvent the permission checker: " + noSuchResourcePermissionException.getMessage(), noSuchResourcePermissionException);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    private boolean _hasPermissionImpl(Group group, String name, String primKey, long[] roleIds, String actionId) {
        try {
            if (!this.signedIn) {
                return this._hasGuestPermission(group, name, primKey, actionId);
            }
            return this._hasUserPermissionImpl(group, name, primKey, roleIds, actionId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    private boolean _hasUserPermissionImpl(Group group, String name, String primKey, long[] roleIds, String actionId) throws Exception {
        boolean hasPermission;
        Role siteMemberRole;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        long companyId = this.user.getCompanyId();
        long groupId = 0L;
        if (group != null) {
            companyId = group.getCompanyId();
            groupId = group.getGroupId();
        }
        try {
            boolean hasPermission2 = this.doCheckPermission(companyId, groupId, name, primKey, roleIds, actionId, stopWatch);
            if (hasPermission2) {
                return true;
            }
        }
        catch (NoSuchResourcePermissionException noSuchResourcePermissionException) {
            throw new IllegalArgumentException("Someone may be trying to circumvent the permission checker: " + noSuchResourcePermissionException.getMessage(), noSuchResourcePermissionException);
        }
        if (this.isOmniadmin() || name.equals(Organization.class.getName()) && this.isOrganizationAdminImpl(GetterUtil.getLong((String)primKey))) {
            return true;
        }
        if (this.isCompanyAdminImpl(companyId)) {
            return true;
        }
        if (this._isGroupAdminImpl(group) && (Validator.isNull((String)name) || Validator.isNull((String)primKey) || !primKey.contains("_LAYOUT_") || PortletPermissionUtil.hasLayoutManagerPermission((String)name, (String)actionId))) {
            return true;
        }
        return group != null && group.isUserPersonalSite() && "VIEW".equals(actionId) && !ArrayUtil.contains((long[])roleIds, (long)(siteMemberRole = RoleLocalServiceUtil.getRole((long)this.getCompanyId(), (String)"Site Member")).getRoleId()) && (hasPermission = this.doCheckPermission(companyId, groupId, name, primKey, new long[]{siteMemberRole.getRoleId()}, actionId, stopWatch));
    }

    private boolean _isGroupAdminImpl(Group group) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin()) {
            return true;
        }
        if (group == null) {
            return false;
        }
        if (this.isCompanyAdmin(group.getCompanyId())) {
            return true;
        }
        Boolean value = PermissionCacheUtil.getUserPrimaryKeyRole(this.getUserId(), group.getGroupId(), "Site Administrator");
        if (value == null) {
            value = this.isGroupAdminImpl(group);
            PermissionCacheUtil.putUserPrimaryKeyRole(this.getUserId(), group.getGroupId(), "Site Administrator", value);
        }
        return value;
    }
}

