/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.RepositoryLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.RepositoryPersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;

public abstract class RepositoryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements IdentifiableOSGiService,
RepositoryLocalService {
    @BeanReference(type=RepositoryLocalService.class)
    protected RepositoryLocalService repositoryLocalService;
    @BeanReference(type=RepositoryPersistence.class)
    protected RepositoryPersistence repositoryPersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(RepositoryLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public Repository addRepository(Repository repository) {
        repository.setNew(true);
        return (Repository)this.repositoryPersistence.update((BaseModel)repository);
    }

    @Transactional(enabled=false)
    public Repository createRepository(long repositoryId) {
        return this.repositoryPersistence.create(repositoryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Repository deleteRepository(long repositoryId) throws PortalException {
        return this.repositoryPersistence.remove(repositoryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Repository deleteRepository(Repository repository) throws PortalException {
        return (Repository)this.repositoryPersistence.remove((BaseModel)repository);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.repositoryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(Repository.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.repositoryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.repositoryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.repositoryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.repositoryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.repositoryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public Repository fetchRepository(long repositoryId) {
        return this.repositoryPersistence.fetchByPrimaryKey(repositoryId);
    }

    public Repository fetchRepositoryByUuidAndGroupId(String uuid, long groupId) {
        return this.repositoryPersistence.fetchByUUID_G(uuid, groupId);
    }

    public Repository getRepository(long repositoryId) throws PortalException {
        return this.repositoryPersistence.findByPrimaryKey(repositoryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.repositoryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Repository.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("repositoryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.repositoryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Repository.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("repositoryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.repositoryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Repository.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("repositoryId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        final ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
                long referrerClassNameId = stagedModelType.getReferrerClassNameId();
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                    dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
                } else if (referrerClassNameId == -2L) {
                    dynamicQuery.add(classNameIdProperty.isNotNull());
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Repository>(){

            public void performAction(Repository repository) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)repository);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)Repository.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.repositoryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement RepositoryLocalServiceImpl#deleteRepository(Repository) to avoid orphaned data");
        }
        return this.repositoryLocalService.deleteRepository((Repository)persistedModel);
    }

    public BasePersistence<Repository> getBasePersistence() {
        return this.repositoryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.repositoryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<Repository> getRepositoriesByUuidAndCompanyId(String uuid, long companyId) {
        return this.repositoryPersistence.findByUuid_C(uuid, companyId);
    }

    public List<Repository> getRepositoriesByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<Repository> orderByComparator) {
        return this.repositoryPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public Repository getRepositoryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.repositoryPersistence.findByUUID_G(uuid, groupId);
    }

    public List<Repository> getRepositories(int start, int end) {
        return this.repositoryPersistence.findAll(start, end);
    }

    public int getRepositoriesCount() {
        return this.repositoryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public Repository updateRepository(Repository repository) {
        return (Repository)this.repositoryPersistence.update((BaseModel)repository);
    }

    public RepositoryLocalService getRepositoryLocalService() {
        return this.repositoryLocalService;
    }

    public void setRepositoryLocalService(RepositoryLocalService repositoryLocalService) {
        this.repositoryLocalService = repositoryLocalService;
    }

    public RepositoryPersistence getRepositoryPersistence() {
        return this.repositoryPersistence;
    }

    public void setRepositoryPersistence(RepositoryPersistence repositoryPersistence) {
        this.repositoryPersistence = repositoryPersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public void afterPropertiesSet() {
        RepositoryLocalServiceUtil.setService((RepositoryLocalService)this.repositoryLocalService);
    }

    public void destroy() {
        RepositoryLocalServiceUtil.setService(null);
    }

    public String getOSGiServiceIdentifier() {
        return RepositoryLocalService.class.getName();
    }

    public CTPersistence<Repository> getCTPersistence() {
        return this.repositoryPersistence;
    }

    public Class<Repository> getModelClass() {
        return Repository.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<Repository>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.repositoryPersistence);
    }

    protected String getModelClassName() {
        return Repository.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.repositoryPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

