/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.service.base.AddressServiceBaseImpl;
import com.liferay.portal.service.permission.CommonPermissionUtil;
import java.util.List;
import java.util.Objects;

public class AddressServiceImpl
extends AddressServiceBaseImpl {
    public Address addAddress(String externalReferenceCode, String className, long classPK, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long listTypeId, boolean mailing, boolean primary, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        String actionId = "UPDATE";
        if (Objects.equals(className, "com.liferay.account.model.AccountEntry")) {
            actionId = "MANAGE_ADDRESSES";
        }
        CommonPermissionUtil.check(permissionChecker, className, classPK, actionId);
        return this.addressLocalService.addAddress(externalReferenceCode, permissionChecker.getUserId(), className, classPK, name, description, street1, street2, street3, city, zip, regionId, countryId, listTypeId, mailing, primary, phoneNumber, serviceContext);
    }

    public void deleteAddress(long addressId) throws PortalException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        String actionId = "UPDATE";
        if (Objects.equals(address.getClassName(), "com.liferay.account.model.AccountEntry")) {
            actionId = "MANAGE_ADDRESSES";
        }
        CommonPermissionUtil.check(this.getPermissionChecker(), address.getClassNameId(), address.getClassPK(), actionId);
        this.addressLocalService.deleteAddress(address);
    }

    public Address getAddress(long addressId) throws PortalException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        CommonPermissionUtil.check(this.getPermissionChecker(), address.getClassNameId(), address.getClassPK(), "VIEW");
        return address;
    }

    public List<Address> getAddresses(String className, long classPK) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, "VIEW");
        User user = this.getUser();
        return this.addressLocalService.getAddresses(user.getCompanyId(), className, classPK);
    }

    public List<Address> getListTypeAddresses(String className, long classPK, long[] listTypeIds) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, "VIEW");
        User user = this.getUser();
        return this.addressLocalService.getListTypeAddresses(user.getCompanyId(), className, classPK, listTypeIds);
    }

    public Address updateAddress(long addressId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long listTypeId, boolean mailing, boolean primary, String phoneNumber) throws PortalException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        String actionId = "UPDATE";
        if (Objects.equals(address.getClassName(), "com.liferay.account.model.AccountEntry")) {
            actionId = "MANAGE_ADDRESSES";
        }
        CommonPermissionUtil.check(this.getPermissionChecker(), address.getClassNameId(), address.getClassPK(), actionId);
        return this.addressLocalService.updateAddress(addressId, name, description, street1, street2, street3, city, zip, regionId, countryId, listTypeId, mailing, primary, phoneNumber);
    }
}

