/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.service.base.PhoneServiceBaseImpl;
import com.liferay.portal.service.permission.CommonPermissionUtil;
import java.util.List;
import java.util.Objects;

public class PhoneServiceImpl
extends PhoneServiceBaseImpl {
    public Phone addPhone(String className, long classPK, String number, String extension, long typeId, boolean primary, ServiceContext serviceContext) throws PortalException {
        String actionId = "UPDATE";
        if (Objects.equals(className, "com.liferay.account.model.AccountEntry")) {
            actionId = "MANAGE_ADDRESSES";
        }
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, actionId);
        return this.phoneLocalService.addPhone(this.getUserId(), className, classPK, number, extension, typeId, primary, serviceContext);
    }

    public void deletePhone(long phoneId) throws PortalException {
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        String actionId = "UPDATE";
        if (Objects.equals(phone.getClassName(), "com.liferay.account.model.AccountEntry")) {
            actionId = "MANAGE_ADDRESSES";
        }
        CommonPermissionUtil.check(this.getPermissionChecker(), phone.getClassNameId(), phone.getClassPK(), actionId);
        this.phoneLocalService.deletePhone(phone);
    }

    public Phone getPhone(long phoneId) throws PortalException {
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        CommonPermissionUtil.check(this.getPermissionChecker(), phone.getClassNameId(), phone.getClassPK(), "VIEW");
        return phone;
    }

    public List<Phone> getPhones(String className, long classPK) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, "VIEW");
        User user = this.getUser();
        return this.phoneLocalService.getPhones(user.getCompanyId(), className, classPK);
    }

    public Phone updatePhone(long phoneId, String number, String extension, long typeId, boolean primary) throws PortalException {
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        String actionId = "UPDATE";
        if (Objects.equals(phone.getClassName(), "com.liferay.account.model.AccountEntry")) {
            actionId = "MANAGE_ADDRESSES";
        }
        CommonPermissionUtil.check(this.getPermissionChecker(), phone.getClassNameId(), phone.getClassPK(), actionId);
        return this.phoneLocalService.updatePhone(phoneId, number, extension, typeId, primary);
    }
}

