/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.TeamPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.UserGroupIdComparator;
import com.liferay.portal.security.membershippolicy.UserGroupMembershipPolicyUtil;
import com.liferay.portal.service.base.UserGroupServiceBaseImpl;
import com.liferay.portal.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.service.persistence.constants.UserGroupFinderConstants;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class UserGroupServiceImpl
extends UserGroupServiceBaseImpl {
    public void addGroupUserGroups(long groupId, long[] userGroupIds) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.userGroupLocalService.addGroupUserGroups(groupId, userGroupIds);
    }

    public UserGroup addOrUpdateUserGroup(String externalReferenceCode, String name, String description, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        UserGroup userGroup = this.userGroupLocalService.fetchUserGroupByExternalReferenceCode(externalReferenceCode, permissionChecker.getCompanyId());
        if (userGroup == null) {
            PortalPermissionUtil.check((PermissionChecker)permissionChecker, (String)"ADD_USER_GROUP");
        } else {
            UserGroupPermissionUtil.check(permissionChecker, userGroup.getUserGroupId(), "UPDATE");
        }
        return this.userGroupLocalService.addOrUpdateUserGroup(externalReferenceCode, permissionChecker.getUserId(), permissionChecker.getCompanyId(), name, description, serviceContext);
    }

    public void addTeamUserGroups(long teamId, long[] userGroupIds) throws PortalException {
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)teamId, (String)"ASSIGN_MEMBERS");
        this.userGroupLocalService.addTeamUserGroups(teamId, userGroupIds);
    }

    public UserGroup addUserGroup(String name, String description, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_USER_GROUP");
        User user = this.getUser();
        UserGroup userGroup = this.userGroupLocalService.addUserGroup(user.getUserId(), user.getCompanyId(), name, description, serviceContext);
        UserGroupMembershipPolicyUtil.verifyPolicy(userGroup);
        return userGroup;
    }

    public void deleteUserGroup(long userGroupId) throws PortalException {
        UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroupId, "DELETE");
        this.userGroupLocalService.deleteUserGroup(userGroupId);
    }

    public UserGroup fetchUserGroup(long userGroupId) throws PortalException {
        UserGroup userGroup = this.userGroupLocalService.fetchUserGroup(userGroupId);
        if (userGroup != null) {
            UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroupId, "VIEW");
        }
        return userGroup;
    }

    public UserGroup fetchUserGroupByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        UserGroup userGroup = this.userGroupLocalService.fetchUserGroupByExternalReferenceCode(externalReferenceCode, companyId);
        if (userGroup != null) {
            UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroup.getUserGroupId(), "VIEW");
        }
        return userGroup;
    }

    public List<UserGroup> getGtUserGroups(long gtUserGroupId, long companyId, long parentUserGroupId, int size) {
        return this.userGroupPersistence.filterFindByGtU_C_P(gtUserGroupId, companyId, parentUserGroupId, 0, size, (OrderByComparator)new UserGroupIdComparator(true));
    }

    public UserGroup getUserGroup(long userGroupId) throws PortalException {
        UserGroup userGroup = this.userGroupLocalService.getUserGroup(userGroupId);
        UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroupId, "VIEW");
        return userGroup;
    }

    public UserGroup getUserGroup(String name) throws PortalException {
        User user = this.getUser();
        UserGroup userGroup = this.userGroupLocalService.getUserGroup(user.getCompanyId(), name);
        UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroup.getUserGroupId(), "VIEW");
        return userGroup;
    }

    public List<UserGroup> getUserGroups(long companyId) throws PortalException {
        return this.filterUserGroups(this.userGroupLocalService.getUserGroups(companyId));
    }

    public List<UserGroup> getUserGroups(long companyId, String name, int start, int end) {
        if (Validator.isNull((String)name)) {
            return this.userGroupPersistence.filterFindByCompanyId(companyId, start, end);
        }
        return this.userGroupPersistence.filterFindByC_LikeN(companyId, name, start, end);
    }

    public int getUserGroupsCount(long companyId, String name) {
        if (Validator.isNull((String)name)) {
            return this.userGroupPersistence.filterCountByCompanyId(companyId);
        }
        return this.userGroupPersistence.filterCountByC_LikeN(companyId, name);
    }

    public List<UserGroup> getUserUserGroups(long userId) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        List userGroups = this.userGroupLocalService.getUserUserGroups(userId);
        return this.filterUserGroups(userGroups);
    }

    public List<UserGroup> search(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<UserGroup> orderByComparator) {
        if (this.isUseCustomSQL(params)) {
            return this.userGroupFinder.filterFindByKeywords(companyId, keywords, params, start, end, orderByComparator);
        }
        String orderByCol = orderByComparator.getOrderByFields()[0];
        String orderByType = "asc";
        if (!orderByComparator.isAscending()) {
            orderByType = "desc";
        }
        Sort sort = SortFactoryUtil.getSort(UserGroup.class, (String)orderByCol, (String)orderByType);
        try {
            return UsersAdminUtil.getUserGroups(this.userGroupLocalService.search(companyId, keywords, params, start, end, sort));
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public List<UserGroup> search(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<UserGroup> orderByComparator) {
        if (this.isUseCustomSQL(params)) {
            return this.userGroupFinder.filterFindByC_N_D(companyId, name, description, params, andOperator, start, end, orderByComparator);
        }
        String orderByCol = orderByComparator.getOrderByFields()[0];
        String orderByType = "asc";
        if (!orderByComparator.isAscending()) {
            orderByType = "desc";
        }
        Sort sort = SortFactoryUtil.getSort(UserGroup.class, (String)orderByCol, (String)orderByType);
        try {
            return UsersAdminUtil.getUserGroups(this.userGroupLocalService.search(companyId, name, description, params, andOperator, start, end, sort));
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public int searchCount(long companyId, String keywords, LinkedHashMap<String, Object> params) {
        if (this.isUseCustomSQL(params)) {
            return this.userGroupFinder.filterCountByKeywords(companyId, keywords, params);
        }
        return this.userGroupLocalService.searchCount(companyId, keywords, params);
    }

    public int searchCount(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) {
        if (this.isUseCustomSQL(params)) {
            return this.userGroupFinder.filterCountByC_N_D(companyId, name, description, params, andOperator);
        }
        return this.userGroupLocalService.searchCount(companyId, name, description, params, andOperator);
    }

    public void unsetGroupUserGroups(long groupId, long[] userGroupIds) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.userGroupLocalService.unsetGroupUserGroups(groupId, userGroupIds);
    }

    public void unsetTeamUserGroups(long teamId, long[] userGroupIds) throws PortalException {
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)teamId, (String)"ASSIGN_MEMBERS");
        this.userGroupLocalService.unsetTeamUserGroups(teamId, userGroupIds);
    }

    public UserGroup updateExternalReferenceCode(UserGroup userGroup, String externalReferenceCode) throws PortalException {
        UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroup.getUserGroupId(), "UPDATE");
        return this.userGroupLocalService.updateExternalReferenceCode(userGroup, externalReferenceCode);
    }

    public UserGroup updateUserGroup(long userGroupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroupId, "UPDATE");
        User user = this.getUser();
        return this.userGroupLocalService.updateUserGroup(user.getCompanyId(), userGroupId, name, description, serviceContext);
    }

    protected List<UserGroup> filterUserGroups(List<UserGroup> userGroups) throws PortalException {
        ArrayList<UserGroup> filteredGroups = new ArrayList<UserGroup>();
        for (UserGroup userGroup : userGroups) {
            if (!UserGroupPermissionUtil.contains(this.getPermissionChecker(), userGroup.getUserGroupId(), "VIEW")) continue;
            filteredGroups.add(userGroup);
        }
        return filteredGroups;
    }

    protected boolean isUseCustomSQL(LinkedHashMap<String, Object> params) {
        if (MapUtil.isEmpty(params)) {
            return false;
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
        if (!indexer.isIndexerEnabled() || !PropsValues.USER_GROUPS_SEARCH_WITH_INDEX) {
            return true;
        }
        if (MapUtil.isEmpty(params)) {
            return false;
        }
        for (String key : params.keySet()) {
            if (!ArrayUtil.contains((Object[])UserGroupFinderConstants.PARAM_KEYS, (Object)key)) continue;
            return true;
        }
        return false;
    }
}

