/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchCompanyException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.CompanyTable;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.CompanyPersistence;
import com.liferay.portal.kernel.service.persistence.CompanyUtil;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.CompanyImpl;
import com.liferay.portal.model.impl.CompanyModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CompanyPersistenceImpl
extends BasePersistenceImpl<Company>
implements CompanyPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CompanyImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathFetchByWebId;
    private FinderPath _finderPathCountByWebId;
    private static final String _FINDER_COLUMN_WEBID_WEBID_2 = "company.webId = ?";
    private static final String _FINDER_COLUMN_WEBID_WEBID_3 = "(company.webId IS NULL OR company.webId = '')";
    private FinderPath _finderPathFetchByMx;
    private FinderPath _finderPathCountByMx;
    private static final String _FINDER_COLUMN_MX_MX_2 = "company.mx = ?";
    private static final String _FINDER_COLUMN_MX_MX_3 = "(company.mx IS NULL OR company.mx = '')";
    private FinderPath _finderPathFetchByLogoId;
    private FinderPath _finderPathCountByLogoId;
    private static final String _FINDER_COLUMN_LOGOID_LOGOID_2 = "company.logoId = ?";
    private int _valueObjectFinderCacheListThreshold;
    private static final String _SQL_SELECT_COMPANY = "SELECT company FROM Company company";
    private static final String _SQL_SELECT_COMPANY_WHERE = "SELECT company FROM Company company WHERE ";
    private static final String _SQL_COUNT_COMPANY = "SELECT COUNT(company) FROM Company company";
    private static final String _SQL_COUNT_COMPANY_WHERE = "SELECT COUNT(company) FROM Company company WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "company.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Company exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Company exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CompanyPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"active", "type", "size"});

    public Company findByWebId(String webId) throws NoSuchCompanyException {
        Company company = this.fetchByWebId(webId);
        if (company == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("webId=");
            sb.append(webId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchCompanyException(sb.toString());
        }
        return company;
    }

    public Company fetchByWebId(String webId) {
        return this.fetchByWebId(webId, true);
    }

    public Company fetchByWebId(String webId, boolean useFinderCache) {
        Company company;
        webId = Objects.toString(webId, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{webId};
        }
        Object result = null;
        if (useFinderCache) {
            result = FinderCacheUtil.getResult((FinderPath)this._finderPathFetchByWebId, (Object[])finderArgs, (BasePersistence)this);
        }
        if (result instanceof Company && !Objects.equals(webId, (company = (Company)result).getWebId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_COMPANY_WHERE);
            boolean bindWebId = false;
            if (webId.isEmpty()) {
                sb.append(_FINDER_COLUMN_WEBID_WEBID_3);
            } else {
                bindWebId = true;
                sb.append(_FINDER_COLUMN_WEBID_WEBID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindWebId) {
                    queryPos.add(webId);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByWebId, (Object[])finderArgs, (Object)list);
                    }
                } else {
                    Company company2 = (Company)list.get(0);
                    result = company2;
                    this.cacheResult(company2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company removeByWebId(String webId) throws NoSuchCompanyException {
        Company company = this.findByWebId(webId);
        return (Company)this.remove((BaseModel)company);
    }

    public int countByWebId(String webId) {
        webId = Objects.toString(webId, "");
        FinderPath finderPath = this._finderPathCountByWebId;
        Object[] finderArgs = new Object[]{webId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMPANY_WHERE);
            boolean bindWebId = false;
            if (webId.isEmpty()) {
                sb.append(_FINDER_COLUMN_WEBID_WEBID_3);
            } else {
                bindWebId = true;
                sb.append(_FINDER_COLUMN_WEBID_WEBID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindWebId) {
                    queryPos.add(webId);
                }
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Company findByMx(String mx) throws NoSuchCompanyException {
        Company company = this.fetchByMx(mx);
        if (company == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("mx=");
            sb.append(mx);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchCompanyException(sb.toString());
        }
        return company;
    }

    public Company fetchByMx(String mx) {
        return this.fetchByMx(mx, true);
    }

    public Company fetchByMx(String mx, boolean useFinderCache) {
        Company company;
        mx = Objects.toString(mx, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{mx};
        }
        Object result = null;
        if (useFinderCache) {
            result = FinderCacheUtil.getResult((FinderPath)this._finderPathFetchByMx, (Object[])finderArgs, (BasePersistence)this);
        }
        if (result instanceof Company && !Objects.equals(mx, (company = (Company)result).getMx())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_COMPANY_WHERE);
            boolean bindMx = false;
            if (mx.isEmpty()) {
                sb.append(_FINDER_COLUMN_MX_MX_3);
            } else {
                bindMx = true;
                sb.append(_FINDER_COLUMN_MX_MX_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindMx) {
                    queryPos.add(mx);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByMx, (Object[])finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{mx};
                            }
                            _log.warn((Object)("CompanyPersistenceImpl.fetchByMx(String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    Company company2 = (Company)list.get(0);
                    result = company2;
                    this.cacheResult(company2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company removeByMx(String mx) throws NoSuchCompanyException {
        Company company = this.findByMx(mx);
        return (Company)this.remove((BaseModel)company);
    }

    public int countByMx(String mx) {
        mx = Objects.toString(mx, "");
        FinderPath finderPath = this._finderPathCountByMx;
        Object[] finderArgs = new Object[]{mx};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMPANY_WHERE);
            boolean bindMx = false;
            if (mx.isEmpty()) {
                sb.append(_FINDER_COLUMN_MX_MX_3);
            } else {
                bindMx = true;
                sb.append(_FINDER_COLUMN_MX_MX_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindMx) {
                    queryPos.add(mx);
                }
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Company findByLogoId(long logoId) throws NoSuchCompanyException {
        Company company = this.fetchByLogoId(logoId);
        if (company == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("logoId=");
            sb.append(logoId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchCompanyException(sb.toString());
        }
        return company;
    }

    public Company fetchByLogoId(long logoId) {
        return this.fetchByLogoId(logoId, true);
    }

    public Company fetchByLogoId(long logoId, boolean useFinderCache) {
        Company company;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{logoId};
        }
        Object result = null;
        if (useFinderCache) {
            result = FinderCacheUtil.getResult((FinderPath)this._finderPathFetchByLogoId, (Object[])finderArgs, (BasePersistence)this);
        }
        if (result instanceof Company && logoId != (company = (Company)result).getLogoId()) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_COMPANY_WHERE);
            sb.append(_FINDER_COLUMN_LOGOID_LOGOID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(logoId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByLogoId, (Object[])finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{logoId};
                            }
                            _log.warn((Object)("CompanyPersistenceImpl.fetchByLogoId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    Company company2 = (Company)list.get(0);
                    result = company2;
                    this.cacheResult(company2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company removeByLogoId(long logoId) throws NoSuchCompanyException {
        Company company = this.findByLogoId(logoId);
        return (Company)this.remove((BaseModel)company);
    }

    public int countByLogoId(long logoId) {
        FinderPath finderPath = this._finderPathCountByLogoId;
        Object[] finderArgs = new Object[]{logoId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMPANY_WHERE);
            sb.append(_FINDER_COLUMN_LOGOID_LOGOID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(logoId);
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CompanyPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("active", "active_");
        dbColumnNames.put("type", "type_");
        dbColumnNames.put("size", "size_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(Company.class);
        this.setModelImplClass(CompanyImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CompanyTable.INSTANCE);
    }

    public void cacheResult(Company company) {
        EntityCacheUtil.putResult(CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()), (Serializable)company);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByWebId, (Object[])new Object[]{company.getWebId()}, (Object)company);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByMx, (Object[])new Object[]{company.getMx()}, (Object)company);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByLogoId, (Object[])new Object[]{company.getLogoId()}, (Object)company);
    }

    public void cacheResult(List<Company> companies) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && companies.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (Company company : companies) {
            Company cachedCompany = (Company)EntityCacheUtil.getResult(CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()));
            if (cachedCompany == null) {
                this.cacheResult(company);
                continue;
            }
            CompanyModelImpl companyModelImpl = (CompanyModelImpl)company;
            CompanyModelImpl cachedCompanyModelImpl = (CompanyModelImpl)cachedCompany;
            companyModelImpl.setCompanySecurityBag(cachedCompanyModelImpl.getCompanySecurityBag());
            companyModelImpl.setVirtualHostname(cachedCompanyModelImpl.getVirtualHostname());
        }
    }

    public void clearCache() {
        EntityCacheUtil.clearCache(CompanyImpl.class);
        FinderCacheUtil.clearCache(CompanyImpl.class);
    }

    public void clearCache(Company company) {
        EntityCacheUtil.removeResult(CompanyImpl.class, (BaseModel)company);
    }

    public void clearCache(List<Company> companies) {
        for (Company company : companies) {
            EntityCacheUtil.removeResult(CompanyImpl.class, (BaseModel)company);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        FinderCacheUtil.clearCache(CompanyImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            EntityCacheUtil.removeResult(CompanyImpl.class, (Serializable)primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(CompanyModelImpl companyModelImpl) {
        Object[] args = new Object[]{companyModelImpl.getWebId()};
        FinderCacheUtil.putResult((FinderPath)this._finderPathCountByWebId, (Object[])args, (Object)1L);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByWebId, (Object[])args, (Object)((Object)companyModelImpl));
        args = new Object[]{companyModelImpl.getMx()};
        FinderCacheUtil.putResult((FinderPath)this._finderPathCountByMx, (Object[])args, (Object)1L);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByMx, (Object[])args, (Object)((Object)companyModelImpl));
        args = new Object[]{companyModelImpl.getLogoId()};
        FinderCacheUtil.putResult((FinderPath)this._finderPathCountByLogoId, (Object[])args, (Object)1L);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByLogoId, (Object[])args, (Object)((Object)companyModelImpl));
    }

    public Company create(long companyId) {
        CompanyImpl company = new CompanyImpl();
        company.setNew(true);
        company.setPrimaryKey(companyId);
        return company;
    }

    public Company remove(long companyId) throws NoSuchCompanyException {
        return this.remove(Long.valueOf(companyId));
    }

    public Company remove(Serializable primaryKey) throws NoSuchCompanyException {
        Session session = null;
        try {
            session = this.openSession();
            Company company = (Company)session.get(CompanyImpl.class, primaryKey);
            if (company == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCompanyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Company company2 = (Company)this.remove((BaseModel)company);
            return company2;
        }
        catch (NoSuchCompanyException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Company removeImpl(Company company) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)company)) {
                company = (Company)session.get(CompanyImpl.class, company.getPrimaryKeyObj());
            }
            if (company != null) {
                session.delete((Object)company);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (company != null) {
            this.clearCache(company);
        }
        return company;
    }

    public Company updateImpl(Company company) {
        boolean isNew = company.isNew();
        if (!(company instanceof CompanyModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(company.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)company);
                throw new IllegalArgumentException("Implement ModelWrapper in company proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Company implementation " + company.getClass());
        }
        CompanyModelImpl companyModelImpl = (CompanyModelImpl)company;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && company.getCreateDate() == null) {
            if (serviceContext == null) {
                company.setCreateDate(date);
            } else {
                company.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!companyModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                company.setModifiedDate(date);
            } else {
                company.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)company);
            } else {
                company = (Company)session.merge((Object)company);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        EntityCacheUtil.putResult(CompanyImpl.class, (BaseModel)companyModelImpl, (boolean)false, (boolean)true);
        this.cacheUniqueFindersCache(companyModelImpl);
        if (isNew) {
            company.setNew(false);
        }
        company.resetOriginalValues();
        return company;
    }

    public Company findByPrimaryKey(Serializable primaryKey) throws NoSuchCompanyException {
        Company company = (Company)this.fetchByPrimaryKey(primaryKey);
        if (company == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCompanyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return company;
    }

    public Company findByPrimaryKey(long companyId) throws NoSuchCompanyException {
        return this.findByPrimaryKey(Long.valueOf(companyId));
    }

    public Company fetchByPrimaryKey(long companyId) {
        return (Company)this.fetchByPrimaryKey(Long.valueOf(companyId));
    }

    public List<Company> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Company> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Company> findAll(int start, int end, OrderByComparator<Company> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Company> findAll(int start, int end, OrderByComparator<Company> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_COMPANY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_COMPANY;
                sql = sql.concat(" ORDER BY company.companyId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Company company : this.findAll()) {
            this.remove((BaseModel)company);
        }
    }

    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_COMPANY);
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    protected String getPKDBName() {
        return "companyId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_COMPANY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CompanyModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathFetchByWebId = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByWebId", new String[]{String.class.getName()}, new String[]{"webId"}, true);
        this._finderPathCountByWebId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByWebId", new String[]{String.class.getName()}, new String[]{"webId"}, false);
        this._finderPathFetchByMx = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByMx", new String[]{String.class.getName()}, new String[]{"mx"}, true);
        this._finderPathCountByMx = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByMx", new String[]{String.class.getName()}, new String[]{"mx"}, false);
        this._finderPathFetchByLogoId = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByLogoId", new String[]{Long.class.getName()}, new String[]{"logoId"}, true);
        this._finderPathCountByLogoId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByLogoId", new String[]{Long.class.getName()}, new String[]{"logoId"}, false);
        CompanyUtil.setPersistence((CompanyPersistence)this);
    }

    public void destroy() {
        CompanyUtil.setPersistence(null);
        EntityCacheUtil.removeCache((String)CompanyImpl.class.getName());
    }

    protected FinderCache getFinderCache() {
        return FinderCacheUtil.getFinderCache();
    }
}

