/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.frontend.source.map.FrontendSourceMapUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.RequestDispatcherUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.minifier.MinifierUtil;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.util.AggregateUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ComboServlet
extends HttpServlet {
    private static final String _CSS_CHARSET_UTF_8 = "@charset \"UTF-8\";";
    private static final String _CSS_EXTENSION = "css";
    private static final String _CSS_MINIFIED_DASH_SUFFIX = "-min.css";
    private static final String _CSS_MINIFIED_DOT_SUFFIX = ".min.css";
    private static final FileContentBag _EMPTY_FILE_CONTENT_BAG = new FileContentBag(new byte[0], 0L);
    private static final String _JAVASCRIPT_MINIFIED_DASH_SUFFIX = "-min.js";
    private static final String _JAVASCRIPT_MINIFIED_DOT_SUFFIX = ".min.js";
    private static final Log _log = LogFactoryUtil.getLog(ComboServlet.class);
    private static final PortalCache<String, byte[][]> _bytesArrayPortalCache = PortalCacheHelperUtil.getPortalCache((String)"SINGLE_VM_PORTAL_CACHE_MANAGER", (String)ComboServlet.class.getName());
    private static final PortalCache<String, FileContentBag> _fileContentBagPortalCache = PortalCacheHelperUtil.getPortalCache((String)"SINGLE_VM_PORTAL_CACHE_MANAGER", (String)FileContentBag.class.getName());
    private static final Pattern _importModulePattern = Pattern.compile("(import\\s*\\*\\s*as\\s*\\w*\\s*from\\s*[\"'])((?:\\.\\./)+)(.*)", 32);
    private final Set<String> _protectedParameters = SetUtil.fromArray((Object[])new String[]{"browserId", "minifierType", "languageId", "t", "themeId", "zx"});

    public static void clearCache() {
        _bytesArrayPortalCache.removeAll();
        _fileContentBagPortalCache.removeAll();
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            this.doService(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            PortalUtil.sendError((int)500, (Exception)exception, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
    }

    protected static String getModulePortletId(String modulePath) {
        int index = modulePath.indexOf(58);
        if (index > 0) {
            return modulePath.substring(0, index);
        }
        return "90";
    }

    protected static String getResourcePath(String modulePath) {
        int index = modulePath.indexOf(58);
        if (index > 0) {
            return HttpComponentsUtil.removePathParameters((String)modulePath.substring(index + 1));
        }
        return HttpComponentsUtil.removePathParameters((String)modulePath);
    }

    /*
     * WARNING - void declaration
     */
    protected void doService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        void var11_24;
        void var11_22;
        String minifierType;
        LinkedHashSet<String> modulePathsSet = new LinkedHashSet<String>();
        Map parameterMap = HttpComponentsUtil.getParameterMap((String)httpServletRequest.getQueryString());
        Enumeration enumeration = Collections.enumeration(parameterMap.keySet());
        while (enumeration.hasMoreElements()) {
            String pathProxy;
            String name = (String)enumeration.nextElement();
            if (this._protectedParameters.contains(name)) continue;
            name = HttpComponentsUtil.decodePath((String)name);
            String modulePortletId = "";
            int index = name.indexOf(58);
            if (index > 0) {
                modulePortletId = name.substring(0, index + 1);
                name = name.substring(index + 1);
            }
            if (name.startsWith(pathProxy = PortalUtil.getPathProxy())) {
                name = name.replaceFirst(pathProxy, "");
            }
            if (index < 0) {
                ServletContext servletContext = this.getServletContext();
                String string = servletContext.getContextPath();
                if (name.startsWith(string)) {
                    name = name.replaceFirst(string, "");
                }
            } else {
                name = modulePortletId.concat(name);
            }
            name = this._canonicalizePath(name);
            if (Validator.isNull((String)name)) continue;
            modulePathsSet.add(name);
        }
        if (modulePathsSet.isEmpty()) {
            PortalUtil.sendError((int)404, (Exception)((Object)new NoSuchLayoutException("Query string translates to an empty module paths set")), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            return;
        }
        if (PropsValues.COMBO_MAX_FILES > 0 && modulePathsSet.size() > PropsValues.COMBO_MAX_FILES) {
            httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            httpServletResponse.setStatus(400);
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Request exceeds maximum number of files");
            }
            return;
        }
        Object[] modulePaths = modulePathsSet.toArray(new String[0]);
        String extension = "";
        for (String string : modulePaths) {
            String pathExtension = this._getModulePathExtension(string);
            if (Validator.isNull((String)pathExtension)) continue;
            if (Validator.isNull((String)extension)) {
                extension = pathExtension;
            }
            if (string.startsWith("/documents/d/") || extension.equals(pathExtension)) continue;
            httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            httpServletResponse.setStatus(400);
            return;
        }
        boolean cacheEnabled = true;
        if (PropsValues.WORK_DIR_OVERRIDE_ENABLED) {
            cacheEnabled = false;
            httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        }
        if (Validator.isNull((String)(minifierType = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"minifierType")))) {
            minifierType = "js";
            if (StringUtil.equalsIgnoreCase((String)extension, (String)_CSS_EXTENSION)) {
                minifierType = _CSS_EXTENSION;
            }
        }
        if (!minifierType.equals(_CSS_EXTENSION) && !minifierType.equals("js")) {
            minifierType = "js";
        }
        String modulePathsString = null;
        byte[][] byArray = null;
        if (!PropsValues.COMBO_CHECK_TIMESTAMP) {
            modulePathsString = Arrays.toString(modulePaths);
            modulePathsString = modulePathsString + "#" + LanguageUtil.getLanguageId((HttpServletRequest)httpServletRequest);
            byte[][] byArray2 = (byte[][])_bytesArrayPortalCache.get((Serializable)((Object)modulePathsString));
        }
        if (var11_22 == null) {
            byte[][] byArrayArray = new byte[modulePaths.length][];
            for (int i = 0; i < modulePaths.length; ++i) {
                Object modulePath = modulePaths[i];
                if (!this.validateModuleExtension((String)modulePath)) {
                    httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                    httpServletResponse.setStatus(400);
                    return;
                }
                byte[] bytes = new byte[]{};
                if (Validator.isNotNull((String)modulePath)) {
                    RequestDispatcher requestDispatcher = this.getResourceRequestDispatcher(httpServletRequest, httpServletResponse, (String)modulePath);
                    if (requestDispatcher == null) {
                        httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                        httpServletResponse.setStatus(404);
                        return;
                    }
                    bytes = this.getResourceContent(requestDispatcher, httpServletRequest, httpServletResponse, (String)modulePath, minifierType);
                }
                if (bytes == null) {
                    cacheEnabled = false;
                    bytes = _EMPTY_FILE_CONTENT_BAG._fileContent;
                    httpServletResponse.setHeader("Cache-Control", "max-age=1, no-cache");
                }
                byArrayArray[i] = bytes;
            }
            if (cacheEnabled && modulePathsString != null && !PropsValues.COMBO_CHECK_TIMESTAMP) {
                _bytesArrayPortalCache.put((Serializable)((Object)modulePathsString), (Object)byArrayArray);
            }
        }
        String contentType = "text/javascript";
        if (StringUtil.equalsIgnoreCase((String)minifierType, (String)_CSS_EXTENSION)) {
            contentType = "text/css; charset=UTF-8";
        }
        httpServletResponse.setContentType(contentType);
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (byte[][])var11_24);
    }

    protected byte[] getResourceContent(RequestDispatcher requestDispatcher, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String modulePath, String minifierType) throws Exception {
        String fileContentKey;
        FileContentBag fileContentBag;
        String portletId;
        Portlet portlet;
        String resourcePath = ComboServlet.getResourcePath(modulePath);
        if (!resourcePath.startsWith((portlet = PortletLocalServiceUtil.getPortletById((String)(portletId = ComboServlet.getModulePortletId(modulePath)))).getContextPath())) {
            resourcePath = portlet.getContextPath() + resourcePath;
        }
        if ((fileContentBag = (FileContentBag)_fileContentBagPortalCache.get((Serializable)((Object)(fileContentKey = StringBundler.concat((String[])new String[]{resourcePath, "?", minifierType, "&languageId=", ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"languageId")}))))) != null && !PropsValues.COMBO_CHECK_TIMESTAMP) {
            return fileContentBag._fileContent;
        }
        if (fileContentBag != null && PropsValues.COMBO_CHECK_TIMESTAMP) {
            long lastModified;
            long elapsedTime = System.currentTimeMillis() - fileContentBag._lastModified;
            if (requestDispatcher != null && elapsedTime <= PropsValues.COMBO_CHECK_TIMESTAMP_INTERVAL && (lastModified = RequestDispatcherUtil.getLastModifiedTime((RequestDispatcher)requestDispatcher, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse)) == fileContentBag._lastModified) {
                return fileContentBag._fileContent;
            }
            _fileContentBagPortalCache.remove((Serializable)((Object)fileContentKey));
        }
        if (requestDispatcher == null) {
            fileContentBag = _EMPTY_FILE_CONTENT_BAG;
        } else {
            BufferCacheServletResponse bufferCacheServletResponse = RequestDispatcherUtil.getBufferCacheServletResponse((RequestDispatcher)requestDispatcher, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            String cacheControl = GetterUtil.getString((String)bufferCacheServletResponse.getHeader("Cache-Control"));
            String contentType = GetterUtil.getString((String)bufferCacheServletResponse.getContentType());
            int status = bufferCacheServletResponse.getStatus();
            if (status != 200) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Skip ", modulePath, " because it returns HTTP status ", status}));
                return null;
            }
            if (!(contentType.startsWith("application/javascript") || contentType.startsWith("text/css") || contentType.startsWith("text/javascript"))) {
                _log.error((Object)("Skip " + modulePath + " because its content type is not CSS or JavaScript"));
                return null;
            }
            if (cacheControl.contains("no-cache") || cacheControl.contains("no-store")) {
                _log.error((Object)("Skip " + modulePath + " because it sent no-cache or no-store headers"));
                return null;
            }
            String stringFileContent = bufferCacheServletResponse.getString();
            if (!(StringUtil.endsWith((String)resourcePath, (String)_CSS_MINIFIED_DASH_SUFFIX) || StringUtil.endsWith((String)resourcePath, (String)_CSS_MINIFIED_DOT_SUFFIX) || StringUtil.endsWith((String)resourcePath, (String)_JAVASCRIPT_MINIFIED_DASH_SUFFIX) || StringUtil.endsWith((String)resourcePath, (String)_JAVASCRIPT_MINIFIED_DOT_SUFFIX))) {
                if (minifierType.equals(_CSS_EXTENSION)) {
                    try {
                        stringFileContent = DynamicCSSUtil.replaceToken(this.getServletContext(), httpServletRequest, stringFileContent);
                    }
                    catch (Exception exception) {
                        _log.error((Object)("Unable to replace tokens in CSS " + resourcePath), (Throwable)exception);
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)stringFileContent);
                        }
                        httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                    }
                    String baseURL = "";
                    int slashIndex = resourcePath.lastIndexOf(47);
                    if (slashIndex != -1) {
                        baseURL = resourcePath.substring(0, slashIndex + 1);
                    }
                    baseURL = PortalUtil.getPathProxy() + baseURL;
                    if (StringUtil.contains((String)stringFileContent, (String)_CSS_CHARSET_UTF_8, (String)"")) {
                        stringFileContent = StringUtil.removeSubstring((String)stringFileContent, (String)_CSS_CHARSET_UTF_8);
                    }
                    stringFileContent = AggregateUtil.updateRelativeURLs(stringFileContent, baseURL);
                    stringFileContent = FrontendSourceMapUtil.stripCSSSourceMapping((String)stringFileContent);
                    stringFileContent = MinifierUtil.minifyCss(stringFileContent);
                } else if (minifierType.equals("js")) {
                    Matcher matcher = _importModulePattern.matcher(stringFileContent);
                    stringFileContent = matcher.matches() ? matcher.group(1) + "../o/" + matcher.group(3) : MinifierUtil.minifyJavaScript(resourcePath, stringFileContent);
                    stringFileContent = FrontendSourceMapUtil.stripJSSourceMapping((String)stringFileContent);
                    stringFileContent = stringFileContent.concat("\n");
                }
            } else if (StringUtil.endsWith((String)resourcePath, (String)_JAVASCRIPT_MINIFIED_DASH_SUFFIX) || StringUtil.endsWith((String)resourcePath, (String)_JAVASCRIPT_MINIFIED_DOT_SUFFIX)) {
                stringFileContent = stringFileContent.concat("\n");
            }
            fileContentBag = new FileContentBag(stringFileContent.getBytes("UTF-8"), GetterUtil.getLong((String)bufferCacheServletResponse.getHeader("Last-Modified"), (long)-1L));
        }
        if (PropsValues.COMBO_CHECK_TIMESTAMP) {
            int timeToLive = (int)(PropsValues.COMBO_CHECK_TIMESTAMP_INTERVAL / 1000L);
            _fileContentBagPortalCache.put((Serializable)((Object)fileContentKey), (Object)fileContentBag, timeToLive);
        }
        return fileContentBag._fileContent;
    }

    protected RequestDispatcher getResourceRequestDispatcher(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String modulePath) throws Exception {
        String portletId = ComboServlet.getModulePortletId(modulePath);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletId);
        if (portlet == null || portlet.isUndeployedPortlet()) {
            return null;
        }
        String resourcePath = ComboServlet.getResourcePath(modulePath);
        if (!StringUtil.startsWith((String)resourcePath, (char)'/') || !PortalUtil.isValidResourceId((String)resourcePath)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Invalid resource ", httpServletRequest.getRequestURL(), "?", httpServletRequest.getQueryString()}));
            }
            return null;
        }
        PortletApp portletApp = portlet.getPortletApp();
        ServletContext servletContext = portletApp.getServletContext();
        return servletContext.getRequestDispatcher(resourcePath);
    }

    protected boolean validateModuleExtension(String moduleName) throws Exception {
        String[] fileExtensions;
        int index = (moduleName = ComboServlet.getResourcePath(moduleName)).indexOf(63);
        if (index != -1) {
            moduleName = moduleName.substring(0, index);
        }
        if (moduleName.startsWith("/documents/d/")) {
            return true;
        }
        boolean validModuleExtension = false;
        for (String fileExtension : fileExtensions = PrefsPropsUtil.getStringArray((String)"combo.allowed.file.extensions", (String)",")) {
            if (!"*".equals(fileExtension) && !StringUtil.endsWith((String)moduleName, (String)fileExtension)) continue;
            validModuleExtension = true;
            break;
        }
        return validModuleExtension;
    }

    private String _canonicalizePath(String path) {
        if (!path.contains(".")) {
            return path;
        }
        ArrayList<String> canonicalParts = new ArrayList<String>();
        String[] parts = StringUtil.split((String)path, (String)"/");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i != 0 && Validator.isBlank((String)part) || part.equals(".")) continue;
            if (part.equals("..")) {
                if (canonicalParts.isEmpty()) {
                    return null;
                }
                canonicalParts.remove(canonicalParts.size() - 1);
                continue;
            }
            canonicalParts.add(part);
        }
        return StringUtil.merge(canonicalParts, (String)"/");
    }

    private String _getModulePathExtension(String modulePath) {
        String resourcePath = ComboServlet.getResourcePath(modulePath);
        int index = resourcePath.indexOf(63);
        if (index != -1) {
            resourcePath = resourcePath.substring(0, index);
        }
        return FileUtil.getExtension((String)resourcePath);
    }

    private static class FileContentBag
    implements Serializable {
        private final byte[] _fileContent;
        private final long _lastModified;

        public FileContentBag(byte[] fileContent, long lastModified) {
            this._fileContent = fileContent;
            this._lastModified = lastModified;
        }
    }
}

