/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleManager;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionExecutorThreadLocal;
import com.liferay.portal.spring.transaction.TransactionStatusAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;

public class DefaultTransactionExecutor
implements TransactionExecutor {
    private final PlatformTransactionManager _platformTransactionManager;

    public DefaultTransactionExecutor(PlatformTransactionManager platformTransactionManager) {
        this._platformTransactionManager = platformTransactionManager;
    }

    @Override
    public void commit(TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) {
        Throwable transactionManagerThrowable = null;
        try {
            this._platformTransactionManager.commit(transactionStatusAdapter.getTransactionStatus());
        }
        catch (Throwable throwable) {
            transactionManagerThrowable = throwable;
            throw throwable;
        }
        finally {
            if (transactionManagerThrowable == null) {
                TransactionLifecycleManager.fireTransactionCommittedEvent((TransactionAttribute)transactionAttributeAdapter, (TransactionStatus)transactionStatusAdapter);
            } else {
                TransactionLifecycleManager.fireTransactionRollbackedEvent((TransactionAttribute)transactionAttributeAdapter, (TransactionStatus)transactionStatusAdapter, (Throwable)transactionManagerThrowable);
            }
            TransactionExecutorThreadLocal.popTransactionExecutor();
            transactionStatusAdapter.reportLifecycleListenerThrowables(transactionManagerThrowable);
        }
    }

    @Override
    public <T> T execute(TransactionAttributeAdapter transactionAttributeAdapter, UnsafeSupplier<T, Throwable> unsafeSupplier) throws Throwable {
        TransactionStatusAdapter transactionStatusAdapter = this.start(transactionAttributeAdapter);
        Object returnValue = null;
        try {
            returnValue = unsafeSupplier.get();
        }
        catch (Throwable throwable) {
            this.rollback(throwable, transactionAttributeAdapter, transactionStatusAdapter);
        }
        this.commit(transactionAttributeAdapter, transactionStatusAdapter);
        return (T)returnValue;
    }

    @Override
    public PlatformTransactionManager getPlatformTransactionManager() {
        return this._platformTransactionManager;
    }

    @Override
    public void rollback(Throwable throwable1, TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) throws Throwable {
        boolean rollback = transactionAttributeAdapter.rollbackOn(throwable1);
        Throwable transactionManagerThrowable = null;
        try {
            try {
                if (rollback) {
                    this._platformTransactionManager.rollback(transactionStatusAdapter.getTransactionStatus());
                } else {
                    this._platformTransactionManager.commit(transactionStatusAdapter.getTransactionStatus());
                }
                throw throwable1;
            }
            catch (Throwable throwable2) {
                if (throwable2 != throwable1) {
                    throwable2.addSuppressed(throwable1);
                    transactionManagerThrowable = throwable2;
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable) {
            if (rollback) {
                TransactionLifecycleManager.fireTransactionRollbackedEvent((TransactionAttribute)transactionAttributeAdapter, (TransactionStatus)transactionStatusAdapter, (Throwable)throwable1);
            } else if (transactionManagerThrowable == null) {
                TransactionLifecycleManager.fireTransactionCommittedEvent((TransactionAttribute)transactionAttributeAdapter, (TransactionStatus)transactionStatusAdapter);
            } else {
                TransactionLifecycleManager.fireTransactionRollbackedEvent((TransactionAttribute)transactionAttributeAdapter, (TransactionStatus)transactionStatusAdapter, transactionManagerThrowable);
            }
            TransactionExecutorThreadLocal.popTransactionExecutor();
            if (transactionManagerThrowable == null) {
                transactionStatusAdapter.reportLifecycleListenerThrowables(throwable1);
            } else {
                transactionStatusAdapter.reportLifecycleListenerThrowables(transactionManagerThrowable);
            }
            throw throwable;
        }
    }

    @Override
    public TransactionStatusAdapter start(TransactionAttributeAdapter transactionAttributeAdapter) {
        TransactionStatusAdapter transactionStatusAdapter = new TransactionStatusAdapter(this._platformTransactionManager.getTransaction((TransactionDefinition)transactionAttributeAdapter));
        TransactionExecutorThreadLocal.pushTransactionExecutor(this);
        TransactionLifecycleManager.fireTransactionCreatedEvent((TransactionAttribute)transactionAttributeAdapter, (TransactionStatus)transactionStatusAdapter);
        return transactionStatusAdapter;
    }
}

