/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.upgrade.v6_2_0.BaseAttachmentsUpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;

public class UpgradeWikiAttachments
extends BaseAttachmentsUpgradeProcess {
    @Override
    protected String getClassName() {
        return "com.liferay.portlet.wiki.model.WikiPage";
    }

    @Override
    protected long getContainerModelFolderId(long groupId, long companyId, long resourcePrimKey, long containerModelId, long userId, String userName, Timestamp createDate) throws Exception {
        long repositoryId = this.getRepositoryId(groupId, companyId, userId, userName, createDate, this.getClassNameId(), this.getPortletId());
        long repositoryFolderId = this.getFolderId(groupId, companyId, userId, userName, createDate, repositoryId, 0L, this.getPortletId(), false);
        long nodeFolderId = this.getFolderId(groupId, companyId, userId, userName, createDate, repositoryId, repositoryFolderId, String.valueOf(containerModelId), false);
        return this.getFolderId(groupId, companyId, userId, userName, createDate, repositoryId, nodeFolderId, String.valueOf(resourcePrimKey), false);
    }

    @Override
    protected String getDirName(long containerModelId, long resourcePrimKey) {
        return "wiki/" + resourcePrimKey;
    }

    @Override
    protected String getPortletId() {
        return "36";
    }

    @Override
    protected void updateAttachments() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(4);
            sb.append("select resourcePrimKey, groupId, companyId, ");
            sb.append("MIN(userId) as userId, MIN(userName) as userName, ");
            sb.append("nodeId from WikiPage group by resourcePrimKey, ");
            sb.append("groupId, companyId, nodeId");
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(sb.toString());
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long resourcePrimKey = resultSet.getLong("resourcePrimKey");
                    long groupId = resultSet.getLong("groupId");
                    long companyId = resultSet.getLong("companyId");
                    long userId = resultSet.getLong("userId");
                    String userName = resultSet.getString("userName");
                    long nodeId = resultSet.getLong("nodeId");
                    this.updateEntryAttachments(companyId, groupId, resourcePrimKey, nodeId, userId, userName);
                }
            }
        }
    }
}

