/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class JavaFieldsParser {
    private static final Log _log = LogFactoryUtil.getLog(JavaFieldsParser.class);

    public static String parse(ClassLoader classLoader, String s) {
        int y;
        int x = s.indexOf("${");
        if (x == -1) {
            return s;
        }
        ArrayList<String> replaceFrom = new ArrayList<String>();
        ArrayList<String> replaceWith = new ArrayList<String>();
        while (x != -1 && (y = s.indexOf("}", x)) != -1) {
            String fieldValue;
            String javaSnippet;
            block10: {
                javaSnippet = s.substring(x + 2, y);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Java snippet " + javaSnippet));
                }
                String className = JavaFieldsParser._getClassName(javaSnippet);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Class name " + className));
                }
                if (className == null) break;
                Class<?> clazz = null;
                try {
                    clazz = classLoader.loadClass(className);
                }
                catch (Exception exception) {
                    _log.error((Object)("Unable to load class " + className), (Throwable)exception);
                    break;
                }
                String fieldName = JavaFieldsParser._getFieldName(javaSnippet);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Field name " + fieldName));
                }
                if (fieldName == null) break;
                fieldValue = null;
                try {
                    Field field = clazz.getField(fieldName);
                    fieldValue = String.valueOf(field.get(null));
                    if (!_log.isDebugEnabled()) break block10;
                    _log.debug((Object)("Field value " + fieldValue));
                }
                catch (Exception exception) {
                    _log.error((Object)("Unable to load field " + fieldName), (Throwable)exception);
                    break;
                }
            }
            replaceFrom.add(StringBundler.concat((String[])new String[]{"${", javaSnippet, "}"}));
            replaceWith.add(fieldValue);
            x = s.indexOf("${", y);
        }
        if (replaceFrom.isEmpty()) {
            return s;
        }
        return StringUtil.replace((String)s, (String[])replaceFrom.toArray(new String[0]), (String[])replaceWith.toArray(new String[0]));
    }

    private static String _getClassName(String javaSnippet) {
        int x = javaSnippet.lastIndexOf(".");
        if (x == -1) {
            return null;
        }
        return javaSnippet.substring(0, x);
    }

    private static String _getFieldName(String javaSnippet) {
        int x = javaSnippet.lastIndexOf(".");
        if (x == -1) {
            return null;
        }
        return javaSnippet.substring(x + 1);
    }
}

