/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.webdav.methods.Method;
import javax.servlet.http.HttpServletRequest;

public class MoveMethodImpl
implements Method {
    private static final Log _log = LogFactoryUtil.getLog(MoveMethodImpl.class);

    public int process(WebDAVRequest webDAVRequest) throws WebDAVException {
        WebDAVStorage storage = webDAVRequest.getWebDAVStorage();
        HttpServletRequest httpServletRequest = webDAVRequest.getHttpServletRequest();
        String destination = WebDAVUtil.getDestination((HttpServletRequest)httpServletRequest, (String)storage.getRootPath());
        StringBundler sb = null;
        if (_log.isInfoEnabled()) {
            sb = new StringBundler(4);
            sb.append("Destination is ");
            sb.append(destination);
        }
        if (!destination.equals(webDAVRequest.getPath()) && WebDAVUtil.getGroupId((long)webDAVRequest.getCompanyId(), (String)destination) == webDAVRequest.getGroupId()) {
            Resource resource = storage.getResource(webDAVRequest);
            if (resource == null) {
                return 404;
            }
            boolean overwrite = WebDAVUtil.isOverwrite((HttpServletRequest)httpServletRequest);
            if (_log.isInfoEnabled()) {
                sb.append(", overwrite is ");
                sb.append(overwrite);
                _log.info((Object)sb.toString());
            }
            if (resource.isCollection()) {
                return storage.moveCollectionResource(webDAVRequest, resource, destination, overwrite);
            }
            return storage.moveSimpleResource(webDAVRequest, resource, destination, overwrite);
        }
        return 403;
    }
}

